/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.util.ldiff.Block;
import com.sleepycat.je.rep.util.ldiff.DiffRecordAnalyzer;
import com.sleepycat.je.rep.util.ldiff.LDiff;
import com.sleepycat.je.rep.util.ldiff.LDiffConfig;
import com.sleepycat.je.rep.util.ldiff.LDiffRecordRequestException;
import com.sleepycat.je.rep.util.ldiff.Protocol;
import com.sleepycat.je.rep.util.ldiff.Record;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;

public class LDiffService
extends ServiceDispatcher.ExecutingService {
    public static final String NAME = "LDiff";
    private final AtomicBoolean busy = new AtomicBoolean(false);
    private final RepImpl repImpl;
    private final ServiceDispatcher dispatcher;

    public LDiffService(ServiceDispatcher dispatcher, RepImpl repImpl) {
        super(NAME, dispatcher);
        this.repImpl = repImpl;
        this.dispatcher = dispatcher;
        dispatcher.register(this);
    }

    public void shutdown() {
        this.dispatcher.cancel(NAME);
    }

    @Override
    public boolean isBusy() {
        return this.busy.get();
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        if (!this.busy.compareAndSet(false, true)) {
            throw EnvironmentFailureException.unexpectedState("Service is already busy");
        }
        return new LDiffServiceRunnable(dataChannel);
    }

    class LDiffServiceRunnable
    implements Runnable {
        final DataChannel channel;
        private ReplicatedEnvironment env;
        private DatabaseConfig dbConfig = new DatabaseConfig();

        LDiffServiceRunnable(DataChannel dataChannel) {
            this.channel = dataChannel;
            this.dbConfig.setReadOnly(true);
            this.dbConfig.setAllowCreate(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runLDiff(Protocol.DbBlocks request, Protocol protocol) throws IOException {
            Database db = null;
            Cursor cursor = null;
            try {
                db = this.env.openDatabase(null, request.getDbName(), this.dbConfig);
                protocol.write((BinaryProtocol.Message)protocol.new Protocol.BlockListStart(), this.channel);
                LDiffConfig cfg = new LDiffConfig();
                cfg.setBlockSize(request.getBlockSize());
                LDiff ldf = new LDiff(cfg);
                Iterator<Block> blocks = ldf.iterator(db);
                while (blocks.hasNext()) {
                    Protocol protocol2 = protocol;
                    protocol2.getClass();
                    protocol.write((BinaryProtocol.Message)protocol2.new Protocol.BlockInfo(blocks.next()), this.channel);
                }
                protocol.write((BinaryProtocol.Message)protocol.new Protocol.BlockListEnd(), this.channel);
                BinaryProtocol.Message msg = protocol.read(this.channel);
                if (msg.getOp() == Protocol.REMOTE_DIFF_REQUEST) {
                    cursor = db.openCursor(null, null);
                    this.sendDiffArea(cursor, (Protocol.RemoteDiffRequest)msg, protocol);
                    this.runDiffAnalysis(cursor, protocol);
                } else if (msg.getOp() != Protocol.DONE) {
                    Protocol protocol3 = protocol;
                    protocol3.getClass();
                    protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol3.new BinaryProtocol.ProtocolError("Invalid message: " + msg), this.channel);
                }
            }
            catch (DatabaseNotFoundException e) {
                Protocol protocol4 = protocol;
                protocol4.getClass();
                protocol.write((BinaryProtocol.Message)protocol4.new Protocol.DbMismatch(e.getMessage()), this.channel);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                if (db != null) {
                    db.close();
                }
            }
        }

        private void runDiffAnalysis(Cursor cursor, Protocol protocol) throws IOException {
            block1: {
                BinaryProtocol.Message msg;
                while ((msg = protocol.read(this.channel)).getOp() == Protocol.REMOTE_DIFF_REQUEST) {
                    this.sendDiffArea(cursor, (Protocol.RemoteDiffRequest)msg, protocol);
                }
                if (msg.getOp() == Protocol.DONE) break block1;
                Protocol protocol2 = protocol;
                protocol2.getClass();
                protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol2.new BinaryProtocol.ProtocolError("Invalid message: " + msg), this.channel);
            }
        }

        private void sendDiffArea(Cursor cursor, Protocol.RemoteDiffRequest request, Protocol protocol) throws IOException {
            HashSet<Record> records = null;
            try {
                records = DiffRecordAnalyzer.getDiffArea(cursor, request);
            }
            catch (Exception e) {
                Protocol protocol2 = protocol;
                protocol2.getClass();
                protocol.write((BinaryProtocol.Message)protocol2.new Protocol.Error(e.getMessage()), this.channel);
                throw new LDiffRecordRequestException(e.getMessage());
            }
            protocol.write((BinaryProtocol.Message)protocol.new Protocol.DiffAreaStart(), this.channel);
            for (Record record : records) {
                Protocol protocol3 = protocol;
                protocol3.getClass();
                protocol.write((BinaryProtocol.Message)protocol3.new Protocol.RemoteRecord(record), this.channel);
            }
            protocol.write((BinaryProtocol.Message)protocol.new Protocol.DiffAreaEnd(), this.channel);
        }

        public void runEnvDiff(Protocol.EnvDiff request, Protocol protocol) throws IOException {
            Protocol protocol2 = protocol;
            protocol2.getClass();
            protocol.write((BinaryProtocol.Message)protocol2.new Protocol.EnvInfo(this.env.getDatabaseNames().size()), this.channel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServiceDispatcher.ExecutingService.ensureChannelBlocking(this.channel);
            try {
                this.env = LDiffService.this.repImpl.makeEnvironment();
                Protocol protocol = new Protocol(new NameIdPair("Ldiff", -1), LDiffService.this.repImpl);
                try {
                    BinaryProtocol.Message msg = protocol.read(this.channel);
                    if (msg.getOp() == Protocol.DB_BLOCKS) {
                        this.runLDiff((Protocol.DbBlocks)msg, protocol);
                    } else if (msg.getOp() == Protocol.ENV_DIFF) {
                        this.runEnvDiff((Protocol.EnvDiff)msg, protocol);
                    }
                }
                catch (BinaryProtocol.ProtocolException e) {
                    Protocol protocol2 = protocol;
                    protocol2.getClass();
                    protocol.write((BinaryProtocol.Message)(BinaryProtocol)protocol2.new BinaryProtocol.ProtocolError(e.getMessage()), this.channel);
                }
                finally {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
            }
            catch (IOException iOException) {
                if (this.env != null) {
                    this.env.close();
                }
                if (!LDiffService.this.busy.compareAndSet(true, false)) {
                    throw EnvironmentFailureException.unexpectedState("Service is not busy");
                }
            }
            finally {
                if (this.env != null) {
                    this.env.close();
                }
                if (!LDiffService.this.busy.compareAndSet(true, false)) {
                    throw EnvironmentFailureException.unexpectedState("Service is not busy");
                }
            }
        }
    }
}

