/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.RollbackException;
import com.sleepycat.je.rep.RollbackProhibitedException;
import com.sleepycat.je.rep.SyncupProgress;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.Replay;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.cbvlsn.LocalCBVLSNTracker;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.InputWireRecord;
import com.sleepycat.je.rep.stream.MatchpointSearchResults;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.stream.ReplicaSyncupReader;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.rep.vlsn.VLSNIndex;
import com.sleepycat.je.rep.vlsn.VLSNRange;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaFeederSyncup {
    private final Logger logger;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final RepNode repNode;
    private final VLSNIndex vlsnIndex;
    private final Replay replay;
    private final RepImpl repImpl;
    private ReplicaSyncupReader backwardsReader;
    private VLSN matchpointVLSN = VLSN.NULL_VLSN;
    private Long matchedVLSNTime = 0L;
    private final boolean hardRecoveryNeedsElection;
    private final MatchpointSearchResults searchResults;
    private static TestHook<Object> globalSyncupEndHook;
    private final TestHook<Object> syncupEndHook;
    private static com.sleepycat.je.utilint.TestHook<ReplicaFeederSyncup> rollbackHook;

    public ReplicaFeederSyncup(RepNode repNode, Replay replay, NamedChannel namedChannel, Protocol protocol, boolean hardRecoveryNeedsElection) {
        this.replay = replay;
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.repNode = repNode;
        this.vlsnIndex = repNode.getVLSNIndex();
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.repImpl = repNode.getRepImpl();
        this.hardRecoveryNeedsElection = hardRecoveryNeedsElection;
        this.searchResults = new MatchpointSearchResults(repNode.getRepImpl());
        this.syncupEndHook = repNode.replica().getReplicaFeederSyncupHook();
    }

    public long getMatchedVLSNTime() {
        return this.matchedVLSNTime;
    }

    public VLSN getMatchedVLSN() {
        return this.matchpointVLSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(LocalCBVLSNTracker cbvlsnTracker) throws IOException, DatabaseException, InterruptedException, InsufficientLogException, Replica.HardRecoveryElectionException {
        long startTime = System.currentTimeMillis();
        String feederName = this.namedChannel.getNameIdPair().getName();
        LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " syncup started. Replica range: " + this.repNode.getVLSNIndex().getRange());
        FileProtector.ProtectedFileSet protectedFileSet = this.repNode.syncupStarted(this.namedChannel.getNameIdPair());
        try {
            VLSNRange range = this.vlsnIndex.getRange();
            this.findMatchpoint(range);
            this.verifyRollback(range);
            this.replay.rollback(this.matchpointVLSN, this.searchResults.getMatchpointLSN());
            VLSN startVLSN = this.matchpointVLSN.getNext();
            this.vlsnIndex.truncateFromTail(startVLSN, this.searchResults.getMatchpointLSN());
            Protocol protocol = this.protocol;
            protocol.getClass();
            this.protocol.write((BinaryProtocol.Message)new BaseProtocol.StartStream(protocol, startVLSN, this.repImpl.getFeederFilter()), this.namedChannel);
            LoggerUtils.info(this.logger, this.repImpl, "Replica-feeder " + feederName + " start stream at VLSN: " + startVLSN);
            cbvlsnTracker.registerMatchpoint(this.matchpointVLSN);
        }
        catch (Throwable throwable) {
            assert (this.runHook());
            this.repNode.syncupEnded(protectedFileSet);
            LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
            this.repImpl.setSyncupProgress(SyncupProgress.END);
            throw throwable;
        }
        assert (this.runHook());
        this.repNode.syncupEnded(protectedFileSet);
        LoggerUtils.info(this.logger, this.repImpl, String.format("Replica-feeder " + feederName + " syncup ended. Elapsed time: %,dms", System.currentTimeMillis() - startTime));
        this.repImpl.setSyncupProgress(SyncupProgress.END);
    }

    private void verifyRollback(VLSNRange range) throws RollbackException, InsufficientLogException, Replica.HardRecoveryElectionException, IOException {
        this.repImpl.setSyncupProgress(SyncupProgress.CHECK_FOR_ROLLBACK);
        VLSN lastTxnEnd = range.getLastTxnEnd();
        VLSN lastSync = range.getLastSync();
        LoggerUtils.finest(this.logger, this.repImpl, "verify rollback vlsn range=" + range + " searchResults=" + this.searchResults);
        TestHookExecute.doHookIfSet(rollbackHook, this);
        if (lastTxnEnd.isNull()) {
            if (range.getLastSync().isNull() && !this.matchpointVLSN.isNull()) {
                throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to find a matchpoint of " + this.matchpointVLSN + " when the sync VLSN is null. Range=" + range);
            }
            LoggerUtils.fine(this.logger, this.repImpl, "normal rollback, no txn end");
            return;
        }
        if (lastSync.isNull()) {
            throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Shouldn't be possible to have a null sync VLSN when the  lastTxnVLSN " + lastTxnEnd + " is not null. Range=" + range);
        }
        if (this.matchpointVLSN.isNull()) {
            LoggerUtils.info(this.logger, this.repImpl, "This node had a txn end at vlsn = " + lastTxnEnd + "but no matchpoint found.");
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        if (lastTxnEnd.compareTo(this.matchpointVLSN) <= 0 && this.searchResults.getNumPassedCommits() == 0) {
            LoggerUtils.fine(this.logger, this.repImpl, "txn end vlsn of " + lastTxnEnd + "<= matchpointVLSN of " + this.matchpointVLSN + ", normal rollback");
            return;
        }
        if (this.hardRecoveryNeedsElection) {
            throw new Replica.HardRecoveryElectionException(this.repNode.getMasterStatus().getNodeMasterNameId(), lastTxnEnd, this.matchpointVLSN);
        }
        if (this.searchResults.getPassedCheckpointEnd()) {
            LoggerUtils.info(this.logger, this.repImpl, "matchpointVLSN of " + this.matchpointVLSN + " precedes a checkpoint end, needs network restore.");
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        if (this.searchResults.getSkippedGap()) {
            LoggerUtils.info(this.logger, this.repImpl, "matchpointVLSN of " + this.matchpointVLSN + " was found in a replica log with gaps. Since we can't be sure if it precedes a checkpoint end, do network restore.");
            throw this.setupLogRefresh(this.matchpointVLSN);
        }
        RepImpl envImpl = this.repNode.getRepImpl();
        DbConfigManager configMgr = envImpl.getConfigManager();
        int rollbackTxnLimit = configMgr.getInt(RepParams.TXN_ROLLBACK_LIMIT);
        boolean rollbackDisabled = configMgr.getBoolean(RepParams.TXN_ROLLBACK_DISABLED);
        int numPassedDurableCommits = this.searchResults.getNumPassedDurableCommits();
        int numPassedCommits = this.searchResults.getNumPassedCommits();
        long dtvlsn = this.searchResults.getDTVLSN().getSequence();
        LoggerUtils.info(this.logger, this.repImpl, String.format("Rollback info. Number of passed commits:%,d. (durable commits:%,d). Durable commit VLSN:%,d Rollback transaction limit:%,d", numPassedCommits, numPassedDurableCommits, dtvlsn, rollbackTxnLimit));
        if (numPassedDurableCommits > rollbackTxnLimit || rollbackDisabled) {
            LoggerUtils.severe(this.logger, this.repImpl, "Limited list of transactions that would  be truncated for hard recovery:\n" + this.searchResults.dumpPassedTxns());
            throw new RollbackProhibitedException(this.repNode.getRepImpl(), rollbackTxnLimit, rollbackDisabled, this.matchpointVLSN, this.searchResults);
        }
        throw this.setupHardRecovery();
    }

    private void findMatchpoint(VLSNRange range) throws IOException, InsufficientLogException {
        int matchCounter = 0;
        this.repImpl.setSyncupProgress(SyncupProgress.FIND_MATCHPOINT, matchCounter++, -1L);
        VLSN candidateMatchpoint = range.getLastSync();
        if (candidateMatchpoint.equals(VLSN.NULL_VLSN)) {
            this.getFeederRecord(range, VLSN.FIRST_VLSN, false);
            return;
        }
        InputWireRecord feederRecord = this.getFeederRecord(range, candidateMatchpoint, true);
        candidateMatchpoint = feederRecord.getVLSN();
        if (this.logger.isLoggable(Level.FINE)) {
            LoggerUtils.fine(this.logger, this.repImpl, "first candidate matchpoint: " + candidateMatchpoint);
        }
        this.backwardsReader = this.setupBackwardsReader(candidateMatchpoint, this.repNode.getRepImpl().getFileManager().getLastUsedLsn());
        OutputWireRecord replicaRecord = this.getReplicaRecord(candidateMatchpoint);
        while (!replicaRecord.match(feederRecord)) {
            this.repImpl.setSyncupProgress(SyncupProgress.FIND_MATCHPOINT, matchCounter++, -1L);
            replicaRecord = this.scanMatchpointEntries();
            if (replicaRecord == null) {
                LoggerUtils.info(this.logger, this.repImpl, "Looking at candidate matchpoint vlsn " + candidateMatchpoint + " but this node went past its available contiguous VLSN range, need network restore.");
                throw this.setupLogRefresh(candidateMatchpoint);
            }
            candidateMatchpoint = replicaRecord.getVLSN();
            if (this.logger.isLoggable(Level.FINE)) {
                LoggerUtils.fine(this.logger, this.repImpl, "Next candidate matchpoint: " + candidateMatchpoint);
            }
            feederRecord = this.getFeederRecord(range, candidateMatchpoint, false);
        }
        this.matchedVLSNTime = replicaRecord.getTimeStamp();
        this.matchpointVLSN = candidateMatchpoint;
        this.searchResults.setMatchpoint(this.backwardsReader.getLastLsn());
        LoggerUtils.finest(this.logger, this.repImpl, "after setting  matchpoint, searchResults=" + this.searchResults);
    }

    private ReplicaSyncupReader setupBackwardsReader(VLSN startScanVLSN, long startScanLsn) {
        RepImpl envImpl = this.repNode.getRepImpl();
        int readBufferSize = envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        return new ReplicaSyncupReader((EnvironmentImpl)envImpl, this.repNode.getVLSNIndex(), startScanLsn, readBufferSize, startScanVLSN, DbLsn.makeLsn(this.vlsnIndex.getProtectedRangeStartFile(), 0), this.searchResults);
    }

    private OutputWireRecord getReplicaRecord(VLSN candidateMatchpoint) {
        OutputWireRecord replicaRecord = null;
        while (true) {
            try {
                replicaRecord = this.backwardsReader.scanBackwards(candidateMatchpoint);
                if (replicaRecord == null) {
                    throw EnvironmentFailureException.unexpectedState(this.repImpl, "Searching for candidate matchpoint " + candidateMatchpoint + " but got null record back ");
                }
                return replicaRecord;
            }
            catch (ReplicaSyncupReader.SkipGapException e) {
                VLSN gapRepositionVLSN = e.getVLSN();
                if (gapRepositionVLSN.compareTo(candidateMatchpoint) < 0) {
                    throw EnvironmentFailureException.unexpectedState("Gap reposition point of " + gapRepositionVLSN + " should always be >= candidate matchpoint VLSN of " + candidateMatchpoint);
                }
                long startScanLsn = this.vlsnIndex.getGTELsn(gapRepositionVLSN);
                this.backwardsReader = this.setupBackwardsReader(candidateMatchpoint, startScanLsn);
                this.searchResults.noteSkippedGap();
                continue;
            }
            break;
        }
    }

    private OutputWireRecord scanMatchpointEntries() {
        OutputWireRecord replicaRecord = null;
        boolean firstAttempt = true;
        while (true) {
            try {
                replicaRecord = this.backwardsReader.findPrevSyncEntry(firstAttempt);
                return replicaRecord;
            }
            catch (ReplicaSyncupReader.SkipGapException e) {
                VLSN gapRepositionVLSN = e.getVLSN();
                this.backwardsReader = this.setupBackwardsReader(gapRepositionVLSN, this.vlsnIndex.getGTELsn(gapRepositionVLSN));
                firstAttempt = false;
                this.searchResults.noteSkippedGap();
                continue;
            }
            break;
        }
    }

    private InsufficientLogException setupLogRefresh(VLSN failedMatchpoint) throws IOException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)new BaseProtocol.RestoreRequest((BaseProtocol)protocol, failedMatchpoint), this.namedChannel);
        BaseProtocol.RestoreResponse response = (BaseProtocol.RestoreResponse)this.protocol.read(this.namedChannel);
        return new InsufficientLogException(this.repNode, new HashSet<ReplicationNode>(Arrays.asList(response.getLogProviders())));
    }

    public RollbackException setupHardRecovery() throws IOException {
        RollbackException r = new RollbackException(this.repImpl, this.matchpointVLSN, this.searchResults);
        LoggerUtils.severe(this.logger, this.repImpl, "Limited list of transactions truncated for hard recovery:\n" + this.searchResults.dumpPassedTxns());
        long matchpointLSN = this.searchResults.getMatchpointLSN();
        this.repImpl.getFileManager().truncateLog(DbLsn.getFileNumber(matchpointLSN), DbLsn.getFileOffset(matchpointLSN));
        return r;
    }

    private InputWireRecord getFeederRecord(VLSNRange range, VLSN requestVLSN, boolean acceptAlternative) throws IOException, InsufficientLogException {
        Protocol protocol = this.protocol;
        protocol.getClass();
        this.protocol.write((BinaryProtocol.Message)new BaseProtocol.EntryRequest((BaseProtocol)protocol, requestVLSN), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof BaseProtocol.Entry) {
            BaseProtocol.Entry entry = (BaseProtocol.Entry)message;
            return entry.getWireRecord();
        }
        if (message instanceof BaseProtocol.EntryNotFound) {
            LoggerUtils.info(this.logger, this.repImpl, "Requested " + requestVLSN + " from " + this.namedChannel.getNameIdPair() + " but that node did not have that vlsn.");
            throw this.setupLogRefresh(requestVLSN);
        }
        if (acceptAlternative && message instanceof BaseProtocol.AlternateMatchpoint) {
            BaseProtocol.AlternateMatchpoint alt = (BaseProtocol.AlternateMatchpoint)message;
            InputWireRecord feederRecord = alt.getAlternateWireRecord();
            VLSN altMatchpoint = feederRecord.getVLSN();
            if (range.getFirst().compareTo(altMatchpoint) > 0) {
                throw this.setupLogRefresh(altMatchpoint);
            }
            return feederRecord;
        }
        throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "Sent EntryRequest, got unexpected response of " + message);
    }

    public static void setGlobalSyncupEndHook(TestHook<Object> syncupEndHook) {
        globalSyncupEndHook = syncupEndHook;
    }

    private boolean runHook() throws InterruptedException {
        if (this.syncupEndHook != null) {
            this.syncupEndHook.doHook();
        }
        if (globalSyncupEndHook != null) {
            globalSyncupEndHook.doHook();
        }
        return true;
    }

    public static void setRollbackTestHook(com.sleepycat.je.utilint.TestHook<ReplicaFeederSyncup> rollbackHook) {
        ReplicaFeederSyncup.rollbackHook = rollbackHook;
    }

    public static interface TestHook<T> {
        public void doHook() throws InterruptedException;
    }
}

