/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util;

import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.util.ReplicationGroupAdmin;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.net.DataChannelFactoryBuilder;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.PropUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;

public class DbGroupAdmin {
    private String groupName;
    private Set<InetSocketAddress> helperSockets;
    private String nodeName;
    private String newHostName;
    private int newPort;
    private String timeout;
    private boolean forceFlag;
    private DataChannelFactory channelFactory;
    private ReplicationGroupAdmin groupAdmin;
    private final ArrayList<Command> actions = new ArrayList();
    private static final String undocumentedUsageString = "  -netProps <optional>   # name of a property file containing\n                            # properties needed for replication\n                            # service access\n";
    private static final String usageString = "Usage: " + CmdUtil.getJavaCommand(DbGroupAdmin.class) + "\n  -groupName <group name>   # name of replication group\n  -helperHosts <host:port>  # identifier for one or more members\n                            # of the replication group which can\n                            # be contacted for group information,\n                            # in this format:\n                            # hostname[:port][,hostname[:port]]\n  -dumpGroup                # dump group information\n  -removeMember <node name> # node to be removed\n  -updateAddress <node name> <new host:port>\n                            # update the network address for a\n                            # specified node.  The node should not\n                            # be alive when updating the address\n  -transferMaster [-force] <node1,node2,...> <timeout>\n                            # transfer master role to one of the\n                            # specified nodes.";

    public static void main(String ... args) throws Exception {
        DbGroupAdmin admin = new DbGroupAdmin();
        admin.parseArgs(args);
        admin.run();
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println(usageString);
        System.exit(-1);
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        String netPropsName = null;
        if (nArgs == 0) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-helperHosts")) {
                if (argc < nArgs) {
                    this.helperSockets = HostPortPair.getSockets(argv[argc++]);
                    continue;
                }
                this.printUsage("-helperHosts requires an argument");
                continue;
            }
            if (thisArg.equals("-dumpGroup")) {
                this.actions.add(Command.DUMP);
                continue;
            }
            if (thisArg.equals("-removeMember")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    this.actions.add(Command.REMOVE);
                    continue;
                }
                this.printUsage("-removeMember requires an argument");
                continue;
            }
            if (thisArg.equals("-updateAddress")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    if (argc < nArgs) {
                        String hostPort;
                        int index;
                        if ((index = (hostPort = argv[argc++]).lastIndexOf(":")) < 0) {
                            this.printUsage("Host port pair format must be <host name>:<port number>");
                        }
                        this.newHostName = hostPort.substring(0, index);
                        this.newPort = Integer.parseInt(hostPort.substring(index + 1, hostPort.length()));
                    } else {
                        this.printUsage("-updateAddress requires a <host name>:<port number> argument");
                    }
                    this.actions.add(Command.UPDATE_ADDRESS);
                    continue;
                }
                this.printUsage("-updateAddress requires the node name argument");
                continue;
            }
            if (thisArg.equals("-transferMaster")) {
                if (argc < nArgs && "-force".equals(argv[argc])) {
                    this.forceFlag = true;
                    ++argc;
                }
                if (argc + 1 < nArgs) {
                    this.nodeName = argv[argc++];
                    if (argc + 1 < nArgs && argv[argc + 1].charAt(0) != '-') {
                        this.timeout = argv[argc] + " " + argv[argc + 1];
                        argc += 2;
                    } else {
                        this.timeout = argv[argc++];
                    }
                    this.actions.add(Command.TRANSFER_MASTER);
                    continue;
                }
                this.printUsage("-transferMaster requires at least two arguments");
                continue;
            }
            if (thisArg.equals("-netProps")) {
                if (argc < nArgs) {
                    netPropsName = argv[argc++];
                    continue;
                }
                this.printUsage("-netProps requires an argument");
                continue;
            }
            if (thisArg.equals("-deleteMember")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    this.actions.add(Command.DELETE);
                    continue;
                }
                this.printUsage("-deleteMember requires an argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        ReplicationNetworkConfig repNetConfig = ReplicationNetworkConfig.createDefault();
        if (netPropsName != null) {
            try {
                repNetConfig = ReplicationNetworkConfig.create(new File(netPropsName));
            }
            catch (FileNotFoundException fnfe) {
                this.printUsage("The net properties file " + netPropsName + " does not exist: " + fnfe.getMessage());
            }
            catch (IllegalArgumentException iae) {
                this.printUsage("The net properties file " + netPropsName + " is not valid: " + iae.getMessage());
            }
        }
        this.channelFactory = DbGroupAdmin.initializeFactory(repNetConfig, this.groupName);
    }

    private void run() throws Exception {
        this.createGroupAdmin();
        if (this.actions.size() == 0) {
            return;
        }
        block7: for (Command action : this.actions) {
            switch (action) {
                case DUMP: {
                    this.dumpGroup();
                    continue block7;
                }
                case REMOVE: {
                    this.removeMember(this.nodeName);
                    continue block7;
                }
                case TRANSFER_MASTER: {
                    this.transferMaster(this.nodeName, this.timeout);
                    continue block7;
                }
                case UPDATE_ADDRESS: {
                    this.updateAddress(this.nodeName, this.newHostName, this.newPort);
                    continue block7;
                }
                case DELETE: {
                    this.deleteMember(this.nodeName);
                    continue block7;
                }
            }
            throw new AssertionError();
        }
    }

    private DbGroupAdmin() {
    }

    public DbGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets) {
        this(groupName, helperSockets, (ReplicationNetworkConfig)null);
    }

    public DbGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets, File netPropsFile) throws FileNotFoundException {
        this(groupName, helperSockets, DbGroupAdmin.makeRepNetConfig(netPropsFile));
    }

    public DbGroupAdmin(String groupName, Set<InetSocketAddress> helperSockets, ReplicationNetworkConfig netConfig) {
        this.groupName = groupName;
        this.helperSockets = helperSockets;
        this.channelFactory = DbGroupAdmin.initializeFactory(netConfig, groupName);
        this.createGroupAdmin();
    }

    private void createGroupAdmin() {
        if (this.groupName == null) {
            this.printUsage("Group name must be specified");
        }
        if (this.helperSockets == null || this.helperSockets.size() == 0) {
            this.printUsage("Host and ports of helper nodes must be specified");
        }
        this.groupAdmin = new ReplicationGroupAdmin(this.groupName, this.helperSockets, this.channelFactory);
    }

    public void dumpGroup() {
        System.out.println(this.getFormattedOutput());
    }

    public void removeMember(String name) {
        if (name == null) {
            this.printUsage("Node name must be specified");
        }
        this.groupAdmin.removeMember(name);
    }

    public void deleteMember(String name) {
        if (name == null) {
            this.printUsage("Node name must be specified");
        }
        this.groupAdmin.deleteMember(name);
    }

    public void updateAddress(String nodeName, String newHostName, int newPort) {
        if (nodeName == null || newHostName == null) {
            this.printUsage("Node name and new host name must be specified");
        }
        if (newPort <= 0) {
            this.printUsage("Port of the new network address must be specified");
        }
        this.groupAdmin.updateAddress(nodeName, newHostName, newPort);
    }

    public void transferMaster(String nodeList, String timeout) {
        String result = this.groupAdmin.transferMaster(this.parseNodes(nodeList), PropUtil.parseDuration(timeout), TimeUnit.MILLISECONDS, this.forceFlag);
        System.out.println("The new master is: " + result);
    }

    private Set<String> parseNodes(String nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException("node list may not be null");
        }
        StringTokenizer st = new StringTokenizer(nodes, ",");
        HashSet<String> set = new HashSet<String>();
        while (st.hasMoreElements()) {
            set.add(st.nextToken());
        }
        return set;
    }

    private String getFormattedOutput() {
        StringBuilder sb = new StringBuilder();
        RepGroupImpl repGroupImpl = this.groupAdmin.getGroup().getRepGroupImpl();
        String masterName = this.groupAdmin.getMasterNodeName();
        sb.append("\nGroup: " + repGroupImpl.getName() + "\n");
        sb.append("Electable Members:\n");
        Set<RepNodeImpl> nodes = repGroupImpl.getElectableMembers();
        if (nodes.size() == 0) {
            sb.append("    No electable members\n");
        } else {
            for (RepNodeImpl node : nodes) {
                String type = masterName.equals(node.getName()) ? "master, " : "";
                sb.append("    " + node.getName() + " (" + type + node.getHostName() + ":" + node.getPort() + ", " + node.getBarrierState() + ")\n");
            }
        }
        sb.append("\nMonitor Members:\n");
        nodes = repGroupImpl.getMonitorMembers();
        if (nodes.size() == 0) {
            sb.append("    No monitors\n");
        } else {
            for (RepNodeImpl node : nodes) {
                sb.append("    " + node.getName() + " (" + node.getHostName() + ":" + node.getPort() + ")\n");
            }
        }
        sb.append("\nSecondary Members:\n");
        nodes = repGroupImpl.getSecondaryMembers();
        if (nodes.isEmpty()) {
            sb.append("    No secondary members\n");
        } else {
            for (RepNodeImpl node : nodes) {
                sb.append("    " + node.getName() + " (" + node.getHostName() + ":" + node.getPort() + ", " + node.getBarrierState() + ")\n");
            }
        }
        sb.append("\nExternal Members:\n");
        nodes = repGroupImpl.getExternalMembers();
        if (nodes.isEmpty()) {
            sb.append("    No external members\n");
        } else {
            for (RepNodeImpl node : nodes) {
                sb.append("    " + node.getName() + " (" + node.getHostName() + ":" + node.getPort() + ", " + node.getBarrierState() + ")\n");
            }
        }
        return sb.toString();
    }

    private static ReplicationNetworkConfig makeRepNetConfig(File propFile) throws FileNotFoundException {
        if (propFile == null) {
            return ReplicationNetworkConfig.createDefault();
        }
        return ReplicationNetworkConfig.create(propFile);
    }

    private static DataChannelFactory initializeFactory(ReplicationNetworkConfig repNetConfig, String logContext) {
        if (repNetConfig == null) {
            repNetConfig = ReplicationNetworkConfig.createDefault();
        }
        return DataChannelFactoryBuilder.construct(repNetConfig, logContext);
    }

    static enum Command {
        DUMP,
        REMOVE,
        TRANSFER_MASTER,
        UPDATE_ADDRESS,
        DELETE;

    }
}

