/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.SecondaryIntegrityException;
import java.util.Map;

public class CorruptSecondariesException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final Map<String, SecondaryIntegrityException> exceptions;

    public CorruptSecondariesException(Map<String, SecondaryIntegrityException> exceptions) {
        super(null, false, CorruptSecondariesException.makeMessage(exceptions), null);
        this.exceptions = exceptions;
    }

    private static String makeMessage(Map<String, SecondaryIntegrityException> exceptions) {
        StringBuilder s = new StringBuilder();
        s.append("Detected ").append(exceptions.size());
        s.append(" corrupt SecondaryDatabases.");
        for (SecondaryIntegrityException e : exceptions.values()) {
            s.append(" [").append(e).append("]");
        }
        return s.toString();
    }

    private CorruptSecondariesException(String message, CorruptSecondariesException cause) {
        super(message, cause);
        this.exceptions = cause.exceptions;
    }

    @Override
    public OperationFailureException wrapSelf(String msg) {
        return new CorruptSecondariesException(msg, this);
    }

    public Map<String, SecondaryIntegrityException> getSecondaryExceptions() {
        return this.exceptions;
    }
}

