/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.MasterStateException;
import com.sleepycat.je.rep.MasterTransferFailureException;
import com.sleepycat.je.rep.MemberActiveException;
import com.sleepycat.je.rep.MemberNotFoundException;
import com.sleepycat.je.rep.ReplicaStateException;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepGroupProtocol;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class GroupService
extends ServiceDispatcher.ExecutingService {
    final RepNode repNode;
    final RepGroupProtocol protocol;
    private final Collection<DataChannel> activeChannels = new ArrayList<DataChannel>();
    private final Logger logger;
    public static final String SERVICE_NAME = "Group";

    public GroupService(ServiceDispatcher dispatcher, RepNode repNode) {
        super(SERVICE_NAME, dispatcher);
        this.repNode = repNode;
        DbConfigManager configManager = repNode.getRepImpl().getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        this.protocol = new RepGroupProtocol(groupName, repNode.getNameIdPair(), repNode.getRepImpl(), repNode.getRepImpl().getChannelFactory());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void cancel() {
        ArrayList<DataChannel> channels;
        GroupService groupService = this;
        synchronized (groupService) {
            channels = new ArrayList<DataChannel>(this.activeChannels);
            this.activeChannels.clear();
        }
        if (!channels.isEmpty()) {
            LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "In-flight GroupService request(s) canceled: node shutdown");
        }
        for (DataChannel channel : channels) {
            try {
                PrintWriter out = new PrintWriter(Channels.newOutputStream(channel), true);
                RepGroupProtocol repGroupProtocol = this.protocol;
                repGroupProtocol.getClass();
                RepGroupProtocol.Fail rm = new RepGroupProtocol.Fail(repGroupProtocol, RepGroupProtocol.FailReason.DEFAULT, "shutting down");
                out.println(rm.wireFormat());
            }
            finally {
                if (!channel.isOpen()) continue;
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LoggerUtils.warning(this.logger, this.repNode.getRepImpl(), "IO error on channel close: " + e.getMessage());
                }
            }
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.GroupRequest groupRequest) {
        RepGroupImpl group = this.repNode.getGroup();
        if (group == null) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, groupRequest, RepGroupProtocol.FailReason.DEFAULT, "no group info yet");
        }
        RepGroupProtocol repGroupProtocol = this.protocol;
        repGroupProtocol.getClass();
        return new RepGroupProtocol.GroupResponse(repGroupProtocol, groupRequest, group);
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.EnsureNode ensureNode) {
        RepNodeImpl node = ensureNode.getNode();
        try {
            this.ensureMaster();
            this.repNode.getRepGroupDB().ensureMember(node);
            RepNodeImpl enode = this.repNode.getGroup().getMember(node.getName());
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.EnsureOK(repGroupProtocol, ensureNode, enode.getNameIdPair());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, ensureNode, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, ensureNode, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.RemoveMember removeMember) {
        String nodeName = removeMember.getNodeName();
        try {
            this.ensureMaster();
            this.repNode.removeMember(nodeName);
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return repGroupProtocol.new TextProtocol.OK(removeMember);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, removeMember, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, removeMember, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, removeMember, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, removeMember, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.DeleteMember deleteMember) {
        String nodeName = deleteMember.getNodeName();
        try {
            this.ensureMaster();
            this.repNode.removeMember(nodeName, true);
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return repGroupProtocol.new TextProtocol.OK(deleteMember);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, deleteMember, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, deleteMember, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, deleteMember, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (MemberActiveException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, deleteMember, RepGroupProtocol.FailReason.MEMBER_ACTIVE, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, deleteMember, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.UpdateAddress updateAddress) {
        try {
            this.ensureMaster();
            this.repNode.updateAddress(updateAddress.getNodeName(), updateAddress.getNewHostName(), updateAddress.getNewPort());
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return repGroupProtocol.new TextProtocol.OK(updateAddress);
        }
        catch (MemberNotFoundException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, updateAddress, RepGroupProtocol.FailReason.MEMBER_NOT_FOUND, e.getMessage());
        }
        catch (MasterStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, updateAddress, RepGroupProtocol.FailReason.IS_MASTER, e.getMessage());
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, updateAddress, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, updateAddress, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
    }

    public TextProtocol.ResponseMessage process(RepGroupProtocol.TransferMaster transferMaster) {
        try {
            this.ensureMaster();
            String nodeList = transferMaster.getNodeNameList();
            Set<String> replicas = this.parseNodeList(nodeList);
            long timeout = transferMaster.getTimeout();
            boolean force = transferMaster.getForceFlag();
            String winner = this.repNode.transferMaster(replicas, timeout, force);
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.TransferOK(repGroupProtocol, transferMaster, winner);
        }
        catch (ReplicaStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, transferMaster, RepGroupProtocol.FailReason.IS_REPLICA, e.getMessage());
        }
        catch (MasterTransferFailureException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, transferMaster, RepGroupProtocol.FailReason.TRANSFER_FAIL, e.getMessage());
        }
        catch (DatabaseException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, transferMaster, RepGroupProtocol.FailReason.DEFAULT, e.getMessage());
        }
        catch (IllegalArgumentException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, transferMaster, RepGroupProtocol.FailReason.DEFAULT, e.toString());
        }
        catch (IllegalStateException e) {
            RepGroupProtocol repGroupProtocol = this.protocol;
            repGroupProtocol.getClass();
            return new RepGroupProtocol.Fail(repGroupProtocol, transferMaster, RepGroupProtocol.FailReason.DEFAULT, e.toString());
        }
    }

    private Set<String> parseNodeList(String list) {
        HashSet<String> set = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(list, ",");
        while (st.hasMoreTokens()) {
            set.add(st.nextToken());
        }
        return set;
    }

    private void ensureMaster() throws ReplicaStateException {
        if (!this.repNode.isMaster()) {
            throw new ReplicaStateException("GroupService operation can only be performed at master");
        }
    }

    private synchronized void registerChannel(DataChannel dc) {
        this.activeChannels.add(dc);
    }

    private synchronized boolean unregisterChannel(DataChannel dc) {
        return this.activeChannels.remove(dc);
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new GroupServiceRunnable(dataChannel, this.protocol);
    }

    class GroupServiceRunnable
    extends ServiceDispatcher.ExecutingRunnable {
        GroupServiceRunnable(DataChannel dataChannel, RepGroupProtocol protocol) {
            super(dataChannel, protocol, true);
            GroupService.this.registerChannel(dataChannel);
        }

        @Override
        protected TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage request) throws IOException {
            TextProtocol.ResponseMessage rm = this.protocol.process(GroupService.this, request);
            return GroupService.this.unregisterChannel(this.channel) ? rm : null;
        }

        @Override
        protected void logMessage(String message) {
            LoggerUtils.warning(GroupService.this.logger, GroupService.this.repNode.getRepImpl(), message);
        }
    }
}

