/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.subscription.ServerAuthMethod;
import com.sleepycat.je.rep.subscription.StreamAuthenticator;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceHandshake;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import com.sleepycat.je.utilint.StoppableThreadFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServiceDispatcher
extends StoppableThread {
    private InetSocketAddress socketAddress;
    private final Selector selector;
    private SelectionKey scKey;
    private ServerSocketChannel serverChannel;
    private boolean processAcceptRequests = true;
    private int errorCount = 0;
    private final Map<String, Service> serviceMap = new ConcurrentHashMap<String, Service>();
    private final ExecutorService pool;
    private final Logger logger;
    private final Formatter formatter;
    private final RepImpl repImpl;
    private final DataChannelFactory channelFactory;
    private ServiceHandshake.AuthenticationMethod[] authOptions;

    public ServiceDispatcher(InetSocketAddress socketAddress, RepImpl repImpl, DataChannelFactory channelFactory) throws IOException {
        super(repImpl, "ServiceDispatcher-" + socketAddress.getHostName() + ":" + socketAddress.getPort());
        this.repImpl = repImpl;
        this.socketAddress = socketAddress;
        this.channelFactory = channelFactory;
        this.selector = Selector.open();
        String poolName = "ServiceDispatcherPool";
        NameIdPair nameIdPair = NameIdPair.NULL;
        if (repImpl == null) {
            this.logger = LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        } else {
            this.logger = LoggerUtils.getLogger(this.getClass());
            nameIdPair = repImpl.getNameIdPair();
            poolName = poolName + "_" + nameIdPair;
        }
        this.pool = Executors.newCachedThreadPool(new StoppableThreadFactory(poolName, this.logger));
        this.formatter = new ReplicationFormatter(nameIdPair);
        this.bindSocket();
        this.setAuthOptions();
    }

    private void bindSocket() throws IOException {
        int totalWaitMs;
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        this.scKey = this.serverChannel.register(this.selector, 16);
        ServerSocket acceptSocket = this.serverChannel.socket();
        acceptSocket.setSoTimeout(0);
        InetSocketAddress bindAddress = this.socketAddress;
        if (this.repImpl != null) {
            if (this.repImpl.getConfigManager().getBoolean(RepParams.SO_REUSEADDR)) {
                this.serverChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
                acceptSocket.setReuseAddress(true);
            }
            if (this.repImpl.getConfigManager().getBoolean(RepParams.BIND_INADDR_ANY)) {
                bindAddress = new InetSocketAddress((InetAddress)null, this.socketAddress.getPort());
            }
        }
        int limitMs = this.repImpl != null ? this.repImpl.getConfigManager().getInt(RepParams.SO_BIND_WAIT_MS) : 0;
        BindException bindException = null;
        int retryWaitMs = 1000;
        for (totalWaitMs = 0; totalWaitMs <= limitMs; totalWaitMs += 1000) {
            try {
                bindException = null;
                acceptSocket.bind(bindAddress);
                break;
            }
            catch (BindException be) {
                bindException = be;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    throw bindException;
                }
            }
        }
        if (bindException != null) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort() + " bind failed despite waiting for " + limitMs + "ms");
            if (limitMs > 0) {
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, RepUtils.exec("jps", "-v"));
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, RepUtils.exec("netstat", "-lntp"));
            }
            throw bindException;
        }
        if (totalWaitMs != 0) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort() + " become available after: " + totalWaitMs + "ms");
        }
    }

    public ServiceDispatcher(InetSocketAddress socketAddress, DataChannelFactory channelFactory) throws IOException {
        this(socketAddress, null, channelFactory);
    }

    public void preShutdown() {
        this.processAcceptRequests = false;
    }

    public void shutdown() {
        if (this.shutdownDone(this.logger)) {
            return;
        }
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher shutdown starting. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort() + " Registered services: " + this.serviceMap.keySet());
        this.shutdownThread(this.logger);
        for (String serviceName : this.serviceMap.keySet()) {
            this.cancel(serviceName);
        }
        this.pool.shutdownNow();
        try {
            this.serverChannel.socket().close();
            this.selector.close();
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Ignoring I/O error during close: " + LoggerUtils.exceptionTypeAndMsg(e));
        }
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher shutdown completed. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort());
    }

    @Override
    protected int initiateSoftShutdown() {
        this.selector.wakeup();
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    void logMsg(Level level, boolean noteError, String msg) {
        if (noteError) {
            ++this.errorCount;
        }
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, level, msg);
    }

    public static void doServiceHandshake(DataChannel channel, String serviceName) throws IOException, ServiceConnectFailedException {
        ServiceDispatcher.doServiceHandshake(channel, serviceName, null);
    }

    public static void doServiceHandshake(DataChannel channel, String serviceName, ServiceHandshake.AuthenticationMethod[] authInfo) throws IOException, ServiceConnectFailedException {
        ServiceHandshake.ClientHandshake handshake = new ServiceHandshake.ClientHandshake(serviceName, authInfo, new ServiceHandshake.ByteChannelIOAdapter(channel));
        Response response = handshake.process();
        if (response != Response.OK) {
            throw new ServiceConnectFailedException(serviceName, response);
        }
    }

    public DataChannel takeChannel(String serviceName, int soTimeout) throws InterruptedException {
        while (true) {
            Service service;
            if ((service = this.serviceMap.get(serviceName)) == null) {
                throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " was not registered");
            }
            if (!(service instanceof QueuingService)) {
                throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " is not a queuing service");
            }
            Socket socket = null;
            DataChannel channel = null;
            try {
                channel = ((QueuingService)service).take();
                assert (channel != null);
                if (channel == RepUtils.CHANNEL_EOF_MARKER) {
                    return null;
                }
                socket = channel.socket();
                socket.setSoTimeout(soTimeout);
                channel.flush();
                return channel;
            }
            catch (IOException e) {
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Unable to configure channel for '" + serviceName + "' service: " + LoggerUtils.exceptionTypeAndMsg(e));
                try {
                    channel.close();
                    continue;
                }
                catch (IOException e1) {
                    LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.FINEST, "Cleanup failed for service: " + serviceName + "\n" + LoggerUtils.exceptionTypeAndMsg(e1));
                    continue;
                }
            }
            break;
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public InetAddress getSocketBoundAddress() {
        return this.serverChannel.socket().getInetAddress();
    }

    public void register(String serviceName, BlockingQueue<DataChannel> serviceQueue) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null");
        }
        if (this.serviceMap.containsKey(serviceName)) {
            throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " is already registered");
        }
        if (serviceQueue == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceQueue argument must not be null");
        }
        this.serviceMap.put(serviceName, new QueuingService(serviceName, serviceQueue));
    }

    public void register(Service service) {
        if (service == null) {
            throw EnvironmentFailureException.unexpectedState("The service argument must not be null");
        }
        if (this.serviceMap.containsKey(service.name)) {
            throw EnvironmentFailureException.unexpectedState("Service: " + service.name + " is already registered");
        }
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.FINE, "Service: " + service.name + " registered.");
        this.serviceMap.put(service.name, service);
    }

    public boolean isRegistered(String serviceName) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null");
        }
        return this.serviceMap.containsKey(serviceName);
    }

    public void setSimulateIOException(String serviceName, boolean simulateException) {
        Service service = this.serviceMap.get(serviceName);
        if (service == null) {
            throw new IllegalStateException("Service: " + serviceName + " is not registered");
        }
        service.setSimulateIOException(simulateException);
    }

    public void cancel(String serviceName) {
        if (serviceName == null) {
            throw EnvironmentFailureException.unexpectedState("The serviceName argument must not be null.");
        }
        Service service = this.serviceMap.remove(serviceName);
        if (service == null) {
            throw EnvironmentFailureException.unexpectedState("Service: " + serviceName + " was not registered.");
        }
        service.cancel();
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.FINE, "Service: " + serviceName + " shut down.");
    }

    public DataChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    void addTestAuthentication(ServiceHandshake.AuthenticationMethod[] authOpts) {
        this.authOptions = authOpts;
    }

    private void setAuthOptions() {
        if (this.repImpl == null) {
            this.authOptions = null;
            return;
        }
        StreamAuthenticator auth = this.repImpl.getAuthenticator();
        if (auth == null) {
            this.authOptions = null;
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "No server auth method");
        } else {
            ServerAuthMethod method = new ServerAuthMethod(auth);
            this.authOptions = new ServiceHandshake.AuthenticationMethod[]{method};
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Server auth method: " + method.getMechanismName());
        }
    }

    private void processAccept() {
        SocketChannel socketChannel = null;
        try {
            socketChannel = this.serverChannel.accept();
            if (!this.processAcceptRequests) {
                this.closeChannel(socketChannel);
                return;
            }
            socketChannel.configureBlocking(false);
            DataChannel dataChannel = this.getChannelFactory().acceptChannel(socketChannel);
            ServiceHandshake.AuthenticationMethod[] authInfo = dataChannel.isTrustCapable() && this.authOptions == null ? new ServiceHandshake.AuthenticationMethod[]{} : this.authOptions;
            ServiceHandshake.ServerHandshake initState = new ServiceHandshake.ServerHandshake(dataChannel, this, authInfo);
            socketChannel.register(this.selector, 1, initState);
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Server accept exception: " + LoggerUtils.exceptionTypeAndMsg(e));
            this.closeChannel(socketChannel);
        }
    }

    private String processRead(ServiceHandshake.ServerHandshake initState) {
        try {
            ServiceHandshake.InitResult result = initState.process();
            if (result == ServiceHandshake.InitResult.FAIL) {
                this.closeDataChannelForcefully(initState.getChannel());
                return null;
            }
            if (result == ServiceHandshake.InitResult.REJECT) {
                initState.getChannel().write(Response.INVALID.byteBuffer());
                this.closeDataChannelForcefully(initState.getChannel());
                return null;
            }
            if (result == ServiceHandshake.InitResult.DONE) {
                return initState.getServiceName();
            }
            return null;
        }
        catch (IOException e) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Exception during read: " + LoggerUtils.exceptionTypeAndMsg(e));
            this.closeDataChannelForcefully(initState.getChannel());
            return null;
        }
    }

    private void closeChannel(Channel channel) {
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException e1) {
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Exception during cleanup: " + LoggerUtils.exceptionTypeAndMsg(e1));
            }
        }
    }

    private void closeDataChannelForcefully(DataChannel channel) {
        if (channel != null) {
            try {
                channel.closeForcefully();
            }
            catch (IOException e1) {
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "Exception during cleanup: " + LoggerUtils.exceptionTypeAndMsg(e1));
            }
        }
    }

    @Override
    public void run() {
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Started ServiceDispatcher. HostPort=" + this.socketAddress.getHostName() + ":" + this.socketAddress.getPort());
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "DataChannel factory: " + this.getChannelFactory().getClass().getName());
        try {
            while (true) {
                boolean changed = false;
                try {
                    changed = this.ipChanged();
                }
                catch (Exception e) {
                    LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Exception while check IP: " + LoggerUtils.exceptionTypeAndMsg(e));
                }
                if (changed) {
                    this.rebindSocket();
                }
                int result = this.selector.select(1000L);
                if (this.isShutdown()) {
                    return;
                }
                try {
                    if (result == 0) {
                        continue;
                    }
                }
                catch (Exception e) {
                    LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.SEVERE, "Server socket exception: " + LoggerUtils.getStackTrace(e));
                    throw EnvironmentFailureException.unexpectedException(e);
                }
                Set<SelectionKey> skeys = this.selector.selectedKeys();
                for (SelectionKey key : skeys) {
                    switch (key.readyOps()) {
                        case 16: {
                            this.processAccept();
                            break;
                        }
                        case 1: {
                            ServiceHandshake.ServerHandshake initState = (ServiceHandshake.ServerHandshake)key.attachment();
                            String serviceName = this.processRead(initState);
                            if (serviceName == null) break;
                            key.cancel();
                            this.processService(initState.getChannel(), serviceName);
                            break;
                        }
                        default: {
                            throw EnvironmentFailureException.unexpectedState("Unexpected ops bit set: " + key.readyOps());
                        }
                    }
                }
                skeys.clear();
            }
        }
        finally {
            for (SelectionKey key : this.selector.keys()) {
                ServiceHandshake.ServerHandshake initState = (ServiceHandshake.ServerHandshake)key.attachment();
                if (initState == null) continue;
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Server closing in-process handshake");
                this.closeDataChannelForcefully(initState.getChannel());
                key.cancel();
            }
            this.closeChannel(this.serverChannel);
            this.cleanup();
        }
    }

    private boolean ipChanged() throws Exception {
        String previousIP;
        boolean changed;
        if (this.repImpl == null) {
            return false;
        }
        InetAddress addr = InetAddress.getByName(this.repImpl.getHostName());
        String currentIP = addr.getHostAddress();
        boolean bl = changed = !currentIP.equals(previousIP = this.socketAddress.getAddress().getHostAddress());
        if (changed) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "ServiceDispatcher IP changed, from " + previousIP + " to " + currentIP);
        }
        return changed;
    }

    private void rebindSocket() throws IOException {
        if (this.repImpl == null) {
            return;
        }
        this.scKey.cancel();
        this.serverChannel.close();
        this.socketAddress = this.repImpl.getSocket();
        this.bindSocket();
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Rebind ServiceDispatcher socket: " + this.serverChannel.socket());
    }

    private void processService(DataChannel channel, String serviceName) {
        Service service = this.serviceMap.get(serviceName);
        try {
            if (service == null) {
                ++this.errorCount;
                channel.write(Response.UNKNOWN_SERVICE.byteBuffer());
                this.closeDataChannelForcefully(channel);
                LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.INFO, "Request for unknown Service: " + serviceName + " Registered services: " + this.serviceMap.keySet());
                return;
            }
            Response response = Response.OK;
            if (service.isBusy()) {
                response = Response.BUSY;
            }
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.FINE, "Service response: " + (Object)((Object)response) + " for service: " + service.name);
            if (channel.write(response.byteBuffer()) == 0) {
                throw EnvironmentFailureException.unexpectedState("Failed to write byte. Send buffer size: " + channel.socket().getSendBufferSize());
            }
            if (response == Response.OK) {
                channel.configureBlocking(true);
                service.requestDispatch(channel);
            }
        }
        catch (IOException e) {
            this.closeDataChannelForcefully(channel);
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, "IO error writing to channel for service: " + serviceName + LoggerUtils.exceptionTypeAndMsg(e));
        }
    }

    public static abstract class ExecutingRunnable
    implements Runnable {
        protected final DataChannel channel;
        protected final TextProtocol protocol;
        protected final boolean expectResponse;

        public ExecutingRunnable(DataChannel channel, TextProtocol protocol, boolean expectResponse) {
            this.channel = channel;
            this.protocol = protocol;
            this.expectResponse = expectResponse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ExecutingService.ensureChannelBlocking(this.channel);
            try {
                TextProtocol.RequestMessage request = this.protocol.getRequestMessage(this.channel);
                if (request == null) {
                    return;
                }
                TextProtocol.ResponseMessage response = this.getResponse(request);
                if (this.expectResponse && response != null) {
                    PrintWriter out = new PrintWriter(Channels.newOutputStream(this.channel), true);
                    out.println(response.wireFormat());
                } else assert (response == null);
            }
            catch (IOException e) {
                this.logMessage("IO error on socket: " + LoggerUtils.exceptionTypeAndMsg(e));
                return;
            }
            finally {
                if (this.channel.isOpen()) {
                    try {
                        this.channel.close();
                    }
                    catch (IOException e) {
                        this.logMessage("IO error on socket close: " + LoggerUtils.exceptionTypeAndMsg(e));
                        return;
                    }
                }
            }
        }

        protected abstract TextProtocol.ResponseMessage getResponse(TextProtocol.RequestMessage var1) throws IOException;

        protected abstract void logMessage(String var1);
    }

    public static class ServiceConnectFailedException
    extends Exception {
        final Response response;
        final String serviceName;

        ServiceConnectFailedException(String serviceName, Response response) {
            assert (response != Response.OK);
            this.response = response;
            this.serviceName = serviceName;
        }

        public Response getResponse() {
            return this.response;
        }

        @Override
        public String getMessage() {
            switch (this.response) {
                case FORMAT_ERROR: {
                    return "Bad message format, for service:" + this.serviceName;
                }
                case UNKNOWN_SERVICE: {
                    return "Unknown service request:" + this.serviceName;
                }
                case BUSY: {
                    return "Service was busy";
                }
                case INVALID: {
                    return "Invalid response supplied";
                }
                case PROCEED: {
                    return "Protocol continuation requested";
                }
                case AUTHENTICATE: {
                    return "Authentication required";
                }
            }
            throw EnvironmentFailureException.unexpectedState("Unexpected response:" + (Object)((Object)this.response) + " for service:" + this.serviceName);
        }
    }

    public static abstract class ExecutingService
    extends Service {
        private final ServiceDispatcher dispatcher;

        public ExecutingService(String serviceName, ServiceDispatcher dispatcher) {
            super(serviceName);
            this.dispatcher = dispatcher;
        }

        public abstract Runnable getRunnable(DataChannel var1);

        @Override
        void requestDispatch(DataChannel channel) {
            this.dispatcher.pool.execute(this.getRunnable(channel));
        }

        @Override
        protected void cancel() {
        }

        public static void ensureChannelBlocking(DataChannel channel) {
            if (!channel.isBlocking()) {
                throw new IllegalStateException("Unexpected non-blocking channel after dispatching to the service");
            }
        }
    }

    public class LazyQueuingService
    extends QueuingService {
        private final Thread serviceThread;

        public LazyQueuingService(String serviceName, BlockingQueue<DataChannel> queue, Thread serviceThread) {
            super(serviceName, queue);
            this.serviceThread = serviceThread;
        }

        @Override
        void requestDispatch(DataChannel channel) {
            switch (this.serviceThread.getState()) {
                case NEW: {
                    this.serviceThread.start();
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, (EnvironmentImpl)ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.FINE, "Thread started for service: " + this.name);
                    break;
                }
                case RUNNABLE: 
                case TIMED_WAITING: 
                case WAITING: 
                case BLOCKED: {
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, (EnvironmentImpl)ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.FINE, "Thread started for service: " + this.name);
                    break;
                }
                default: {
                    EnvironmentFailureException e = EnvironmentFailureException.unexpectedState("Thread for service:" + this.name + "is in state:" + (Object)((Object)this.serviceThread.getState()));
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, (EnvironmentImpl)ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.WARNING, LoggerUtils.exceptionTypeAndMsg(e));
                    throw e;
                }
            }
            super.requestDispatch(channel);
        }

        @Override
        void cancel() {
            if (this.serviceThread.isAlive()) {
                this.serviceThread.interrupt();
                try {
                    this.serviceThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            super.cancel();
        }
    }

    public class QueuingService
    extends Service {
        private final BlockingQueue<DataChannel> queue;

        QueuingService(String serviceName, BlockingQueue<DataChannel> queue) {
            super(serviceName);
            this.queue = queue;
        }

        DataChannel take() throws InterruptedException {
            return this.queue.take();
        }

        @Override
        void requestDispatch(DataChannel channel) {
            if (this.simulateIOException()) {
                LoggerUtils.logMsg(ServiceDispatcher.this.logger, (EnvironmentImpl)ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.INFO, "Simulated test IO exception");
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LoggerUtils.logMsg(ServiceDispatcher.this.logger, (EnvironmentImpl)ServiceDispatcher.this.repImpl, ServiceDispatcher.this.formatter, Level.FINEST, "Close failure in '" + this.name + "' service: " + LoggerUtils.exceptionTypeAndMsg(e));
                }
            }
            if (!this.queue.add(channel)) {
                throw EnvironmentFailureException.unexpectedState("request queue overflow");
            }
        }

        @Override
        void cancel() {
            for (DataChannel channel : this.queue) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
            this.queue.add(RepUtils.CHANNEL_EOF_MARKER);
        }
    }

    private static abstract class Service {
        final String name;
        private boolean simulateIOException = false;

        public Service(String name) {
            if (name == null) {
                throw EnvironmentFailureException.unexpectedState("Service name was null");
            }
            this.name = name;
        }

        abstract void requestDispatch(DataChannel var1);

        public boolean isBusy() {
            return false;
        }

        public boolean simulateIOException() {
            return this.simulateIOException;
        }

        public void setSimulateIOException(boolean simulateIOException) {
            this.simulateIOException = simulateIOException;
        }

        abstract void cancel();
    }

    public static enum Response {
        OK,
        BUSY,
        FORMAT_ERROR,
        UNKNOWN_SERVICE,
        PROCEED,
        INVALID,
        AUTHENTICATE;


        ByteBuffer byteBuffer() {
            ByteBuffer buffer = ByteBuffer.allocate(1);
            buffer.put((byte)this.ordinal());
            buffer.flip();
            return buffer;
        }

        public static Response get(int ordinal) {
            if (ordinal < Response.values().length) {
                return Response.values()[ordinal];
            }
            return null;
        }
    }
}

