/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.MapStatComponent;
import com.sleepycat.utilint.FormatUtil;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class LatencyPercentile
extends MapStatComponent<Long, LatencyPercentile> {
    private static final long serialVersionUID = 1L;
    private final String name;
    private final float percentile;
    private final int maxTrackedLatencyMillis;
    private volatile Values trackedValues;
    private volatile int savedPercentileValue;

    public LatencyPercentile(String name, float percentile, int maxTrackedLatencyMillis) {
        this.name = name;
        if ((double)percentile < 0.0 || (double)percentile > 1.0) {
            throw new IllegalArgumentException("Percentile must not be less than 0.0 or greater than 1.0: " + percentile);
        }
        this.percentile = percentile;
        if (maxTrackedLatencyMillis < 0) {
            throw new IllegalArgumentException("The maxTrackedLatencyMillis must not be negative: " + maxTrackedLatencyMillis);
        }
        this.maxTrackedLatencyMillis = maxTrackedLatencyMillis;
        this.clear();
    }

    private LatencyPercentile(LatencyPercentile other) {
        this.name = other.name;
        this.percentile = other.percentile;
        this.maxTrackedLatencyMillis = other.maxTrackedLatencyMillis;
        this.trackedValues = new Values(other.trackedValues);
        this.savedPercentileValue = other.savedPercentileValue;
    }

    @Override
    protected String getFormattedValue(boolean useCommas) {
        if (this.isNotSet()) {
            return "unknown";
        }
        long value = this.calculate(false);
        if (useCommas) {
            return FormatUtil.decimalScale0().format(value);
        }
        return Long.toString(value);
    }

    @Override
    public LatencyPercentile copy() {
        return new LatencyPercentile(this);
    }

    @Override
    public Long get() {
        return this.calculate(false);
    }

    @Override
    public void clear() {
        this.clearInternal();
    }

    @Override
    public boolean isNotSet() {
        return this.trackedValues.count.get() == 0L;
    }

    public String toString() {
        return "LatencyPercentile[name=" + this.name + " percent=" + this.percentile + " maxTracked=" + this.maxTrackedLatencyMillis + " value=" + this.savedPercentileValue + " trackedValues=" + this.trackedValues + "]";
    }

    public void add(long latencyMillis) {
        if (latencyMillis < 0L) {
            return;
        }
        Values values = this.trackedValues;
        int bucket = Math.min(Math.max(0, (int)latencyMillis), this.maxTrackedLatencyMillis);
        values.histogram.incrementAndGet(bucket);
        values.count.incrementAndGet();
    }

    public void add(LatencyPercentile other) {
        this.checkSameMax(other);
        this.trackedValues = this.trackedValues.add(other.trackedValues);
    }

    public void negate() {
        this.trackedValues = this.trackedValues.negate();
    }

    public void updateInterval(LatencyPercentile other) {
        this.checkSameMax(other);
        this.trackedValues = this.trackedValues.computeInterval(other.trackedValues);
    }

    private void checkSameMax(LatencyPercentile other) {
        if (this.maxTrackedLatencyMillis != other.maxTrackedLatencyMillis) {
            throw new IllegalArgumentException("Stats must have the same maximum.  This stat uses " + this.maxTrackedLatencyMillis + ", but other stat uses " + other.maxTrackedLatencyMillis);
        }
    }

    private Values clearInternal() {
        Values values = this.trackedValues;
        this.trackedValues = new Values(this.maxTrackedLatencyMillis);
        return values;
    }

    private synchronized long calculate(boolean clear) {
        Values values = clear ? this.clearInternal() : this.trackedValues;
        long count = values.count.get();
        if (count == 0L) {
            return 0L;
        }
        long percentileCount = (long)Math.ceil((float)count * this.percentile);
        int histogramLength = values.histogram.length();
        int percentileValue = 0;
        long numSeen = 0L;
        for (int latency = 0; latency < histogramLength; ++latency) {
            long latencyCount = values.histogram.get(latency);
            if (latencyCount == 0L) continue;
            percentileValue = latency;
            if ((numSeen += latencyCount) >= percentileCount) break;
        }
        this.savedPercentileValue = percentileValue;
        return percentileValue;
    }

    private static class Values
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final AtomicLong count = new AtomicLong();
        final AtomicLongArray histogram;

        Values(int maxTrackedLatencyMillis) {
            this.histogram = new AtomicLongArray(maxTrackedLatencyMillis + 1);
        }

        Values(Values other) {
            this.count.set(other.count.get());
            int max = other.histogram.length();
            this.histogram = new AtomicLongArray(max);
            for (int i = 0; i < max; ++i) {
                this.histogram.set(i, other.histogram.get(i));
            }
        }

        Values add(Values other) {
            int max = other.histogram.length();
            Values result = new Values(max - 1);
            result.count.set(this.count.get() + other.count.get());
            for (int i = 0; i < max; ++i) {
                result.histogram.set(i, this.histogram.get(i) + other.histogram.get(i));
            }
            return result;
        }

        Values computeInterval(Values other) {
            int max = this.histogram.length();
            Values result = new Values(max - 1);
            result.count.set(this.count.get() - other.count.get());
            for (int i = 0; i < max; ++i) {
                result.histogram.set(i, this.histogram.get(i) - other.histogram.get(i));
            }
            return result;
        }

        Values negate() {
            int max = this.histogram.length();
            Values result = new Values(max - 1);
            result.count.set(-this.count.get());
            for (int i = 0; i < max; ++i) {
                result.histogram.set(i, -this.histogram.get(i));
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Values[");
            sb.append("count=").append(this.count);
            sb.append(" histogram={");
            boolean first = true;
            for (int i = 0; i < this.histogram.length(); ++i) {
                long val = this.histogram.get(i);
                if (val == 0L) continue;
                if (!first) {
                    sb.append(',');
                } else {
                    first = false;
                }
                sb.append(i).append('=').append(val);
            }
            sb.append('}');
            return sb.toString();
        }
    }
}

