/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.networkRestore;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.networkRestore.LogFileFeeder;
import com.sleepycat.je.rep.impl.networkRestore.Protocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.RepUtils;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.util.DbBackup;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StoppableThread;
import java.util.ArrayList;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class FeederManager
extends StoppableThread {
    private final BlockingQueue<DataChannel> channelQueue = new LinkedBlockingQueue<DataChannel>();
    final Map<Integer, LogFileFeeder> feeders = new ConcurrentHashMap<Integer, LogFileFeeder>();
    final Map<Integer, Lease> leases = new ConcurrentHashMap<Integer, Lease>();
    final Map<String, Protocol.FileInfoResp> statResponses = new ConcurrentHashMap<String, Protocol.FileInfoResp>();
    final Timer leaseTimer = new Timer(true);
    final NameIdPair nameIdPair;
    public int leaseRenewalCount;
    long leaseDuration = 300000L;
    final ServiceDispatcher serviceDispatcher;
    final AtomicBoolean shutdown = new AtomicBoolean(false);
    final Logger logger;
    private static long POLL_TIMEOUT = Long.MAX_VALUE;
    public static final String FEEDER_SERVICE = "LogFileFeeder";
    private static final long DEFAULT_LEASE_DURATION = 300000L;

    public FeederManager(ServiceDispatcher serviceDispatcher, EnvironmentImpl envImpl, NameIdPair nameIdPair) {
        super(envImpl, "Feeder Manager node: " + nameIdPair.getName());
        this.serviceDispatcher = serviceDispatcher;
        ServiceDispatcher serviceDispatcher2 = serviceDispatcher;
        serviceDispatcher2.getClass();
        serviceDispatcher.register(serviceDispatcher2.new ServiceDispatcher.LazyQueuingService(FEEDER_SERVICE, this.channelQueue, this));
        this.nameIdPair = nameIdPair;
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    EnvironmentImpl getEnvImpl() {
        return this.envImpl;
    }

    public int getLeaseRenewalCount() {
        return this.leaseRenewalCount;
    }

    public int getLeaseCount() {
        return this.leases.size();
    }

    public int getActiveFeederCount() {
        return this.feeders.size() + this.getLeaseCount();
    }

    public long getLeaseDuration() {
        return this.leaseDuration;
    }

    public void setLeaseDuration(long leaseDuration) {
        this.leaseDuration = leaseDuration;
    }

    public void clearedCachedFileChecksum(String fileName) {
        this.statResponses.remove(fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                DataChannel channel;
                if ((channel = this.channelQueue.poll(POLL_TIMEOUT, TimeUnit.MILLISECONDS)) == RepUtils.CHANNEL_EOF_MARKER) {
                    LoggerUtils.info(this.logger, this.envImpl, "Log file Feeder manager soft shutdown.");
                    return;
                }
                new LogFileFeeder(this, channel).start();
                continue;
                break;
            }
        }
        catch (InterruptedException ie) {
            LoggerUtils.info(this.logger, this.envImpl, "Log file feeder manager interrupted");
            return;
        }
        catch (Exception e) {
            LoggerUtils.severe(this.logger, this.envImpl, "unanticipated exception: " + e.getMessage());
            throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNCAUGHT_EXCEPTION, (Throwable)e);
        }
        finally {
            this.shutdown();
        }
    }

    public void shutdown() {
        LoggerUtils.fine(this.logger, this.envImpl, "Shutting down log file feeder manager");
        if (!this.shutdown.compareAndSet(false, true)) {
            return;
        }
        this.shutdownThread(this.logger);
        for (LogFileFeeder feeder : new ArrayList<LogFileFeeder>(this.feeders.values())) {
            feeder.shutdown();
        }
        this.leaseTimer.cancel();
        for (Lease l : new ArrayList<Lease>(this.leases.values())) {
            DbBackup dbBackup = l.terminate();
            if (!dbBackup.backupIsOpen()) continue;
            dbBackup.endBackup();
        }
        this.serviceDispatcher.cancel(FEEDER_SERVICE);
        this.cleanup();
        LoggerUtils.fine(this.logger, this.envImpl, "Shut down log file feeder manager completed");
    }

    @Override
    protected int initiateSoftShutdown() {
        this.channelQueue.clear();
        this.channelQueue.add(RepUtils.CHANNEL_EOF_MARKER);
        return 0;
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    class Lease
    extends TimerTask {
        private final int id;
        private DbBackup dbBackup;

        public Lease(int id, long duration, DbBackup dbbackup) {
            this.dbBackup = dbbackup;
            this.id = id;
            Lease oldLease = FeederManager.this.leases.put(id, this);
            if (oldLease != null) {
                throw EnvironmentFailureException.unexpectedState("Found an old lease for node: " + id);
            }
            FeederManager.this.leaseTimer.schedule((TimerTask)this, duration);
        }

        @Override
        public synchronized void run() {
            if (this.dbBackup == null) {
                return;
            }
            this.dbBackup.endBackup();
            this.terminate();
        }

        public synchronized DbBackup terminate() {
            if (this.dbBackup == null) {
                return null;
            }
            this.cancel();
            Lease l = FeederManager.this.leases.remove(this.id);
            assert (l == this);
            DbBackup saveDbBackup = this.dbBackup;
            this.dbBackup = null;
            return saveDbBackup;
        }

        public synchronized DbBackup getOpenDbBackup() {
            return this.dbBackup != null && this.dbBackup.backupIsOpen() ? this.dbBackup : null;
        }
    }
}

