/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.net.DataChannelFactory;

public class Protocol
extends TextProtocol {
    public static final String VERSION = "2.0";
    static final String REP_GROUP_V3_VERSION = "2.0";
    static final String REP_GROUP_V2_VERSION = "1.0";
    public final TextProtocol.MessageOp GROUP_CHANGE_REQ = new TextProtocol.MessageOp("GCHG", GroupChange.class);
    public final TextProtocol.MessageOp JOIN_GROUP_REQ = new TextProtocol.MessageOp("JG", JoinGroup.class);
    public final TextProtocol.MessageOp LEAVE_GROUP_REQ = new TextProtocol.MessageOp("LG", LeaveGroup.class);

    public Protocol(String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        this("2.0", groupName, nameIdPair, repImpl, channelFactory);
    }

    Protocol(String version, String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        super(version, groupName, nameIdPair, repImpl, channelFactory);
        this.initializeMessageOps(new TextProtocol.MessageOp[]{this.GROUP_CHANGE_REQ, this.JOIN_GROUP_REQ, this.LEAVE_GROUP_REQ});
        this.setTimeouts(repImpl, RepParams.MONITOR_OPEN_TIMEOUT, RepParams.MONITOR_READ_TIMEOUT);
    }

    public class LeaveGroup
    extends MemberEvent {
        private final LeaveGroupEvent.LeaveReason leaveReason;
        private final long leaveTime;

        public LeaveGroup(String nodeName, String masterName, LeaveGroupEvent.LeaveReason leaveReason, long joinTime, long leaveTime) {
            super(nodeName, masterName, joinTime);
            this.leaveReason = leaveReason;
            this.leaveTime = leaveTime;
        }

        public LeaveGroup(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(line, tokens);
            this.leaveReason = LeaveGroupEvent.LeaveReason.valueOf(this.nextPayloadToken());
            this.leaveTime = Long.parseLong(this.nextPayloadToken());
        }

        public LeaveGroupEvent.LeaveReason getLeaveReason() {
            return this.leaveReason;
        }

        public long getLeaveTime() {
            return this.leaveTime;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.LEAVE_GROUP_REQ;
        }

        @Override
        public String wireFormat() {
            return super.wireFormat() + "|" + this.leaveReason.toString() + "|" + Long.toString(this.leaveTime);
        }
    }

    public class JoinGroup
    extends MemberEvent {
        public JoinGroup(String nodeName, String masterName, long joinTime) {
            super(nodeName, masterName, joinTime);
        }

        public JoinGroup(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(line, tokens);
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.JOIN_GROUP_REQ;
        }
    }

    private abstract class MemberEvent
    extends ChangeEvent {
        private final String masterName;
        private final long joinTime;

        public MemberEvent(String nodeName, String masterName, long joinTime) {
            super(nodeName);
            this.masterName = masterName;
            this.joinTime = joinTime;
        }

        public MemberEvent(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(line, tokens);
            this.masterName = this.nextPayloadToken();
            this.joinTime = Long.parseLong(this.nextPayloadToken());
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public String getMasterName() {
            return this.masterName;
        }

        @Override
        public String wireFormat() {
            return super.wireFormat() + this.masterName + "|" + Long.toString(this.joinTime);
        }
    }

    public class GroupChange
    extends ChangeEvent {
        private final RepGroupImpl group;
        private final GroupChangeEvent.GroupChangeType opType;

        public GroupChange(RepGroupImpl group, String nodeName, GroupChangeEvent.GroupChangeType opType) {
            super(nodeName);
            this.group = group;
            this.opType = opType;
        }

        public GroupChange(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(line, tokens);
            this.opType = GroupChangeEvent.GroupChangeType.valueOf(this.nextPayloadToken());
            this.group = RepGroupImpl.deserializeHex(tokens, this.getCurrentTokenPosition());
        }

        public RepGroupImpl getGroup() {
            return this.group;
        }

        public GroupChangeEvent.GroupChangeType getOpType() {
            return this.opType;
        }

        @Override
        public TextProtocol.MessageOp getOp() {
            return Protocol.this.GROUP_CHANGE_REQ;
        }

        @Override
        public String wireFormat() {
            int repGroupVersion = Double.parseDouble(this.sendVersion) <= Double.parseDouble(Protocol.REP_GROUP_V2_VERSION) ? 2 : 3;
            return super.wireFormat() + this.opType.toString() + "|" + this.group.serializeHex(repGroupVersion);
        }
    }

    private abstract class ChangeEvent
    extends TextProtocol.RequestMessage {
        private final String nodeName;

        public ChangeEvent(String nodeName) {
            super(Protocol.this);
            this.nodeName = nodeName;
        }

        public ChangeEvent(String line, String[] tokens) throws TextProtocol.InvalidMessageException {
            super(Protocol.this, line, tokens);
            this.nodeName = this.nextPayloadToken();
        }

        public String getNodeName() {
            return this.nodeName;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + "|" + this.nodeName + "|";
        }
    }
}

