/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.util.ldiff;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.util.ldiff.Block;
import com.sleepycat.je.rep.util.ldiff.BlockBag;
import com.sleepycat.je.rep.util.ldiff.DiffRecordAnalyzer;
import com.sleepycat.je.rep.util.ldiff.DiffTracker;
import com.sleepycat.je.rep.util.ldiff.LDiffConfig;
import com.sleepycat.je.rep.util.ldiff.LDiffUtil;
import com.sleepycat.je.rep.util.ldiff.MismatchedRegion;
import com.sleepycat.je.rep.util.ldiff.Protocol;
import com.sleepycat.je.rep.util.ldiff.Window;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.rep.utilint.net.SimpleChannelFactory;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;

public class LDiff {
    private LDiffConfig cfg;
    private File home1;
    private File home2;
    private String file1;
    private String file2;
    private DiffTracker tracker;
    private static final String usageString = "usage: " + CmdUtil.getJavaCommand(LDiff.class) + "\n  -h <dir>[,<dir2>]   # environment home directory\n  [-a]                # analyze diff\n  [-b <blockSize>]    # number of records to put in each block\n  [-m <maxErrors>]    # abort diff after a number of errors\n  [-s <databaseName>,<databaseName>] # database(s) to compare\n  [-q]                # be quiet, do not print to stdout";
    private static final int SOCKET_TIMEOUT_MS = 10000;

    public static void main(String[] args) {
        LDiff differ = new LDiff();
        differ.parseArgs(args);
        try {
            if (differ.diff()) {
                System.exit(0);
            } else {
                System.exit(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void parseArgs(String[] argv) {
        this.cfg = new LDiffConfig();
        this.cfg.setVerbose(true);
        int argc = 0;
        int nArgs = argv.length;
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-a")) {
                this.cfg.setDiffAnalysis(true);
                continue;
            }
            if (thisArg.equals("-b")) {
                if (argc < nArgs) {
                    try {
                        this.cfg.setBlockSize(Integer.parseInt(argv[argc++]));
                    }
                    catch (NumberFormatException nfe) {
                        this.printUsage("-b requires an integer argument");
                    }
                    continue;
                }
                this.printUsage("-b requires an argument");
                continue;
            }
            if (thisArg.equals("-h")) {
                if (argc < nArgs) {
                    String[] envDirs;
                    if ((envDirs = argv[argc++].split(",")).length > 2) {
                        this.printUsage("Only 2 environments supported");
                    }
                    this.home1 = new File(envDirs[0]);
                    if (envDirs.length != 2) continue;
                    this.home2 = new File(envDirs[1]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-m")) {
                if (argc < nArgs) {
                    try {
                        this.cfg.setMaxErrors(Integer.parseInt(argv[argc++]));
                    }
                    catch (NumberFormatException nfe) {
                        this.printUsage("-m requires an integer argument");
                    }
                    continue;
                }
                this.printUsage("-m requires an argument");
                continue;
            }
            if (thisArg.equals("-s")) {
                if (argc < nArgs) {
                    String[] dbNames;
                    if ((dbNames = argv[argc++].split(",")).length != 2) {
                        this.printUsage("-s requires two database names");
                    }
                    this.file1 = dbNames[0];
                    this.file2 = dbNames[1];
                    continue;
                }
                this.printUsage("-s requires an argument");
                continue;
            }
            if (thisArg.equals("-q")) {
                this.cfg.setVerbose(false);
                continue;
            }
            this.printUsage(thisArg + " is not a valid option.");
        }
        if (this.home1 == null) {
            this.printUsage("-h is a required argument");
        }
        if (this.home2 == null && this.file1 == null) {
            this.printUsage("2 databases must be specified with 1 environment");
        }
    }

    private void printUsage(String msg) {
        System.err.println(msg);
        System.err.println(usageString);
        System.exit(-1);
    }

    private LDiff() {
    }

    public LDiff(LDiffConfig cfg) {
        this.cfg = cfg;
    }

    private boolean diff() throws Exception {
        Database db2;
        EnvironmentConfig envConfiguration = new EnvironmentConfig();
        envConfiguration.setReadOnly(true);
        envConfiguration.setCachePercent(40);
        Environment env1 = new Environment(this.home1, envConfiguration);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setReadOnly(true);
        DbInternal.setUseExistingConfig(dbConfig, true);
        if (this.home2 != null) {
            Environment env2 = new Environment(this.home2, envConfiguration);
            if (this.file1 == null) {
                boolean ret = this.diff(env1, env2);
                env1.close();
                env2.close();
                return ret;
            }
            db2 = env2.openDatabase(null, this.file2, dbConfig);
        } else {
            db2 = env1.openDatabase(null, this.file2, dbConfig);
        }
        Database db1 = env1.openDatabase(null, this.file1, dbConfig);
        boolean ret = this.diff(db1, db2);
        db1.close();
        db2.close();
        env1.close();
        return ret;
    }

    public boolean diff(Environment env1, Environment env2) throws Exception {
        boolean ret;
        List<String> env1names = env1.getDatabaseNames();
        List<String> env2names = env2.getDatabaseNames();
        boolean bl = ret = env1names.size() == env2names.size();
        if (!ret) {
            this.output("Environments have different number of databases.");
        }
        for (String dbName : env1names) {
            Database db2;
            Database db1;
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            DbInternal.setUseExistingConfig(dbConfig, true);
            try {
                db1 = env1.openDatabase(null, dbName, dbConfig);
            }
            catch (DatabaseNotFoundException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            try {
                db2 = env2.openDatabase(null, dbName, dbConfig);
            }
            catch (DatabaseNotFoundException e) {
                db1.close();
                this.output(dbName + " does not exist in " + env2.getHome().getName());
                ret = false;
                continue;
            }
            if (!this.diff(db1, db2)) {
                ret = false;
            }
            db1.close();
            db2.close();
        }
        if (ret) {
            this.output("No differences exist between the two environments.");
        } else {
            this.output("Differences exist between the two environments.");
        }
        return ret;
    }

    public boolean diff(Database db1, Database db2) throws Exception {
        BlockBag bag = this.createBlockBag(db2);
        boolean ret = this.diff(db1, bag);
        if (this.cfg.getVerbose()) {
            String db1Name = db1.getDatabaseName();
            String db2Name = db2.getDatabaseName();
            boolean namesMatch = db1Name.equals(db2Name);
            if (ret) {
                if (namesMatch) {
                    this.output("No differences in " + db1Name);
                } else {
                    this.output(db1Name + " matches " + db2Name);
                }
            } else if (namesMatch) {
                this.output("Differences in " + db1Name);
            } else {
                this.output(db1Name + " does not match " + db2Name);
            }
        }
        if (this.cfg.getDiffAnalysis() && this.tracker.getDiffRegions().size() != 0) {
            DiffRecordAnalyzer.doAnalysis(db1, db2, this.tracker, this.cfg.getVerbose());
        }
        return ret;
    }

    public boolean diff(Environment env, InetSocketAddress addr) throws IOException, BinaryProtocol.ProtocolException, ServiceDispatcher.ServiceConnectFailedException, Exception {
        return this.diff(env, addr, (DataChannelFactory)new SimpleChannelFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean diff(Environment env, InetSocketAddress addr, DataChannelFactory dcFactory) throws IOException, BinaryProtocol.ProtocolException, ServiceDispatcher.ServiceConnectFailedException, Exception {
        List<String> envNames = env.getDatabaseNames();
        boolean ret = true;
        DataChannel channel = this.connect(addr, dcFactory);
        Protocol protocol = new Protocol(new NameIdPair("Ldiff", -1), DbInternal.getNonNullEnvImpl(env));
        protocol.write((BinaryProtocol.Message)protocol.new Protocol.EnvDiff(), channel);
        Protocol.EnvInfo msg = protocol.read(channel, Protocol.EnvInfo.class);
        boolean bl = ret = envNames.size() == msg.getNumberOfDBs();
        if (!ret) {
            this.output("Number of databases in local and remote environments does not match.");
        }
        channel.close();
        for (String dbName : envNames) {
            Database db;
            channel = this.connect(addr, dcFactory);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            DbInternal.setUseExistingConfig(dbConfig, true);
            try {
                db = env.openDatabase(null, dbName, dbConfig);
            }
            catch (DatabaseNotFoundException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
            try {
                if (this.diff(db, channel)) continue;
                ret = false;
            }
            catch (BinaryProtocol.ProtocolException pe) {
                this.output(dbName + " does not exist in remote environment.");
                ret = false;
            }
            finally {
                db.close();
                if (!channel.isOpen()) continue;
                channel.close();
            }
        }
        if (ret) {
            this.output("Local environment matches remote.");
        } else {
            this.output("Local environment does not match remote.");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean diff(Database db, InetSocketAddress addr, DataChannelFactory dcFactory) throws IOException, BinaryProtocol.ProtocolException, ServiceDispatcher.ServiceConnectFailedException, Exception {
        boolean ret;
        try (DataChannel channel = this.connect(addr, dcFactory);){
            ret = this.diff(db, channel);
        }
        return ret;
    }

    private boolean diff(Database db, DataChannel channel) throws IOException, BinaryProtocol.ProtocolException, Exception {
        Protocol protocol;
        Protocol protocol2 = protocol = new Protocol(new NameIdPair("Ldiff", -1), DbInternal.getNonNullEnvImpl(db.getEnvironment()));
        protocol2.getClass();
        protocol.write((BinaryProtocol.Message)protocol2.new Protocol.DbBlocks(db.getDatabaseName(), this.cfg.getBlockSize()), channel);
        protocol.read(channel, Protocol.BlockListStart.class);
        BlockBag bag = new BlockBag();
        try {
            while (true) {
                Protocol.BlockInfo blockMsg = protocol.read(channel, Protocol.BlockInfo.class);
                bag.add(blockMsg.getBlock());
            }
        }
        catch (BinaryProtocol.ProtocolException pe) {
            if (pe.getUnexpectedMessage().getOp() != Protocol.BLOCK_LIST_END) {
                throw pe;
            }
            boolean match = this.diff(db, bag);
            if (match) {
                this.output(db.getDatabaseName() + " matches remote database.");
            } else {
                this.output(db.getDatabaseName() + "does not match remote database.");
            }
            if (this.cfg.getDiffAnalysis() && this.tracker.getDiffRegions().size() != 0) {
                DiffRecordAnalyzer.doAnalysis(db, protocol, channel, this.tracker, this.cfg.getVerbose());
            }
            protocol.write((BinaryProtocol.Message)protocol.new Protocol.Done(), channel);
            return match;
        }
    }

    public boolean diff(Database db, BlockBag blkBag) throws Exception {
        boolean identical = true;
        Cursor cursor = db.openCursor(null, null);
        long pos = 1L;
        int numKeys = this.cfg.getBlockSize();
        Window window = new Window(cursor, numKeys);
        int errors = 0;
        int maxerrors = this.cfg.getMaxErrors();
        this.tracker = new DiffTracker(numKeys);
        while (window.getChecksum() != 0L && blkBag.size() > 0) {
            Block match = this.findMatch(db.getEnvironment(), blkBag, window);
            if (match != null) {
                this.tracker.setBlockDiffBegin(blkBag.getBlock(), blkBag.getBlockIndex());
                List<Block> removed = blkBag.remove(match);
                if (removed != null) {
                    identical = false;
                    this.tracker.calBlockDiffSize(blkBag.getBlockIndex());
                    if (maxerrors > 0 && (errors += removed.size()) >= maxerrors) break;
                }
                this.tracker.addDiffRegion(window);
                window.nextWindow();
                pos += (long)window.size();
                continue;
            }
            identical = false;
            LoggerUtils.envLogMsg(Level.FINE, DbInternal.getNonNullEnvImpl(db.getEnvironment()), "Unmatched block at position " + pos);
            if (maxerrors > 0 && ++errors >= maxerrors) break;
            window.rollWindow();
            if (window.getChecksum() == 0L) continue;
            ++pos;
        }
        cursor.close();
        if (window.getChecksum() != 0L) {
            LoggerUtils.envLogMsg(Level.FINE, DbInternal.getNonNullEnvImpl(db.getEnvironment()), "Local Db has addtional records starting at " + pos + ".");
            identical = false;
            this.tracker.addWindowAdditionalDiffs(window);
        }
        if (blkBag.size() > 0) {
            for (Block b : blkBag) {
                LoggerUtils.envLogMsg(Level.FINE, DbInternal.getNonNullEnvImpl(db.getEnvironment()), "Unmatched remote block: " + b);
            }
            identical = false;
            this.tracker.addBlockBagAdditionalDiffs(window, blkBag);
        }
        return identical;
    }

    public List<MismatchedRegion> getDiffRegions() {
        if (this.tracker == null) {
            return null;
        }
        return this.tracker.getDiffRegions();
    }

    private Block findMatch(Environment env, BlockBag blkBag, Window window) {
        List<Block> matches = blkBag.get(window.getChecksum());
        if (matches == null) {
            return null;
        }
        byte[] md5 = window.getMd5Hash();
        for (Block b : matches) {
            if (Arrays.equals(b.getMd5Hash(), md5)) {
                return b;
            }
            LoggerUtils.envLogMsg(Level.FINE, DbInternal.getNonNullEnvImpl(env), "Found a remote block whose rolling checksum matches LB but md5 hash doesn't:" + b);
        }
        return null;
    }

    public BlockBag createBlockBag(Database db) {
        BlockBag bag = new BlockBag();
        long start = System.currentTimeMillis();
        Iterator<Block> iter = this.iterator(db);
        while (iter.hasNext()) {
            bag.add(iter.next());
        }
        long end = System.currentTimeMillis();
        LoggerUtils.envLogMsg(Level.FINE, DbInternal.getNonNullEnvImpl(db.getEnvironment()), "Block bag created in : " + (end - start) + " ms.");
        return bag;
    }

    public Iterator<Block> iterator(Database db) {
        return new LDiffIterator(db);
    }

    private DataChannel connect(InetSocketAddress addr, DataChannelFactory dcFactory) throws IOException, ServiceDispatcher.ServiceConnectFailedException {
        int triesLeft = this.cfg.getMaxConnectionAttempts();
        Channel ret = null;
        while (true) {
            try {
                ret = dcFactory.connect(addr, null, new DataChannelFactory.ConnectOptions().setBlocking(true).setTcpNoDelay(true).setOpenTimeout(10000).setReadTimeout(10000));
                ServiceDispatcher.doServiceHandshake((DataChannel)ret, "LDiff");
            }
            catch (ServiceDispatcher.ServiceConnectFailedException scfe) {
                if (ret != null && ret.isOpen()) {
                    ret.close();
                }
                if (triesLeft <= 0) continue;
                --triesLeft;
                if (this.cfg.getWaitIfBusy() && triesLeft != 0) continue;
                throw scfe;
            }
            break;
        }
        return ret;
    }

    private void output(String msg) {
        if (this.cfg.getVerbose()) {
            System.out.println(msg);
        }
    }

    private class LDiffIterator
    implements Iterator<Block> {
        private Block cached;
        private Cursor cursor;
        private final Database db;
        private DatabaseEntry lastKey;
        private DatabaseEntry lastData;
        private boolean more;
        private int i = 0;
        private final int numKeys;

        public LDiffIterator(Database db) {
            this.numKeys = LDiff.this.cfg.getBlockSize();
            this.cached = null;
            this.more = true;
            this.db = db;
            this.next();
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public void remove() {
        }

        @Override
        public Block next() {
            if (!this.more) {
                throw new NoSuchElementException();
            }
            this.cursor = this.db.openCursor(null, null);
            if (this.lastKey == null) {
                this.lastKey = new DatabaseEntry();
                this.lastData = new DatabaseEntry();
            } else {
                this.cursor.getSearchBoth(this.lastKey, this.lastData, null);
            }
            Block ret = this.cached;
            this.cached = LDiffUtil.readBlock(this.i++, this.cursor, this.numKeys);
            if (this.cached.numRecords == 0) {
                this.more = false;
            } else {
                this.cursor.getCurrent(this.lastKey, this.lastData, null);
            }
            this.cursor.close();
            return ret;
        }

        protected void finalize() throws Throwable {
            try {
                this.cursor.close();
            }
            finally {
                super.finalize();
            }
        }
    }

    class MismatchException
    extends Exception {
        public MismatchException(String message) {
            super(message);
        }
    }
}

