/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DiskOrderedCursorConfig;
import com.sleepycat.je.ForwardCursor;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DiskOrderedCursorImpl;
import com.sleepycat.je.utilint.LoggerUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DiskOrderedCursor
implements ForwardCursor {
    private final Database[] dbHandles;
    private final DatabaseImpl[] dbImpls;
    private final DiskOrderedCursorConfig config;
    private final DiskOrderedCursorImpl dosCursorImpl;
    private final Logger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiskOrderedCursor(Database[] dbHandles, DiskOrderedCursorConfig config) {
        int i;
        this.dbHandles = dbHandles;
        this.config = config;
        assert (dbHandles != null && dbHandles.length > 0);
        this.dbImpls = new DatabaseImpl[dbHandles.length];
        boolean dups = false;
        try {
            for (i = 0; i < dbHandles.length; ++i) {
                DatabaseImpl dbImpl;
                Database db;
                Database database = db = dbHandles[i];
                synchronized (database) {
                    db.addCursor(this);
                    dbImpl = db.getDbImpl();
                }
                assert (dbImpl != null);
                if (i == 0) {
                    dups = dbImpl.getSortedDuplicates();
                } else if (dbImpl.getSortedDuplicates() != dups) {
                    throw new IllegalArgumentException("In a multi-database disk ordered cursor either all or none of the databases should support duplicates");
                }
                this.dbImpls[i] = dbImpl;
            }
            this.dosCursorImpl = new DiskOrderedCursorImpl(this.dbImpls, config);
            this.logger = this.dbImpls[0].getEnv().getLogger();
        }
        catch (Throwable e) {
            for (int j = 0; j < i; ++j) {
                dbHandles[j].removeCursor(this);
            }
            throw e;
        }
    }

    @Override
    public Database getDatabase() {
        return this.dbHandles[this.dosCursorImpl.getCurrDb()];
    }

    @Override
    public void close() throws DatabaseException {
        if (this.dosCursorImpl.isClosed()) {
            return;
        }
        try {
            this.dosCursorImpl.checkEnv();
            this.dosCursorImpl.close();
            for (int i = 0; i < this.dbHandles.length; ++i) {
                this.dbHandles[i].removeCursor(this);
            }
        }
        catch (Error E) {
            this.dbImpls[0].getEnv().invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationResult get(DatabaseEntry key, DatabaseEntry data, Get getType, ReadOptions options) {
        try {
            this.checkState();
            this.checkLockMode(options != null ? options.getLockMode() : null);
            this.trace(Level.FINEST, getType);
            switch (getType) {
                case CURRENT: {
                    return this.dosCursorImpl.getCurrent(key, data);
                }
                case NEXT: {
                    return this.dosCursorImpl.getNext(key, data);
                }
            }
            throw new IllegalArgumentException("Get type not allowed: " + getType);
        }
        catch (Error E) {
            this.dbImpls[0].getEnv().invalidate(E);
            throw E;
        }
    }

    @Override
    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.CURRENT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.KEYEMPTY : OperationStatus.SUCCESS;
    }

    @Override
    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        OperationResult result = this.get(key, data, Get.NEXT, DbInternal.getReadOptions(lockMode));
        return result == null ? OperationStatus.NOTFOUND : OperationStatus.SUCCESS;
    }

    public DiskOrderedCursorConfig getConfig() {
        try {
            return this.config.clone();
        }
        catch (Error E) {
            this.dbImpls[0].getEnv().invalidate(E);
            throw E;
        }
    }

    private void checkLockMode(LockMode lockMode) {
        if (lockMode == null || lockMode == LockMode.DEFAULT || lockMode == LockMode.READ_UNCOMMITTED) {
            return;
        }
        throw new IllegalArgumentException("lockMode must be null or LockMode.READ_UNCOMMITTED");
    }

    private void checkState() {
        this.dosCursorImpl.checkEnv();
    }

    private void trace(Level level, Get getType) {
        if (this.logger.isLoggable(level)) {
            LoggerUtils.logMsg(this.logger, this.dbImpls[0].getEnv(), level, getType.toString());
        }
    }

    DiskOrderedCursorImpl getCursorImpl() {
        return this.dosCursorImpl;
    }
}

