/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.cleaner.FileProtector;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.ReservedFileInfo;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.StartupTracker;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.recovery.RecoveryInfo;
import com.sleepycat.je.tree.FileSummaryLN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UtilizationProfile {
    private static final Runnable EMPTY_RUNNABLE = () -> {};
    private final EnvironmentImpl env;
    private final UtilizationTracker tracker;
    private DatabaseImpl fileSummaryDb;
    private DatabaseImpl reservedFilesDb;
    private SortedMap<Long, FileSummary> fileSummaryMap;
    private boolean cachePopulated;
    private final Logger logger;
    private static TestHook<EnvironmentImpl> incompleteReactivateHook;

    public UtilizationProfile(EnvironmentImpl env, UtilizationTracker tracker) {
        this.env = env;
        this.tracker = tracker;
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    public synchronized FileSummary getFileSummary(Long file) {
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(file);
        TrackedFileSummary trackedSummary = this.tracker.getTrackedFile(file);
        if (trackedSummary != null) {
            FileSummary totals = new FileSummary();
            if (summary != null) {
                totals.add(summary);
            }
            totals.add(trackedSummary);
            summary = totals;
        }
        return summary;
    }

    public void flushLocalTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        if (localTracker.isEmpty()) {
            return;
        }
        this.env.getLogManager().transferToUtilizationTracker(localTracker);
        this.flushFileUtilization(localTracker.getTrackedFiles());
    }

    public void flushFileUtilization(Collection<TrackedFileSummary> activeFiles) throws DatabaseException {
        if (!DbInternal.getCheckpointUP(this.env.getConfigManager().getEnvironmentConfig())) {
            return;
        }
        for (TrackedFileSummary activeFile : activeFiles) {
            long fileNum = activeFile.getFileNumber();
            TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
            if (tfs == null) continue;
            this.flushFileSummary(tfs);
        }
    }

    public synchronized SortedMap<Long, FileSummary> getFileSummaryMap(boolean includeTrackedFiles) {
        assert (this.cachePopulated);
        if (includeTrackedFiles) {
            TreeMap<Long, FileSummary> map = new TreeMap<Long, FileSummary>();
            for (Long file : this.fileSummaryMap.keySet()) {
                FileSummary summary = this.getFileSummary(file);
                map.put(file, summary);
            }
            for (TrackedFileSummary summary : this.tracker.getTrackedFiles()) {
                Long fileNum = summary.getFileNumber();
                if (map.containsKey(fileNum)) continue;
                map.put(fileNum, summary);
            }
            return map;
        }
        return new TreeMap<Long, FileSummary>(this.fileSummaryMap);
    }

    public synchronized int getFileSize(Long file) {
        FileSummary summary = this.getFileSummary(file);
        if (summary == null) {
            return -1;
        }
        return summary.totalSize;
    }

    public synchronized SortedMap<Long, Integer> getFileSizeSummaryMap() {
        TreeMap<Long, Integer> map = new TreeMap<Long, Integer>();
        for (Long fileNum : this.fileSummaryMap.keySet()) {
            int totalSize = this.getFileSize(fileNum);
            map.put(fileNum, totalSize);
        }
        for (TrackedFileSummary trackedSummary : this.tracker.getTrackedFiles()) {
            Long fileNum = trackedSummary.getFileNumber();
            if (map.containsKey(fileNum)) continue;
            map.put(fileNum, trackedSummary.totalSize);
        }
        if (!map.isEmpty()) {
            map.remove(map.lastKey());
        }
        return map;
    }

    private synchronized void clearCache() {
        int memorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        MemoryBudget mb = this.env.getMemoryBudget();
        mb.updateAdminMemoryUsage(0 - memorySize);
        this.fileSummaryMap = new TreeMap<Long, FileSummary>();
        this.cachePopulated = false;
    }

    void reserveFiles(Map<Long, FileSelector.FileInfo> reservedFiles) {
        for (Map.Entry<Long, FileSelector.FileInfo> entry : reservedFiles.entrySet()) {
            FileSelector.FileInfo fsInfo = entry.getValue();
            this.putReservedFileRecord(entry.getKey(), fsInfo);
        }
        Set<Long> files = reservedFiles.keySet();
        for (Long file : files) {
            this.deleteFileSummary(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putReservedFileRecord(Long file, FileSelector.FileInfo fsInfo) {
        DatabaseEntry keyEntry = new DatabaseEntry();
        ReservedFileInfo.keyToEntry(file, keyEntry);
        ReservedFileInfo rfInfo = new ReservedFileInfo(fsInfo.firstVlsn, fsInfo.lastVlsn, fsInfo.dbIds);
        DatabaseEntry dataEntry = new DatabaseEntry();
        ReservedFileInfo.objectToEntry(rfInfo, dataEntry);
        BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
        try (Cursor cursor = DbInternal.makeCursor(this.reservedFilesDb, (Locker)locker, null, false);){
            cursor.put(keyEntry, dataEntry, Put.OVERWRITE, null);
        }
        finally {
            locker.operationEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteReservedFileRecord(Long file) {
        DatabaseEntry keyEntry = new DatabaseEntry();
        ReservedFileInfo.keyToEntry(file, keyEntry);
        ReadOptions readOptions = new ReadOptions().setLockMode(LockMode.RMW);
        BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
        try (Cursor cursor = DbInternal.makeCursor(this.reservedFilesDb, (Locker)locker, null);){
            if (cursor.get(keyEntry, null, Get.SEARCH, readOptions) != null) {
                cursor.delete(null);
            }
        }
        finally {
            locker.operationEnd();
        }
    }

    void removeDeletedFile(Long fileNum) throws DatabaseException {
        this.removeFileSummaries(Collections.singleton(fileNum));
        this.deleteFileSummary(fileNum);
    }

    synchronized void removeFileSummaries(Set<Long> files) {
        assert (this.cachePopulated);
        for (Long fileNum : files) {
            FileSummary oldSummary = (FileSummary)this.fileSummaryMap.remove(fileNum);
            if (oldSummary == null) continue;
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(0 - MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFileSummary(Long fileNum) throws DatabaseException {
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(true);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            dataEntry.setPartial(0, 0, true);
            OperationResult result = null;
            if (this.getFirstFSLN(cursor, fileNum, keyEntry, dataEntry, LockType.WRITE)) {
                result = DbInternal.DEFAULT_RESULT;
            }
            while (result != null && fileNum == FileSummaryLN.getFileNumber(keyEntry.getData())) {
                this.env.daemonEviction(true);
                cursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                result = cursor.getNext(keyEntry, dataEntry, LockType.WRITE, false, true, false, null);
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
        TrackedFileSummary tfs = this.tracker.getTrackedFile(fileNum);
        if (tfs != null) {
            this.env.getLogManager().removeTrackedFile(tfs);
        }
    }

    void flushFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (tfs.getAllowFlush()) {
            this.putFileSummary(tfs);
        }
    }

    private synchronized PackedOffsets putFileSummary(TrackedFileSummary tfs) throws DatabaseException {
        if (this.env.isReadOnly()) {
            throw EnvironmentFailureException.unexpectedState("Cannot write file summary in a read-only environment");
        }
        if (tfs.isEmpty()) {
            return null;
        }
        if (!this.cachePopulated) {
            return null;
        }
        long fileNum = tfs.getFileNumber();
        Long fileNumLong = fileNum;
        FileSummary summary = (FileSummary)this.fileSummaryMap.get(fileNumLong);
        if (summary == null) {
            if (!this.env.getFileProtector().isActiveOrNewFile(fileNumLong)) {
                this.env.getLogManager().removeTrackedFile(tfs);
                return null;
            }
            summary = new FileSummary();
        }
        FileSummary tmp = new FileSummary();
        tmp.add(summary);
        tmp.add(tfs);
        int sequence = tmp.getEntriesCounted();
        FileSummaryLN ln = new FileSummaryLN(summary);
        ln.setTrackedSummary(tfs);
        this.addFileSummary(ln, fileNumLong, sequence);
        return ln.getObsoleteOffsets();
    }

    private synchronized void addFileSummary(FileSummaryLN ln, Long fileNum, int sequence) {
        this.insertFileSummary(ln, fileNum, sequence);
        FileSummary summary = ln.getBaseSummary();
        if (this.fileSummaryMap.put(fileNum, summary) == null) {
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(MemoryBudget.UTILIZATION_PROFILE_ENTRY);
        }
    }

    private synchronized long addReactivatedFileSummary(Long file) {
        this.deleteFileSummary(file);
        File fileObj = new File(this.env.getFileManager().getFullFileName(file));
        int size = (int)fileObj.length();
        FileSummary summary = new FileSummary();
        summary.totalCount = 1;
        summary.totalSize = size;
        summary.totalLNCount = 1;
        summary.totalLNSize = size;
        summary.maxLNSize = size;
        summary.obsoleteLNCount = 1;
        summary.obsoleteLNSize = size;
        summary.obsoleteLNSizeCounted = 1;
        FileSummaryLN ln = new FileSummaryLN(summary);
        this.addFileSummary(ln, file, 0);
        return size;
    }

    void reactivateReservedFile(Long file) {
        this.deleteReservedFileRecord(file);
        this.env.flushLog(false);
        LoggerUtils.warning(this.logger, this.env, "Reactivated reserved file: 0x" + Long.toHexString(file));
        if (incompleteReactivateHook != null) {
            incompleteReactivateHook.doHook(this.env);
        }
        long size = this.addReactivatedFileSummary(file);
        this.env.getFileProtector().reactivateReservedFile(file, size);
    }

    PackedOffsets getObsoleteDetailPacked(Long fileNum, boolean logUpdate, Runnable beforeWork) throws DatabaseException {
        PackedOffsets packedOffsets = new PackedOffsets();
        if (!this.env.getCleaner().trackDetail) {
            return packedOffsets;
        }
        packedOffsets.pack(this.getObsoleteDetailInternal(fileNum, logUpdate, beforeWork));
        return packedOffsets;
    }

    public long[] getObsoleteDetailSorted(Long fileNum) throws DatabaseException {
        long[] sortedOffsets = new long[]{};
        if (!this.env.getCleaner().trackDetail) {
            return sortedOffsets;
        }
        sortedOffsets = this.getObsoleteDetailInternal(fileNum, false, null);
        Arrays.sort(sortedOffsets);
        return sortedOffsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] getObsoleteDetailInternal(Long fileNum, boolean logUpdate, Runnable beforeWork) throws DatabaseException {
        assert (this.cachePopulated);
        if (beforeWork == null) {
            beforeWork = EMPTY_RUNNABLE;
        }
        long fileNumVal = fileNum;
        ArrayList<long[]> list = new ArrayList<long[]>();
        TrackedFileSummary tfs = this.env.getLogManager().getUnflushableTrackedSummary(fileNumVal);
        try {
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            CursorImpl cursor = new CursorImpl(this.fileSummaryDb, locker);
            try {
                cursor.setAllowEviction(true);
                DatabaseEntry keyEntry = new DatabaseEntry();
                DatabaseEntry dataEntry = new DatabaseEntry();
                beforeWork.run();
                OperationResult result = null;
                if (this.getFirstFSLN(cursor, fileNumVal, keyEntry, dataEntry, LockType.NONE)) {
                    result = DbInternal.DEFAULT_RESULT;
                }
                while (result != null) {
                    this.env.daemonEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (ln != null) {
                        if (fileNumVal != FileSummaryLN.getFileNumber(keyEntry.getData())) {
                            break;
                        }
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            list.add(offsets.toArray());
                        }
                        cursor.evictLN();
                    }
                    beforeWork.run();
                    result = cursor.getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                }
            }
            finally {
                cursor.close();
                locker.operationEnd();
            }
            beforeWork.run();
            if (!tfs.isEmpty()) {
                if (logUpdate) {
                    PackedOffsets offsets = this.putFileSummary(tfs);
                    if (offsets != null) {
                        list.add(offsets.toArray());
                    }
                } else {
                    long[] offsetList = tfs.getObsoleteOffsets();
                    if (offsetList != null) {
                        list.add(offsetList);
                    }
                }
            }
        }
        finally {
            tfs.setAllowFlush(true);
        }
        beforeWork.run();
        int size = 0;
        for (long[] a : list) {
            size += a.length;
        }
        long[] offsets = new long[size];
        int index = 0;
        for (long[] a : list) {
            System.arraycopy(a, 0, offsets, index, a.length);
            index += a.length;
        }
        assert (index == offsets.length);
        return offsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCache(StartupTracker.Counter counter, RecoveryInfo recoveryInfo) throws DatabaseException {
        Object cursor;
        assert (!this.cachePopulated);
        if (!this.openFileSummaryDatabase()) {
            return;
        }
        Object[] existingFiles = this.env.getFileManager().getAllFileNumbers();
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        FileProtector fileProtector = this.env.getFileProtector();
        if (this.openReservedFilesDatabase()) {
            BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
            try {
                ReadOptions options = new ReadOptions().setLockMode(LockMode.READ_UNCOMMITTED);
                cursor = DbInternal.makeCursor(this.reservedFilesDb, (Locker)locker, null, false);
                try {
                    while (((Cursor)cursor).get(keyEntry, dataEntry, Get.NEXT, options) != null) {
                        counter.incNumRead();
                        this.env.daemonEviction(false);
                        Long file = ReservedFileInfo.entryToKey(keyEntry);
                        ReservedFileInfo info = ReservedFileInfo.entryToObject(dataEntry);
                        if (Arrays.binarySearch(existingFiles, file) >= 0) {
                            counter.incNumProcessed();
                            fileProtector.reserveFile(file, info.lastVLSN);
                            continue;
                        }
                        counter.incNumDeleted();
                        if (!info.lastVLSN.isNull()) {
                            recoveryInfo.lastMissingFileNumber = file;
                            recoveryInfo.lastMissingFileVLSN = info.lastVLSN;
                        }
                        if (this.env.isReadOnly()) continue;
                        ((Cursor)cursor).delete();
                    }
                }
                finally {
                    if (cursor != null) {
                        ((Cursor)cursor).close();
                    }
                }
            }
            finally {
                locker.operationEnd();
            }
        }
        int oldMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
        BasicLocker locker = null;
        cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker, false, false);
            ((CursorImpl)cursor).setAllowEviction(true);
            if (((CursorImpl)cursor).positionFirstOrLast(true)) {
                OperationResult result = ((CursorImpl)cursor).lockAndGetCurrent(keyEntry, dataEntry, LockType.NONE, false, true, true);
                if (result == null) {
                    result = ((CursorImpl)cursor).getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                }
                while (result != null) {
                    counter.incNumRead();
                    this.env.daemonEviction(false);
                    FileSummaryLN ln = (FileSummaryLN)((CursorImpl)cursor).lockAndGetCurrentLN(LockType.NONE);
                    if (ln == null) {
                        result = ((CursorImpl)cursor).getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                        continue;
                    }
                    byte[] keyBytes = keyEntry.getData();
                    boolean isOldVersion = FileSummaryLN.hasStringKey(keyBytes);
                    long fileNum = FileSummaryLN.getFileNumber(keyBytes);
                    Long fileNumLong = fileNum;
                    if (!fileProtector.isReservedFile(fileNumLong) && Arrays.binarySearch(existingFiles, fileNumLong) >= 0) {
                        counter.incNumProcessed();
                        FileSummary summary = ln.getBaseSummary();
                        this.fileSummaryMap.put(fileNumLong, summary);
                        if (isOldVersion && !this.env.isReadOnly()) {
                            this.insertFileSummary(ln, fileNum, 0);
                            ((CursorImpl)cursor).deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                        } else {
                            ((CursorImpl)cursor).evictLN();
                        }
                    } else {
                        counter.incNumDeleted();
                        this.fileSummaryMap.remove(fileNumLong);
                        if (!this.env.isReadOnly()) {
                            if (isOldVersion) {
                                ((CursorImpl)cursor).deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                            } else {
                                this.deleteFileSummary(fileNumLong);
                            }
                        }
                    }
                    if (isOldVersion) {
                        result = ((CursorImpl)cursor).getNext(keyEntry, dataEntry, LockType.NONE, false, true, false, null);
                        continue;
                    }
                    if (this.getFirstFSLN((CursorImpl)cursor, fileNum + 1L, keyEntry, dataEntry, LockType.NONE)) continue;
                    result = null;
                }
            }
        }
        finally {
            if (cursor != null) {
                ((CursorImpl)cursor).close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
            int newMemorySize = this.fileSummaryMap.size() * MemoryBudget.UTILIZATION_PROFILE_ENTRY;
            MemoryBudget mb = this.env.getMemoryBudget();
            mb.updateAdminMemoryUsage(newMemorySize - oldMemorySize);
        }
        long firstActiveFile = recoveryInfo.checkpointStartLsn != -1L ? DbLsn.getFileNumber(recoveryInfo.checkpointStartLsn) : 0L;
        for (Object file : existingFiles) {
            if ((Long)file >= firstActiveFile || fileProtector.isReservedFile((Long)file) || this.fileSummaryMap.containsKey(file)) continue;
            this.addReactivatedFileSummary((Long)file);
            LoggerUtils.info(this.logger, this.env, "Reactivated file during recovery: 0x" + Long.toHexString((Long)file));
        }
        this.cachePopulated = true;
    }

    public boolean hasReservedFileLN(long fileNum) {
        BasicLocker locker = BasicLocker.createBasicLocker(this.env, false);
        try {
            ReadOptions options = new ReadOptions().setLockMode(LockMode.READ_UNCOMMITTED);
            Cursor cursor = DbInternal.makeCursor(this.reservedFilesDb, (Locker)locker, null, false);
            try {
                boolean bl;
                DatabaseEntry keyEntry = new DatabaseEntry();
                ReservedFileInfo.keyToEntry(fileNum, keyEntry);
                boolean bl2 = bl = cursor.get(keyEntry, null, Get.SEARCH, options) != null;
                if (cursor != null) {
                    cursor.close();
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (cursor != null) {
                    try {
                        cursor.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            locker.operationEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFileSummaryLN(long fileNum) {
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            DatabaseEntry keyEntry = new DatabaseEntry();
            DatabaseEntry dataEntry = new DatabaseEntry();
            dataEntry.setPartial(0, 0, true);
            boolean bl = this.getFirstFSLN(cursor, fileNum, keyEntry, dataEntry, LockType.NONE) && fileNum == FileSummaryLN.getFileNumber(keyEntry.getData());
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getFirstFSLN(CursorImpl cursor, long fileNum, DatabaseEntry keyEntry, DatabaseEntry dataEntry, LockType lockType) throws DatabaseException {
        byte[] keyBytes = FileSummaryLN.makePartialKey(fileNum);
        keyEntry.setData(keyBytes);
        cursor.reset();
        try {
            boolean exactKeyMatch;
            int result = cursor.searchRange(keyEntry, null);
            if ((result & 1) == 0) {
                boolean bl = false;
                return bl;
            }
            boolean bl = exactKeyMatch = (result & 2) != 0;
            if (exactKeyMatch && cursor.lockAndGetCurrent(keyEntry, dataEntry, lockType, false, true, false) != null) {
                boolean bl2 = true;
                return bl2;
            }
        }
        finally {
            cursor.releaseBIN();
        }
        cursor.evictLN();
        OperationResult result = cursor.getNext(keyEntry, dataEntry, lockType, false, true, false, null);
        return result != null;
    }

    private boolean openReservedFilesDatabase() throws DatabaseException {
        if (this.reservedFilesDb != null) {
            return true;
        }
        this.reservedFilesDb = this.env.getDbTree().openNonRepInternalDB(DbType.RESERVED_FILES);
        return this.reservedFilesDb != null;
    }

    private boolean openFileSummaryDatabase() throws DatabaseException {
        if (this.fileSummaryDb != null) {
            return true;
        }
        this.fileSummaryDb = this.env.getDbTree().openNonRepInternalDB(DbType.UTILIZATION);
        return this.fileSummaryDb != null;
    }

    DatabaseImpl getFileSummaryDb() {
        return this.fileSummaryDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean insertFileSummary(FileSummaryLN ln, long fileNum, int sequence) throws DatabaseException {
        byte[] keyBytes = FileSummaryLN.makeFullKey(fileNum, sequence);
        BasicLocker locker = null;
        CursorImpl cursor = null;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            boolean inserted = cursor.insertRecord(keyBytes, ln, false, ReplicationContext.NO_REPLICATE);
            if (!inserted) {
                LoggerUtils.traceAndLog(this.logger, this.env, Level.SEVERE, "Cleaner duplicate key sequence file=0x" + Long.toHexString(fileNum) + " sequence=0x" + Long.toHexString(sequence));
                boolean bl = false;
                return bl;
            }
            cursor.evictLN();
            boolean bl = true;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean verifyFileSummaryDatabase() throws DatabaseException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        this.openFileSummaryDatabase();
        BasicLocker locker = null;
        CursorImpl cursor = null;
        boolean ok = true;
        try {
            locker = BasicLocker.createBasicLocker(this.env, false);
            cursor = new CursorImpl(this.fileSummaryDb, locker);
            cursor.setAllowEviction(true);
            if (cursor.positionFirstOrLast(true)) {
                OperationResult result = cursor.lockAndGetCurrent(key, data, LockType.NONE, false, true, true);
                while (result != null) {
                    this.env.daemonEviction(true);
                    FileSummaryLN ln = (FileSummaryLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                    if (ln != null) {
                        long fileNumVal = FileSummaryLN.getFileNumber(key.getData());
                        PackedOffsets offsets = ln.getObsoleteOffsets();
                        if (offsets != null) {
                            long[] vals;
                            for (long val : vals = offsets.toArray()) {
                                long lsn = DbLsn.makeLsn(fileNumVal, val);
                                if (this.verifyLsnIsObsolete(lsn)) continue;
                                ok = false;
                            }
                        }
                        cursor.evictLN();
                    }
                    result = cursor.getNext(key, data, LockType.NONE, false, true, false, null);
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyLsnIsObsolete(long lsn) throws DatabaseException {
        LogEntry o = this.env.getLogManager().getLogEntryHandleNotFound(lsn);
        if (!(o instanceof LNLogEntry)) {
            return true;
        }
        LNLogEntry entry = (LNLogEntry)o;
        DatabaseId dbId = entry.getDbId();
        DatabaseImpl db = this.env.getDbTree().getDb(dbId);
        IN bin = null;
        try {
            if (db == null || db.isDeleting()) {
                boolean bl = true;
                return bl;
            }
            if (entry.isImmediatelyObsolete(db)) {
                boolean bl = true;
                return bl;
            }
            entry.postFetchInit(db);
            Tree tree = db.getTree();
            TreeLocation location = new TreeLocation();
            boolean parentFound = tree.getParentBINForChildLN(location, entry.getKey(), false, false, CacheMode.UNCHANGED);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                boolean bl = true;
                return bl;
            }
            if (bin.isEntryKnownDeleted(index)) {
                boolean bl = true;
                return bl;
            }
            if (bin.getLsn(index) != lsn) {
                boolean bl = true;
                return bl;
            }
            System.err.println("lsn " + DbLsn.getNoFormatString(lsn) + " was found in tree.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.env.getDbTree().releaseDb(db);
            if (bin != null) {
                bin.releaseLatch();
            }
        }
    }

    void close() {
        this.clearCache();
    }

    public static void setIncompleteReactivateHook(TestHook hook) {
        incompleteReactivateHook = hook;
    }
}

