/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.BinaryEqualityComparator;
import com.sleepycat.je.BtreeStats;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseComparator;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.PartialComparator;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStats;
import com.sleepycat.je.SecondaryDatabase;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.DbFileSummaryMap;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.DiskOrderedScanner;
import com.sleepycat.je.dbi.DupKeyData;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.ReplicatedDatabaseConfig;
import com.sleepycat.je.dbi.TriggerManager;
import com.sleepycat.je.dbi.TriggerUtils;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.trigger.PersistentTrigger;
import com.sleepycat.je.trigger.Trigger;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.util.verify.BtreeVerifier;
import com.sleepycat.je.utilint.JVMSystemUtils;
import com.sleepycat.util.ClassResolver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class DatabaseImpl
implements Loggable,
Cloneable {
    private static final short NOT_DELETED = 1;
    private static final short DELETE_STARTED = 2;
    private static final short DELETE_FINISHED = 3;
    private byte flags;
    private static final byte DUPS_ENABLED = 1;
    private static final byte TEMPORARY_BIT = 2;
    private static final byte IS_REPLICATED_BIT = 4;
    private static final byte NOT_REPLICATED_BIT = 8;
    private static final byte PREFIXING_ENABLED = 16;
    private static final byte DUPS_CONVERTED = 64;
    private DatabaseId id;
    private Tree tree;
    private EnvironmentImpl envImpl;
    private boolean transactional;
    private boolean durableDeferredWrite;
    private volatile boolean dirty;
    private Set<Database> referringHandles;
    private long eofLsn;
    private volatile short deleteState;
    private AtomicInteger useCount = new AtomicInteger();
    private final AtomicInteger writeCount = new AtomicInteger();
    private DbFileSummaryMap dbFileSummaries = null;
    private byte createdAtLogVersion;
    private Comparator<byte[]> btreeComparator = null;
    private Comparator<byte[]> duplicateComparator = null;
    private byte[] btreeComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private byte[] duplicateComparatorBytes = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
    private boolean btreeComparatorByClassName = false;
    private boolean duplicateComparatorByClassName = false;
    private boolean btreePartialComparator = false;
    private boolean duplicatePartialComparator = false;
    private boolean btreeBinaryEqualityComparator = true;
    private boolean duplicateBinaryEqualityComparator = true;
    private Comparator<byte[]> keyComparator = null;
    private AtomicReference<List<Trigger>> triggers = new AtomicReference<Object>(null);
    private List<Trigger> transientTriggers = null;
    private byte[][] triggerBytes = null;
    private int binDeltaPercent;
    private int maxTreeEntriesPerNode;
    private volatile String name;
    private volatile boolean knownSecondary = false;
    private DbType dbType;
    private CacheMode cacheMode;
    private static final boolean forceKeyPrefixing;

    public DatabaseImpl(Locker locker, String dbName, DatabaseId id, EnvironmentImpl envImpl, DatabaseConfig dbConfig) throws DatabaseException {
        this.id = id;
        this.envImpl = envImpl;
        this.setConfigProperties(locker, dbName, dbConfig, envImpl);
        this.cacheMode = dbConfig.getCacheMode();
        this.createdAtLogVersion = (byte)17;
        if (this.getSortedDuplicates()) {
            this.setDupsConverted();
        }
        this.commonInit();
        this.initWithEnvironment();
        this.tree = new Tree(this);
        this.setNameAndType(dbName);
    }

    public DatabaseImpl() {
        this.id = new DatabaseId();
        this.envImpl = null;
        this.tree = new Tree();
        this.commonInit();
    }

    public void setConfigProperties(Locker locker, String dbName, DatabaseConfig dbConfig, EnvironmentImpl envImpl) {
        this.setBtreeComparator(dbConfig.getBtreeComparator(), dbConfig.getBtreeComparatorByClassName());
        this.setDuplicateComparator(dbConfig.getDuplicateComparator(), dbConfig.getDuplicateComparatorByClassName());
        this.setTriggers(locker, dbName, dbConfig.getTriggers(), true);
        if (dbConfig.getSortedDuplicates()) {
            this.setSortedDuplicates();
        }
        if (dbConfig.getKeyPrefixing() || forceKeyPrefixing) {
            this.setKeyPrefixing();
        } else {
            this.clearKeyPrefixing();
        }
        if (dbConfig.getTemporary()) {
            this.setTemporary();
        }
        if (envImpl.isReplicated()) {
            if (dbConfig.getReplicated()) {
                this.setIsReplicatedBit();
            } else {
                this.setNotReplicatedBit();
            }
        }
        this.transactional = dbConfig.getTransactional();
        this.durableDeferredWrite = dbConfig.getDeferredWrite();
        this.maxTreeEntriesPerNode = dbConfig.getNodeMaxEntries();
    }

    private void commonInit() {
        this.deleteState = 1;
        this.referringHandles = Collections.synchronizedSet(new HashSet());
    }

    public void setNameAndType(String name) {
        this.name = name;
        this.dbType = DbTree.typeForDbName(name);
    }

    boolean isKnownSecondary() {
        return this.knownSecondary;
    }

    public void setKnownSecondary() {
        this.knownSecondary = true;
    }

    private void initWithEnvironment() {
        this.eofLsn = this.envImpl.getNodeSequence().getNextTransientLsn();
        assert (!this.replicatedBitSet() || !this.notReplicatedBitSet()) : "The replicated AND notReplicated bits should never be set  together";
        DbConfigManager configMgr = this.envImpl.getConfigManager();
        this.binDeltaPercent = configMgr.getInt(EnvironmentParams.BIN_DELTA_PERCENT);
        if (this.maxTreeEntriesPerNode == 0) {
            this.maxTreeEntriesPerNode = configMgr.getInt(EnvironmentParams.NODE_MAX);
        }
        if (!this.envImpl.getNoComparators()) {
            ComparatorReader reader = new ComparatorReader(this.btreeComparatorBytes, "BtreeComparator", this.envImpl.getClassLoader());
            this.btreeComparator = reader.getComparator();
            this.btreeComparatorByClassName = reader.isClass();
            this.btreePartialComparator = this.btreeComparator instanceof PartialComparator;
            this.btreeBinaryEqualityComparator = this.btreeComparator == null || this.btreeComparator instanceof BinaryEqualityComparator;
            reader = new ComparatorReader(this.duplicateComparatorBytes, "DuplicateComparator", this.envImpl.getClassLoader());
            this.duplicateComparator = reader.getComparator();
            this.duplicateComparatorByClassName = reader.isClass();
            this.duplicatePartialComparator = this.duplicateComparator instanceof PartialComparator;
            this.duplicateBinaryEqualityComparator = this.duplicateComparator == null || this.duplicateComparator instanceof BinaryEqualityComparator;
            this.resetKeyComparator();
        }
    }

    DatabaseImpl cloneDatabase() {
        DatabaseImpl newDb;
        try {
            newDb = (DatabaseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            assert (false) : e;
            return null;
        }
        newDb.id = null;
        newDb.tree = null;
        newDb.createdAtLogVersion = (byte)17;
        newDb.useCount = new AtomicInteger();
        return newDb;
    }

    public Tree getTree() {
        return this.tree;
    }

    void setTree(Tree tree) {
        this.tree = tree;
    }

    public DatabaseId getId() {
        return this.id;
    }

    void setId(DatabaseId id) {
        this.id = id;
    }

    long getEofLsn() {
        return this.eofLsn;
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    public void setTransactional(boolean transactional) {
        this.transactional = transactional;
    }

    public boolean isTemporary() {
        return (this.flags & 2) != 0;
    }

    public static boolean isTemporary(byte flagVal) {
        return (flagVal & 2) != 0;
    }

    public boolean isInternalDb() {
        return this.getDbType().isInternal();
    }

    public DbType getDbType() {
        return this.dbType;
    }

    private void setTemporary() {
        this.flags = (byte)(this.flags | 2);
    }

    public boolean isDurableDeferredWrite() {
        return this.durableDeferredWrite;
    }

    public boolean isDeferredWriteMode() {
        return this.isDurableDeferredWrite() || this.isTemporary();
    }

    public void setDeferredWrite(boolean durableDeferredWrite) {
        this.durableDeferredWrite = durableDeferredWrite;
    }

    public boolean getSortedDuplicates() {
        return (this.flags & 1) != 0;
    }

    public static boolean getSortedDuplicates(byte flagVal) {
        return (flagVal & 1) != 0;
    }

    public void setSortedDuplicates() {
        this.flags = (byte)(this.flags | 1);
    }

    public boolean getDupsConverted() {
        return (this.flags & 0x40) != 0;
    }

    public void setDupsConverted() {
        this.flags = (byte)(this.flags | 0x40);
    }

    public boolean isLNImmediatelyObsolete() {
        return this.getSortedDuplicates() && !this.btreePartialComparator && !this.duplicatePartialComparator;
    }

    public List<Trigger> getTriggers() {
        if (this.envImpl == null || this.envImpl.getNoComparators()) {
            return null;
        }
        if (this.triggerBytes == null && this.transientTriggers == null) {
            return null;
        }
        List<Trigger> myTriggers = this.triggers.get();
        if (myTriggers != null) {
            return myTriggers;
        }
        myTriggers = TriggerUtils.unmarshallTriggers(this.getName(), this.triggerBytes, this.envImpl.getClassLoader());
        if (myTriggers == null) {
            myTriggers = new LinkedList<Trigger>();
        }
        if (this.transientTriggers != null) {
            myTriggers.addAll(this.transientTriggers);
        }
        if (this.triggers.compareAndSet(null, myTriggers)) {
            return myTriggers;
        }
        myTriggers = this.triggers.get();
        assert (myTriggers != null);
        return myTriggers;
    }

    public boolean hasUserTriggers() {
        return this.triggerBytes != null || this.transientTriggers != null;
    }

    public boolean getKeyPrefixing() {
        return (this.flags & 0x10) != 0;
    }

    static boolean getKeyPrefixing(byte flagVal) {
        return (flagVal & 0x10) != 0;
    }

    public void setKeyPrefixing() {
        this.flags = (byte)(this.flags | 0x10);
    }

    public void clearKeyPrefixing() {
        if (forceKeyPrefixing) {
            return;
        }
        this.flags = (byte)(this.flags & 0xFFFFFFEF);
    }

    public boolean isReplicated() {
        return this.replicatedBitSet();
    }

    public boolean unknownReplicated() {
        return (this.flags & 4) == 0 && (this.flags & 8) == 0;
    }

    private boolean replicatedBitSet() {
        return (this.flags & 4) != 0;
    }

    public void setIsReplicatedBit() {
        this.flags = (byte)(this.flags | 4);
    }

    private boolean notReplicatedBitSet() {
        return (this.flags & 8) != 0;
    }

    private void setNotReplicatedBit() {
        this.flags = (byte)(this.flags | 8);
    }

    public int getNodeMaxTreeEntries() {
        return this.maxTreeEntriesPerNode;
    }

    public void setNodeMaxTreeEntries(int newNodeMaxTreeEntries) {
        this.maxTreeEntriesPerNode = newNodeMaxTreeEntries;
    }

    public boolean allowReplicaWrite() {
        return !this.isReplicated() || this.getDbType().isMixedReplication();
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = mode;
    }

    public CacheMode getDefaultCacheMode() {
        if (this.cacheMode != null) {
            return this.cacheMode;
        }
        if (this.isInternalDb()) {
            return CacheMode.DEFAULT;
        }
        return this.envImpl.getDefaultCacheMode();
    }

    public boolean setDuplicateComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        byte[] newBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "DuplicateComparator");
        boolean changed = !Arrays.equals(newBytes, this.duplicateComparatorBytes) || comparator instanceof PartialComparator != this.duplicateComparator instanceof PartialComparator || comparator instanceof BinaryEqualityComparator != this.duplicateComparator instanceof BinaryEqualityComparator;
        this.duplicateComparator = comparator;
        this.duplicateComparatorBytes = newBytes;
        this.duplicateComparatorByClassName = byClassName;
        this.duplicatePartialComparator = this.duplicateComparator instanceof PartialComparator;
        boolean bl = this.duplicateBinaryEqualityComparator = this.duplicateComparator == null || this.duplicateComparator instanceof BinaryEqualityComparator;
        if (changed) {
            this.resetKeyComparator();
        }
        return changed;
    }

    public boolean setTriggers(Locker locker, String dbName, List<Trigger> newTriggers, boolean overridePersistentTriggers) {
        boolean transientChange;
        LinkedList<Trigger> newTransientTriggers;
        boolean persistentChange;
        Object newTriggerBytes;
        if (newTriggers != null && newTriggers.size() == 0) {
            newTriggers = null;
        }
        if (overridePersistentTriggers) {
            if (newTriggers == null) {
                newTriggerBytes = null;
                persistentChange = this.triggerBytes != null;
            } else {
                int nTriggers = 0;
                for (Trigger trigger : newTriggers) {
                    if (!(trigger instanceof PersistentTrigger)) continue;
                    ++nTriggers;
                }
                if (nTriggers == 0) {
                    newTriggerBytes = null;
                    persistentChange = this.triggerBytes != null;
                } else {
                    newTriggerBytes = new byte[nTriggers][];
                    int i = 0;
                    for (Trigger trigger : newTriggers) {
                        if (!(trigger instanceof PersistentTrigger)) continue;
                        newTriggerBytes[i++] = DatabaseImpl.objectToBytes(trigger, "Trigger-" + trigger.getName());
                        trigger.setDatabaseName(dbName);
                    }
                    persistentChange = !Arrays.equals((Object[])this.triggerBytes, (Object[])newTriggerBytes);
                }
            }
        } else {
            newTriggerBytes = this.triggerBytes;
            persistentChange = false;
        }
        if (newTriggers == null) {
            newTransientTriggers = null;
            transientChange = this.transientTriggers != null;
        } else {
            newTransientTriggers = new LinkedList<Trigger>();
            IdentityHashMap identityHashMap = new IdentityHashMap();
            for (Trigger trigger : newTriggers) {
                if (trigger instanceof PersistentTrigger) continue;
                identityHashMap.put(trigger, null);
                newTransientTriggers.add(trigger);
                trigger.setDatabaseName(dbName);
            }
            if (this.transientTriggers == null) {
                transientChange = newTransientTriggers.size() > 0;
            } else if (this.transientTriggers.size() != newTransientTriggers.size()) {
                transientChange = true;
            } else {
                for (Trigger trigger : this.transientTriggers) {
                    identityHashMap.remove(trigger);
                }
                boolean bl = transientChange = identityHashMap.size() > 0;
            }
        }
        if (persistentChange || transientChange) {
            TriggerManager.invokeAddRemoveTriggers(locker, this.getTriggers(), newTriggers);
            this.triggerBytes = newTriggerBytes;
            this.transientTriggers = newTransientTriggers != null && newTransientTriggers.size() > 0 ? newTransientTriggers : null;
            this.triggers.set(newTriggers);
        }
        return persistentChange;
    }

    private void clearTransientTriggers() {
        List<Trigger> oldTriggers = this.getTriggers();
        if (oldTriggers == null) {
            return;
        }
        LinkedList<Trigger> newTriggers = new LinkedList<Trigger>(oldTriggers);
        Iterator iter = newTriggers.iterator();
        while (iter.hasNext()) {
            Trigger trigger = (Trigger)iter.next();
            if (trigger instanceof PersistentTrigger) continue;
            iter.remove();
        }
        this.setTriggers(null, null, newTriggers, false);
    }

    public boolean setBtreeComparator(Comparator<byte[]> comparator, boolean byClassName) throws DatabaseException {
        byte[] newBytes = DatabaseImpl.comparatorToBytes(comparator, byClassName, "BtreeComparator");
        boolean changed = !Arrays.equals(newBytes, this.btreeComparatorBytes) || this.btreeComparator instanceof PartialComparator != comparator instanceof PartialComparator || this.btreeComparator instanceof BinaryEqualityComparator != comparator instanceof BinaryEqualityComparator;
        this.btreeComparator = comparator;
        this.btreeComparatorBytes = newBytes;
        this.btreeComparatorByClassName = byClassName;
        this.btreePartialComparator = this.btreeComparator instanceof PartialComparator;
        boolean bl = this.btreeBinaryEqualityComparator = this.btreeComparator == null || this.btreeComparator instanceof BinaryEqualityComparator;
        if (changed) {
            this.resetKeyComparator();
        }
        return changed;
    }

    public Comparator<byte[]> getBtreeComparator() {
        return this.btreeComparator;
    }

    public Comparator<byte[]> getDuplicateComparator() {
        return this.duplicateComparator;
    }

    private void resetKeyComparator() {
        if (this.btreeComparator instanceof DatabaseComparator) {
            ((DatabaseComparator)this.btreeComparator).initialize(this.envImpl.getClassLoader());
        }
        if (this.duplicateComparator instanceof DatabaseComparator) {
            ((DatabaseComparator)this.duplicateComparator).initialize(this.envImpl.getClassLoader());
        }
        this.keyComparator = this.getSortedDuplicates() ? new DupKeyData.TwoPartKeyComparator(this.btreeComparator, this.duplicateComparator) : this.btreeComparator;
    }

    public Comparator<byte[]> getKeyComparator() {
        return this.keyComparator;
    }

    public boolean getBtreeComparatorByClass() {
        return this.btreeComparatorByClassName;
    }

    public boolean getDuplicateComparatorByClass() {
        return this.duplicateComparatorByClassName;
    }

    public boolean allowsKeyUpdates() {
        return this.btreePartialComparator || this.duplicatePartialComparator;
    }

    public boolean hasBtreeBinaryEqualityComparator() {
        return this.btreeBinaryEqualityComparator;
    }

    public boolean hasDuplicateBinaryEqualityComparator() {
        return this.duplicateBinaryEqualityComparator;
    }

    public void setEnvironmentImpl(EnvironmentImpl envImpl) {
        this.envImpl = envImpl;
        this.initWithEnvironment();
        this.tree.setDatabase(this);
    }

    public EnvironmentImpl getEnv() {
        return this.envImpl;
    }

    public boolean hasOpenHandles() {
        return this.referringHandles.size() > 0;
    }

    public void addReferringHandle(Database db) {
        this.referringHandles.add(db);
    }

    public void removeReferringHandle(Database db) {
        this.referringHandles.remove(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Database> getReferringHandles() {
        HashSet<Database> copy = new HashSet<Database>();
        Set<Database> set = this.referringHandles;
        synchronized (set) {
            copy.addAll(this.referringHandles);
        }
        return copy;
    }

    public void handleClosed(boolean doSyncDw, boolean deleteTempDb) throws DatabaseException {
        if (this.referringHandles.isEmpty()) {
            this.clearTransientTriggers();
            if (deleteTempDb && this.isTemporary()) {
                BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl, true);
                boolean operationOk = false;
                try {
                    this.envImpl.getDbTree().dbRemove(locker, this.getName(), this.getId());
                    operationOk = true;
                }
                catch (DbTree.NeedRepLockerException e) {
                    throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
                }
                catch (DatabaseNotFoundException e) {
                }
                catch (LockConflictException e) {
                }
                catch (Error E) {
                    this.envImpl.invalidate(E);
                    throw E;
                }
                finally {
                    ((Locker)locker).operationEnd(operationOk);
                }
            }
            if (doSyncDw && this.isDurableDeferredWrite()) {
                this.sync(true);
            }
        }
    }

    int getReferringHandleCount() {
        return this.referringHandles.size();
    }

    void incrementUseCount() {
        if (this.isDeleteFinished()) {
            throw EnvironmentFailureException.unexpectedState("DeleteFinished state for active DB id=" + this.id + " name=" + this.name + " useCount=" + this.useCount.get());
        }
        this.useCount.incrementAndGet();
    }

    public int noteWriteHandleOpen() {
        return this.writeCount.incrementAndGet();
    }

    public int noteWriteHandleClose() {
        int count = this.writeCount.decrementAndGet();
        assert (count >= 0);
        return count;
    }

    void decrementUseCount() {
        assert (this.useCount.get() > 0);
        this.useCount.decrementAndGet();
    }

    public boolean isInUse() {
        return this.useCount.get() > 0;
    }

    boolean isInUseDuringDbRemove() {
        return this.useCount.get() > 1;
    }

    public synchronized void sync(boolean flushLog) throws DatabaseException {
        if (!this.isDurableDeferredWrite()) {
            throw new UnsupportedOperationException("Database.sync() is only supported for deferred-write databases");
        }
        if (this.tree.rootExists()) {
            this.envImpl.getCheckpointer().syncDatabase(this.envImpl, this, flushLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Database findPrimaryDatabase() {
        Set<Database> set = this.referringHandles;
        synchronized (set) {
            for (Database obj : this.referringHandles) {
                if (!(obj instanceof SecondaryDatabase)) continue;
                return ((SecondaryDatabase)obj).getPrimaryDatabase();
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void clearDbFileSummaries() {
        this.dbFileSummaries = null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    public boolean isCheckpointNeeded() {
        return this.isDirty() || this.isTemporary();
    }

    public boolean isDeleting() {
        return this.deleteState != 1;
    }

    public boolean isDeleteFinished() {
        return this.deleteState == 3;
    }

    public void setDeleteStarted() {
        assert (this.deleteState == 1);
        this.deleteState = (short)2;
    }

    public void setDeleteFinished() {
        assert (this.deleteState == 2);
        this.deleteState = (short)3;
    }

    public void countObsoleteOldVersionDb(BaseUtilizationTracker tracker, long mapLnLsn) {
        if (this.dbFileSummaries != null) {
            tracker.countObsoleteDb(this.dbFileSummaries, mapLnLsn);
        }
    }

    public BtreeStats stat(StatsConfig config) throws DatabaseException {
        BtreeStats stats;
        if (this.tree == null) {
            return new BtreeStats();
        }
        if (config.getFast()) {
            stats = new BtreeStats();
        } else {
            VerifyConfig verifyConfig = new VerifyConfig();
            verifyConfig.setShowProgressInterval(config.getShowProgressInterval());
            verifyConfig.setShowProgressStream(config.getShowProgressStream());
            stats = this.verify(verifyConfig);
        }
        return stats;
    }

    public BtreeStats verify(VerifyConfig config) throws DatabaseException {
        if (this.tree == null) {
            return new BtreeStats();
        }
        BtreeVerifier verifier = new BtreeVerifier(this.envImpl);
        verifier.setBtreeVerifyConfig(config);
        return verifier.verifyDatabase(this.getName(), this.getId());
    }

    public PreloadStats preload(PreloadConfig config) throws DatabaseException {
        return this.envImpl.preload(new DatabaseImpl[]{this}, config);
    }

    public long count(long memoryLimit) throws DatabaseException {
        try {
            MemoryBudget mb = this.envImpl.getMemoryBudget();
            long minMem = 0x100000L;
            if (memoryLimit <= 0L) {
                memoryLimit = (JVMSystemUtils.getRuntimeMaxMemory() - mb.getMaxMemory()) / 10L;
            }
            if (memoryLimit < minMem) {
                return this.count(null, true, null, true);
            }
            DOSCountCallback counter = new DOSCountCallback();
            DatabaseImpl[] dbs = new DatabaseImpl[]{this};
            DiskOrderedScanner scanner = new DiskOrderedScanner(dbs, counter, true, true, true, true, Long.MAX_VALUE, memoryLimit, false);
            scanner.scan("DatabaseCount", this.envImpl.getNodeSequence().getNextDatabaseCountId());
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
            return counter.count;
        }
        catch (Error E) {
            this.envImpl.invalidate(E);
            throw E;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long count(DatabaseEntry beginKey, boolean beginInclusive, DatabaseEntry endKey, boolean endInclusive) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry noData = new DatabaseEntry();
        noData.setPartial(0, 0, true);
        BasicLocker locker = BasicLocker.createBasicLocker(this.envImpl);
        LockMode lockMode = LockMode.READ_UNCOMMITTED;
        try {
            Cursor c;
            block15: {
                block13: {
                    block14: {
                        c = DbInternal.makeCursor(this, (Locker)locker, null);
                        try {
                            if (beginKey == null) break block13;
                            key.setData(beginKey.getData(), beginKey.getOffset(), beginKey.getSize());
                            if (c.getSearchKeyRange(key, noData, lockMode) == OperationStatus.SUCCESS) break block14;
                            long l = 0L;
                            c.close();
                            return l;
                        }
                        catch (Throwable throwable) {
                            c.close();
                            throw throwable;
                        }
                    }
                    if (!beginInclusive && key.equals(beginKey) && c.getNext(key, noData, lockMode) != OperationStatus.SUCCESS) {
                        long l = 0L;
                        c.close();
                        return l;
                    }
                    break block15;
                }
                if (c.getFirst(key, noData, lockMode) == OperationStatus.SUCCESS) break block15;
                long l = 0L;
                c.close();
                return l;
            }
            RangeConstraint rangeConstraint = null;
            long l = 1L + DbInternal.getCursorImpl(c).skip(true, 0L, rangeConstraint);
            c.close();
            return l;
        }
        finally {
            ((Locker)locker).operationEnd(true);
        }
    }

    public String dumpString(int nSpaces) {
        StringBuilder sb = new StringBuilder();
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<database id=\"");
        sb.append(this.id.toString());
        sb.append("\"");
        sb.append(" deleteState=\"");
        sb.append(this.deleteState);
        sb.append("\"");
        sb.append(" useCount=\"");
        sb.append(this.useCount.get());
        sb.append("\"");
        sb.append(" dupsort=\"");
        sb.append(this.getSortedDuplicates());
        sb.append("\"");
        sb.append(" temporary=\"");
        sb.append(this.isTemporary());
        sb.append("\"");
        sb.append(" deferredWrite=\"");
        sb.append(this.isDurableDeferredWrite());
        sb.append("\"");
        sb.append(" keyPrefixing=\"");
        sb.append(this.getKeyPrefixing());
        sb.append("\"");
        if (this.btreeComparator != null) {
            sb.append(" btc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator, this.btreeComparatorBytes));
            sb.append("\"");
            sb.append(" btcPartial=\"");
            sb.append(this.btreePartialComparator);
            sb.append("\"");
        }
        if (this.duplicateComparator != null) {
            sb.append(" dupc=\"");
            sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator, this.duplicateComparatorBytes));
            sb.append("\"");
            sb.append(" dupcPartial=\"");
            sb.append(this.duplicatePartialComparator);
            sb.append("\"");
        }
        sb.append(">");
        if (this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("/file>");
            }
        }
        sb.append("</database>");
        return sb.toString();
    }

    @Override
    public int getLogSize() {
        int nameSize = !this.id.equals(DbTree.ID_DB_ID) && !this.id.equals(DbTree.NAME_DB_ID) ? LogUtils.getStringLogSize(this.name) : 0;
        int size = this.id.getLogSize() + nameSize + this.tree.getLogSize() + 1 + LogUtils.getByteArrayLogSize(this.btreeComparatorBytes) + LogUtils.getByteArrayLogSize(this.duplicateComparatorBytes) + LogUtils.getPackedIntLogSize(this.maxTreeEntriesPerNode) + 1;
        return size += TriggerUtils.logSize(this.triggerBytes);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.id.writeToLog(logBuffer);
        if (!this.id.equals(DbTree.ID_DB_ID) && !this.id.equals(DbTree.NAME_DB_ID)) {
            LogUtils.writeString(logBuffer, this.name);
        }
        this.tree.writeToLog(logBuffer);
        logBuffer.put(this.flags);
        LogUtils.writeByteArray(logBuffer, this.btreeComparatorBytes);
        LogUtils.writeByteArray(logBuffer, this.duplicateComparatorBytes);
        LogUtils.writePackedInt(logBuffer, this.maxTreeEntriesPerNode);
        logBuffer.put(this.createdAtLogVersion);
        TriggerUtils.writeTriggers(logBuffer, this.triggerBytes);
        this.dirty = false;
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        boolean version6OrLater = entryVersion >= 6;
        this.id.readFromLog(itemBuffer, entryVersion);
        if (this.id.equals(DbTree.ID_DB_ID)) {
            this.setNameAndType(DbType.ID.getInternalName());
        } else if (this.id.equals(DbTree.NAME_DB_ID)) {
            this.setNameAndType(DbType.NAME.getInternalName());
        } else if (entryVersion >= 16) {
            this.setNameAndType(LogUtils.readString(itemBuffer, false, entryVersion));
        } else {
            this.name = null;
        }
        this.tree.readFromLog(itemBuffer, entryVersion);
        this.flags = itemBuffer.get();
        if (forceKeyPrefixing) {
            this.setKeyPrefixing();
        }
        if (entryVersion >= 2) {
            this.btreeComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
            this.duplicateComparatorBytes = LogUtils.readByteArray(itemBuffer, !version6OrLater);
        } else {
            String btreeClassName = LogUtils.readString(itemBuffer, !version6OrLater, entryVersion);
            String dupClassName = LogUtils.readString(itemBuffer, !version6OrLater, entryVersion);
            this.btreeComparatorBytes = btreeClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(btreeClassName, "BtreeComparator");
            this.duplicateComparatorBytes = dupClassName.length() == 0 ? LogUtils.ZERO_LENGTH_BYTE_ARRAY : DatabaseImpl.objectToBytes(dupClassName, "DuplicateComparator");
        }
        if (entryVersion >= 1) {
            this.maxTreeEntriesPerNode = LogUtils.readInt(itemBuffer, !version6OrLater);
            if (entryVersion < 8) {
                LogUtils.readInt(itemBuffer, !version6OrLater);
            }
        }
        if (version6OrLater) {
            this.createdAtLogVersion = itemBuffer.get();
        }
        if (version6OrLater && entryVersion < 16) {
            this.dbFileSummaries = new DbFileSummaryMap();
            int nFiles = LogUtils.readPackedInt(itemBuffer);
            for (int i = 0; i < nFiles; ++i) {
                long fileNum = LogUtils.readPackedLong(itemBuffer);
                DbFileSummary summary = this.dbFileSummaries.get(fileNum);
                summary.readFromLog(itemBuffer, entryVersion);
            }
        }
        this.triggerBytes = entryVersion < 8 ? null : TriggerUtils.readTriggers(itemBuffer, entryVersion);
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<database");
        sb.append(" name=\"");
        sb.append(this.name);
        sb.append("\"");
        DatabaseImpl.dumpFlags(sb, verbose, this.flags);
        sb.append(" btcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.btreeComparator, this.btreeComparatorBytes));
        sb.append("\"");
        sb.append(" dupcmp=\"");
        sb.append(DatabaseImpl.getComparatorClassName(this.duplicateComparator, this.duplicateComparatorBytes));
        sb.append("\" > ");
        this.id.dumpLog(sb, verbose);
        this.tree.dumpLog(sb, verbose);
        if (verbose && this.dbFileSummaries != null) {
            for (Map.Entry<Long, DbFileSummary> entry : this.dbFileSummaries.entrySet()) {
                Long fileNum = entry.getKey();
                DbFileSummary summary = entry.getValue();
                sb.append("<file file=\"").append(fileNum);
                sb.append("\">");
                sb.append(summary);
                sb.append("</file>");
            }
        }
        TriggerUtils.dumpTriggers(sb, this.triggerBytes, this.getTriggers());
        sb.append("</database>");
    }

    static void dumpFlags(StringBuilder sb, boolean verbose, byte flags) {
        sb.append(" dupsort=\"").append((flags & 1) != 0);
        sb.append("\" replicated=\"").append((flags & 4) != 0);
        sb.append("\" temp=\"").append((flags & 2) != 0).append("\" ");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    private static String getComparatorClassName(Comparator<byte[]> comparator, byte[] comparatorBytes) {
        if (comparator != null) {
            return comparator.getClass().getName();
        }
        if (comparatorBytes != null && comparatorBytes.length > 0) {
            return "byteLen: " + comparatorBytes.length;
        }
        return "";
    }

    public static Comparator<byte[]> instantiateComparator(Class<? extends Comparator<byte[]>> comparatorClass, String comparatorType) {
        if (comparatorClass == null) {
            return null;
        }
        try {
            return comparatorClass.newInstance();
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to load " + comparatorType + " Comparator class.", e);
        }
    }

    public static byte[] comparatorToBytes(Comparator<byte[]> comparator, boolean byClassName, String comparatorType) {
        if (comparator == null) {
            return LogUtils.ZERO_LENGTH_BYTE_ARRAY;
        }
        Comparator<byte[]> obj = byClassName ? comparator.getClass().getName() : comparator;
        return DatabaseImpl.objectToBytes(obj, comparatorType);
    }

    public static byte[] objectToBytes(Object obj, String label) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(obj);
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to store " + label, (Exception)e);
        }
    }

    public static Object bytesToObject(byte[] bytes, String label, ClassLoader loader) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ClassResolver.Stream ois = new ClassResolver.Stream(bais, loader);
            return ois.readObject();
        }
        catch (Exception e) {
            throw EnvironmentFailureException.unexpectedException("Exception while trying to load " + label, e);
        }
    }

    public int compareEntries(DatabaseEntry entry1, DatabaseEntry entry2, boolean duplicates) {
        return Key.compareKeys(entry1.getData(), entry1.getOffset(), entry1.getSize(), entry2.getData(), entry2.getOffset(), entry2.getSize(), duplicates ? this.duplicateComparator : this.btreeComparator);
    }

    public int getBinDeltaPercent() {
        return this.binDeltaPercent;
    }

    public ReplicationContext getRepContext() {
        return this.isReplicated() ? ReplicationContext.MASTER : ReplicationContext.NO_REPLICATE;
    }

    DbOpReplicationContext getOperationRepContext(DbOperationType operationType, DatabaseId oldDbId) {
        DbOpReplicationContext context = new DbOpReplicationContext(this.isReplicated(), operationType);
        if (DbOperationType.isWriteConfigType(operationType)) {
            assert (oldDbId == null);
            context.setCreateConfig(new ReplicatedDatabaseConfig(this.flags, this.maxTreeEntriesPerNode, this.btreeComparatorBytes, this.duplicateComparatorBytes, this.triggerBytes));
        } else if (operationType == DbOperationType.TRUNCATE) {
            assert (oldDbId != null);
            context.setTruncateOldDbId(oldDbId);
        }
        return context;
    }

    DbOpReplicationContext getOperationRepContext(DbOperationType operationType) {
        assert (operationType != DbOperationType.TRUNCATE);
        return this.getOperationRepContext(operationType, null);
    }

    static {
        String forceKeyPrefixingProp = System.getProperty("je.forceKeyPrefixing");
        forceKeyPrefixing = "true".equals(forceKeyPrefixingProp);
    }

    static class ComparatorReader {
        private final boolean isClass;
        private final Class<? extends Comparator<byte[]>> comparatorClass;
        private final Comparator<byte[]> comparator;

        ComparatorReader(byte[] comparatorBytes, String type, ClassLoader loader) {
            if (comparatorBytes.length == 0) {
                this.comparatorClass = null;
                this.comparator = null;
                this.isClass = false;
                return;
            }
            Object obj = DatabaseImpl.bytesToObject(comparatorBytes, type, loader);
            if (obj instanceof String) {
                String className = (String)obj;
                try {
                    this.comparatorClass = ClassResolver.resolveClass(className, loader);
                }
                catch (ClassNotFoundException ee) {
                    throw EnvironmentFailureException.unexpectedException(ee);
                }
                this.comparator = DatabaseImpl.instantiateComparator(this.comparatorClass, type);
                this.isClass = true;
                return;
            }
            if (obj instanceof Comparator) {
                this.comparatorClass = null;
                this.comparator = (Comparator)obj;
                this.isClass = false;
                return;
            }
            throw EnvironmentFailureException.unexpectedState("Expected class name or Comparator instance, got: " + obj.getClass().getName());
        }

        public boolean isClass() {
            return this.isClass;
        }

        Class<? extends Comparator<byte[]>> getComparatorClass() {
            return this.comparatorClass;
        }

        public Comparator<byte[]> getComparator() {
            return this.comparator;
        }
    }

    private static class DOSCountCallback
    implements DiskOrderedScanner.RecordProcessor {
        public long count = 0L;

        private DOSCountCallback() {
        }

        @Override
        public void process(int dbIdx, byte[] key, byte[] data, int expiration, boolean expirationInHours) {
            assert (key == null);
            assert (data == null);
            ++this.count;
        }

        @Override
        public boolean canProcessWithoutBlocking(int nRecords) {
            return true;
        }

        @Override
        public int getCapacity() {
            return Integer.MAX_VALUE;
        }

        @Override
        public void checkShutdown() {
        }
    }
}

