/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.log.FileHeader;
import com.sleepycat.je.log.FileManager;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogManager;
import com.sleepycat.je.log.entry.FileHeaderEntry;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.log.entry.SingleItemEntry;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Properties;

public class RestoreMarker {
    private final LogManager logManager;
    private final File lastFile;

    public RestoreMarker(FileManager fileManager, LogManager logManager) {
        this.logManager = logManager;
        String lastFileName = fileManager.getFullFileName(Integer.MAX_VALUE);
        this.lastFile = new File(lastFileName);
    }

    public static String getMarkerFileName() {
        return FileManager.getFileName(Integer.MAX_VALUE);
    }

    public void removeMarkerFile(FileManager fileManager) throws IOException {
        if (this.lastFile.exists()) {
            fileManager.deleteFile(Integer.MAX_VALUE);
        }
    }

    public void createMarkerFile(RestoreRequired.FailureType failureType, Properties props) throws FileCreationException {
        if (this.lastFile.exists() && this.lastFile.length() > 0L) {
            return;
        }
        try {
            this.lastFile.createNewFile();
            FileHeader header = new FileHeader(Integer.MAX_VALUE, 0L);
            FileHeaderEntry headerLogEntry = new FileHeaderEntry(LogEntryType.LOG_FILE_HEADER, header);
            ByteBuffer buf1 = this.logManager.putIntoBuffer(headerLogEntry, 0L);
            RestoreRequired rr = new RestoreRequired(failureType, props);
            SingleItemEntry<RestoreRequired> marker = SingleItemEntry.create(LogEntryType.LOG_RESTORE_REQUIRED, rr);
            ByteBuffer buf2 = this.logManager.putIntoBuffer(marker, 0L);
            try (FileOutputStream stream = new FileOutputStream(this.lastFile);
                 FileChannel channel = stream.getChannel();){
                channel.write(buf1);
                channel.write(buf2);
            }
        }
        catch (IOException ioe) {
            throw new FileCreationException("Marker file creation failed for: " + failureType + " " + ioe.toString(), ioe);
        }
    }

    public static class FileCreationException
    extends Exception {
        FileCreationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

