/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DumpFileReader;
import com.sleepycat.je.utilint.VLSN;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;

public class VLSNDistributionReader
extends DumpFileReader {
    private final Map<Long, PerFileInfo> countByFile = new HashMap<Long, PerFileInfo>();
    private PerFileInfo info;
    private final Long[] allFileNums = this.fileManager.getAllFileNumbers();
    private int fileNumIndex = 0;

    public VLSNDistributionReader(EnvironmentImpl envImpl, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, boolean verbose, boolean forwards) throws DatabaseException {
        super(envImpl, readBufferSize, startLsn, finishLsn, endOfFileLsn, null, null, null, verbose, true, forwards);
    }

    @Override
    protected boolean processEntry(ByteBuffer entryBuffer) {
        VLSN currentVLSN = this.currentEntryHeader.getVLSN();
        long currentFile = this.window.currentFileNum();
        if (this.info == null) {
            this.info = new PerFileInfo(currentFile);
            this.countByFile.put(currentFile, this.info);
        } else if (!this.info.isFileSame(currentFile)) {
            this.info.display();
            this.info = new PerFileInfo(currentFile);
            this.countByFile.put(currentFile, this.info);
        }
        this.info.increment(currentVLSN);
        int nextEntryPosition = entryBuffer.position() + this.currentEntryHeader.getItemSize();
        entryBuffer.position(nextEntryPosition);
        return true;
    }

    @Override
    public void summarize(boolean csvFormat) {
        if (this.info != null) {
            this.info.display();
        }
        System.err.println("... " + (this.allFileNums.length - this.fileNumIndex) + " files at end");
        System.err.println("First file: 0x" + Long.toHexString(this.fileManager.getFirstFileNum()));
        System.err.println("Last file: 0x" + Long.toHexString(this.fileManager.getLastFileNum()));
    }

    private class PerFileInfo {
        private final long fileNum;
        private VLSN firstVLSNInFile;
        private VLSN lastVLSNInFile;
        private int count;

        PerFileInfo(long fileNum) {
            this.fileNum = fileNum;
        }

        public boolean isFileSame(long currentFile) {
            return this.fileNum == currentFile;
        }

        void increment(VLSN currentVLSN) {
            ++this.count;
            if (this.firstVLSNInFile == null) {
                this.firstVLSNInFile = currentVLSN;
            }
            this.lastVLSNInFile = currentVLSN;
        }

        public String toString() {
            return "file 0x" + Long.toHexString(this.fileNum) + " numRepRecords = " + this.count + " firstVLSN = " + this.firstVLSNInFile + " lastVLSN = " + this.lastVLSNInFile;
        }

        void display() {
            long whichFile;
            int inbetweenCount = 0;
            while (VLSNDistributionReader.this.fileNumIndex < VLSNDistributionReader.this.allFileNums.length && (whichFile = VLSNDistributionReader.this.allFileNums[VLSNDistributionReader.this.fileNumIndex].longValue()) <= this.fileNum) {
                ++VLSNDistributionReader.this.fileNumIndex;
                ++inbetweenCount;
            }
            if (inbetweenCount > 1) {
                System.err.println("... " + (inbetweenCount - 1) + " files");
            }
            System.err.println(this);
        }
    }
}

