/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.ReplicatedEnvironment;

public class NodeState {
    private final String nodeName;
    private final String groupName;
    private final ReplicatedEnvironment.State currentState;
    private final String masterName;
    private final JEVersion jeVersion;
    private final long joinTime;
    private final long currentTxnEndVLSN;
    private final long masterTxnEndVLSN;
    private final int activeFeeders;
    private final int logVersion;
    private final byte[] appState;
    private final double systemLoad;

    public NodeState(String nodeName, String groupName, ReplicatedEnvironment.State currentState, String masterName, JEVersion jeVersion, long joinTime, long currentTxnEndVLSN, long masterTxnEndVLSN, int activeFeeders, int logVersion, byte[] appState, double systemLoad) {
        this.nodeName = nodeName;
        this.groupName = groupName;
        this.currentState = currentState;
        this.masterName = masterName;
        this.jeVersion = jeVersion;
        this.joinTime = joinTime;
        this.currentTxnEndVLSN = currentTxnEndVLSN;
        this.masterTxnEndVLSN = masterTxnEndVLSN;
        this.activeFeeders = activeFeeders;
        this.logVersion = logVersion;
        this.appState = appState;
        this.systemLoad = systemLoad;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ReplicatedEnvironment.State getNodeState() {
        return this.currentState;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public JEVersion getJEVersion() {
        return this.jeVersion;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public long getCurrentTxnEndVLSN() {
        return this.currentTxnEndVLSN;
    }

    public long getKnownMasterTxnEndVLSN() {
        return this.masterTxnEndVLSN;
    }

    public int getActiveFeeders() {
        return this.activeFeeders;
    }

    public int getLogVersion() {
        return this.logVersion;
    }

    public byte[] getAppState() {
        return this.appState;
    }

    public double getSystemLoad() {
        return this.systemLoad;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Current state of node: " + this.nodeName + " from group: " + this.groupName + "\n");
        sb.append("  Current state: " + this.currentState + "\n");
        sb.append("  Current master: " + this.masterName + "\n");
        sb.append("  Current JE version: " + this.jeVersion + "\n");
        sb.append("  Current log version: " + this.logVersion + "\n");
        sb.append("  Current transaction end (abort or commit) VLSN: " + this.currentTxnEndVLSN + "\n");
        sb.append("  Current master transaction end (abort or commit) VLSN: " + this.masterTxnEndVLSN + "\n");
        sb.append("  Current active feeders on node: " + this.activeFeeders + "\n");
        sb.append("  Current system load average: " + this.systemLoad + "\n");
        return sb.toString();
    }
}

