/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import java.io.Serializable;

public class StateChangeEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReplicatedEnvironment.State state;
    private final NameIdPair masterNameId;
    private final long eventTime = System.currentTimeMillis();

    public StateChangeEvent(ReplicatedEnvironment.State state, NameIdPair masterNameId) {
        assert (masterNameId.getId() == -1 || state == ReplicatedEnvironment.State.MASTER || state == ReplicatedEnvironment.State.REPLICA) : "state=" + state + " masterId=" + masterNameId.getId();
        this.state = state;
        this.masterNameId = masterNameId;
    }

    public ReplicatedEnvironment.State getState() {
        return this.state;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public String getMasterNodeName() throws IllegalStateException {
        if (this.state == ReplicatedEnvironment.State.MASTER || this.state == ReplicatedEnvironment.State.REPLICA) {
            return this.masterNameId.getName();
        }
        throw new IllegalStateException("No current master in state: " + this.state);
    }
}

