/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.OperationFailureException;
import com.sleepycat.je.rep.StateChangeEvent;
import com.sleepycat.je.txn.Locker;
import java.util.Date;

public abstract class StateChangeException
extends OperationFailureException {
    private static final long serialVersionUID = 1L;
    private final StateChangeEvent stateChangeEvent;

    protected StateChangeException(Locker locker, StateChangeEvent stateChangeEvent) {
        super(locker, locker != null, StateChangeException.makeMessage(locker, stateChangeEvent), null);
        this.stateChangeEvent = stateChangeEvent;
    }

    protected StateChangeException(String message, Exception reason) {
        super(null, false, message, reason);
        this.stateChangeEvent = null;
    }

    public StateChangeEvent getEvent() {
        return this.stateChangeEvent;
    }

    private static String makeMessage(Locker locker, StateChangeEvent event) {
        long lockerId = locker == null ? 0L : locker.getId();
        return event != null ? "Problem closing transaction " + lockerId + ". The current state is:" + event.getState() + ". The node transitioned to this state at:" + new Date(event.getEventTime()) : "Node state inconsistent with operation";
    }

    protected StateChangeException(String message, StateChangeException cause) {
        super(message, cause);
        this.stateChangeEvent = cause != null ? cause.stateChangeEvent : null;
    }
}

