/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.InsufficientAcksException;
import com.sleepycat.je.rep.InsufficientReplicasException;
import com.sleepycat.je.rep.NoConsistencyRequiredPolicy;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.MinJEVersionUnsupportedException;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.node.Feeder;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.cbvlsn.CleanerBarrierState;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.txn.MasterTxn;
import com.sleepycat.je.rep.txn.ReadonlyTxn;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.util.HashMap;
import java.util.UUID;
import java.util.logging.Logger;

public class RepGroupDB {
    private final RepImpl repImpl;
    public final RepGroupImpl emptyGroup;
    private final Logger logger;
    public static final String GROUP_KEY = "$$GROUP_KEY$$";
    public static final DatabaseEntry groupKeyEntry = new DatabaseEntry();
    private static final HashMap<String, Object> lockMap;
    public static final long DB_ID = -257L;
    private static final int QUORUM_ACK_RETRIES = 5;
    private static final Durability QUORUM_ACK_DURABILITY;
    private static final TransactionConfig QUORUM_ACK;
    private static final TransactionConfig NO_ACK;
    static final TransactionConfig READ_ONLY;
    private static final Durability NO_ACK_DURABILITY;
    private static final Durability NO_ACK_NO_SYNC_DURABILITY;

    public RepGroupDB(RepImpl repImpl) throws DatabaseException {
        this.repImpl = repImpl;
        DbConfigManager configManager = repImpl.getConfigManager();
        this.emptyGroup = new RepGroupImpl(configManager.get(RepParams.GROUP_NAME), repImpl.getCurrentJEVersion());
        this.logger = LoggerUtils.getLogger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepGroupImpl getGroup(RepImpl rImpl, String groupName) throws DatabaseException {
        RepGroupImpl group;
        DatabaseImpl dbImpl = null;
        boolean foundDbImpl = false;
        try {
            dbImpl = rImpl.getGroupDb();
            foundDbImpl = true;
        }
        catch (DatabaseNotFoundException databaseNotFoundException) {
            // empty catch block
        }
        if (!foundDbImpl) {
            group = new RepGroupImpl(groupName, true, rImpl.getCurrentJEVersion());
        } else {
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setDurability(READ_ONLY.getDurability());
            txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
            txnConfig.setReadUncommitted(true);
            ReadonlyTxn txn = null;
            try {
                txn = new ReadonlyTxn(rImpl, txnConfig);
                group = RepGroupDB.fetchGroup(groupName, dbImpl, txn);
                group.makeConsistent();
                txn.commit();
                txn = null;
            }
            finally {
                if (txn != null) {
                    txn.abort();
                }
            }
        }
        RepNode repNode = rImpl.getRepNode();
        if (repNode != null) {
            for (Feeder feeder : repNode.feederManager().activeReplicasMap().values()) {
                RepNodeImpl node = feeder.getReplicaNode();
                if (node == null || !node.getType().hasTransientId()) continue;
                group.addTransientIdNode(node);
            }
        }
        return group;
    }

    public RepGroupImpl getGroup() throws DatabaseException {
        return RepGroupDB.getGroup(this.repImpl, this.repImpl.getConfigManager().get(RepParams.GROUP_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMinJEVersion(JEVersion newMinJEVersion) throws DatabaseException, MinJEVersionUnsupportedException {
        DatabaseImpl groupDbImpl;
        try {
            groupDbImpl = this.repImpl.getGroupDb();
        }
        catch (DatabaseNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        MasterTxn txn = new MasterTxn((EnvironmentImpl)this.repImpl, QUORUM_ACK, this.repImpl.getNameIdPair());
        try {
            RepGroupImpl repGroup = this.fetchGroupObject(txn, groupDbImpl, LockMode.RMW);
            repGroup = RepGroupDB.fetchGroup(repGroup.getName(), groupDbImpl, txn);
            repGroup.setMinJEVersion(newMinJEVersion);
            this.saveGroupObject(txn, repGroup, groupDbImpl);
            txn.commit(QUORUM_ACK_DURABILITY);
            txn = null;
            LoggerUtils.info(this.logger, this.repImpl, "Updated minimum JE group version to " + newMinJEVersion);
        }
        catch (InsufficientAcksException e) {
            LoggerUtils.info(this.logger, this.repImpl, "Proceeding without enough acks, did not update minimum JE group version to " + newMinJEVersion);
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
        }
        this.repImpl.getRepNode().refreshCachedGroup();
    }

    private static Cursor makeCursor(DatabaseImpl dbImpl, Txn txn, CursorConfig cursorConfig) {
        Cursor cursor = DbInternal.makeCursor(dbImpl, (Locker)txn, cursorConfig);
        DbInternal.getCursorImpl(cursor).setAllowEviction(false);
        return cursor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RepGroupImpl fetchGroup(String groupName, DatabaseImpl dbImpl, Txn txn) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        TupleBinding nodeBinding = null;
        GroupBinding groupBinding = new GroupBinding();
        RepGroupImpl group = null;
        HashMap<Integer, RepNodeImpl> nodes = new HashMap<Integer, RepNodeImpl>();
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadCommitted(true);
        try (Cursor mcursor = null;){
            mcursor = RepGroupDB.makeCursor(dbImpl, txn, cursorConfig);
            while (mcursor.getNext(keyEntry, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                String key = StringBinding.entryToString(keyEntry);
                if (GROUP_KEY.equals(key)) {
                    group = (RepGroupImpl)groupBinding.entryToObject(value);
                    if (!group.getName().equals(groupName)) {
                        throw EnvironmentFailureException.unexpectedState("The argument: " + groupName + " does not match the expected group name: " + group.getName());
                    }
                    nodeBinding = new NodeBinding(group.getFormatVersion());
                    continue;
                }
                if (nodeBinding == null) {
                    throw new IllegalStateException("Found node binding before group binding");
                }
                RepNodeImpl node = (RepNodeImpl)nodeBinding.entryToObject(value);
                nodes.put(node.getNameIdPair().getId(), node);
            }
            if (group == null) {
                throw EnvironmentFailureException.unexpectedState("Group key: $$GROUP_KEY$$ is missing");
            }
            group.setNodes(nodes);
            RepGroupImpl repGroupImpl = group;
            return repGroupImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFirstNode() throws DatabaseException {
        DbConfigManager configManager = this.repImpl.getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        String nodeName = configManager.get(RepParams.NODE_NAME);
        DatabaseImpl groupDbImpl = this.repImpl.createGroupDb();
        RepGroupImpl repGroup = new RepGroupImpl(groupName, this.repImpl.getCurrentJEVersion());
        GroupBinding groupBinding = new GroupBinding(repGroup.getFormatVersion());
        DatabaseEntry groupEntry = new DatabaseEntry();
        groupBinding.objectToEntry(repGroup, groupEntry);
        TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setDurability(NO_ACK.getDurability());
        txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        Txn txn = null;
        Cursor cursor = null;
        try {
            txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, this.repImpl.getNameIdPair());
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.put(groupKeyEntry, groupEntry);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Couldn't write first group entry " + status);
            }
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
        this.ensureMember(new RepNodeImpl(nodeName, this.repImpl.getHostName(), this.repImpl.getPort(), this.repImpl.getCurrentJEVersion()));
    }

    public void ensureMember(Protocol.NodeGroupInfo membershipInfo) throws DatabaseException {
        this.ensureMember(new RepNodeImpl(membershipInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void ensureMember(RepNodeImpl ensureNode) throws DatabaseException {
        DatabaseImpl groupDbImpl;
        if (ensureNode.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call ensureMember on " + ensureNode.getType() + " node: " + ensureNode);
        }
        try {
            groupDbImpl = this.repImpl.getGroupDb();
        }
        catch (DatabaseNotFoundException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        DatabaseEntry nodeNameKey = new DatabaseEntry();
        StringBinding.stringToEntry(ensureNode.getName(), nodeNameKey);
        DatabaseEntry value = new DatabaseEntry();
        NodeBinding mib = null;
        ReadonlyTxn txn = null;
        Cursor cursor = null;
        try {
            txn = new ReadonlyTxn(this.repImpl, NO_ACK);
            RepGroupImpl repGroup = this.fetchGroupObject(txn, groupDbImpl, LockMode.DEFAULT);
            mib = new NodeBinding(repGroup.getFormatVersion());
            CursorConfig config = new CursorConfig();
            config.setReadCommitted(true);
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, config);
            OperationStatus status = cursor.getSearchKey(nodeNameKey, value, null);
            if (status == OperationStatus.SUCCESS) {
                RepNodeImpl miInDb = (RepNodeImpl)mib.entryToObject(value);
                if (miInDb.equivalent(ensureNode)) {
                    if (miInDb.isQuorumAck()) {
                        return;
                    }
                } else {
                    LoggerUtils.warning(this.logger, this.repImpl, "Incompatible node descriptions. Membership database definition: " + miInDb.toString() + " Transient definition: " + ensureNode.toString());
                    if (ensureNode.getType() != miInDb.getType()) {
                        throw EnvironmentFailureException.unexpectedState("Conflicting node types for node " + ensureNode.getName() + ": expected " + ensureNode.getType() + ", found " + miInDb.getType());
                    }
                    throw EnvironmentFailureException.unexpectedState("Incompatible node descriptions for node: " + ensureNode.getName() + ", node ID: " + ensureNode.getNodeId());
                }
                ensureNode.getNameIdPair().update(miInDb.getNameIdPair());
                LoggerUtils.info(this.logger, this.repImpl, "Present but not ack'd node: " + ensureNode.getNodeId() + " ack status: " + miInDb.isQuorumAck());
            }
            cursor.close();
            cursor = null;
            txn.commit();
            txn = null;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                txn.abort();
            }
        }
        this.createMember(ensureNode);
        this.refreshGroupAndNotifyGroupChange(ensureNode.getName(), GroupChangeEvent.GroupChangeType.ADD);
    }

    private void refreshGroupAndNotifyGroupChange(String nodeName, GroupChangeEvent.GroupChangeType opType) {
        this.repImpl.getRepNode().refreshCachedGroup();
        this.repImpl.getRepNode().getMonitorEventManager().notifyGroupChange(nodeName, opType);
    }

    public void removeMember(final RepNodeImpl removeNode, final boolean delete) {
        LoggerUtils.info(this.logger, this.repImpl, (delete ? "Deleting node: " : "Removing node: ") + removeNode.getName());
        if (removeNode.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call removeMember on a node with type " + removeNode.getType() + ": " + removeNode);
        }
        TwoPhaseUpdate twoPhaseUpdate = new TwoPhaseUpdate(removeNode, true){

            @Override
            void phase1Body() {
                RepGroupImpl repGroup = RepGroupDB.this.fetchGroupObject(this.txn, this.groupDbImpl, LockMode.RMW);
                int changeVersion = repGroup.incrementChangeVersion();
                RepGroupDB.this.saveGroupObject(this.txn, repGroup, this.groupDbImpl);
                this.node.setChangeVersion(changeVersion);
                this.node.setRemoved(true);
                RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl, repGroup);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void phase2Body() {
                if (!delete) {
                    super.phase2Body();
                    return;
                }
                DatabaseEntry nodeNameKey = new DatabaseEntry();
                StringBinding.stringToEntry(removeNode.getName(), nodeNameKey);
                try (Cursor cursor = RepGroupDB.makeCursor(this.groupDbImpl, this.txn, CursorConfig.DEFAULT);){
                    OperationStatus status = cursor.getSearchKey(nodeNameKey, new DatabaseEntry(), LockMode.RMW);
                    if (status != OperationStatus.SUCCESS) {
                        throw EnvironmentFailureException.unexpectedState("Node ID: " + removeNode.getNameIdPair() + " not present in group db");
                    }
                    cursor.delete();
                }
            }
        };
        twoPhaseUpdate.execute();
        this.refreshGroupAndNotifyGroupChange(removeNode.getName(), GroupChangeEvent.GroupChangeType.REMOVE);
        LoggerUtils.info(this.logger, this.repImpl, "Successfully deleted node: " + removeNode.getName());
    }

    private void createMember(RepNodeImpl node) throws InsufficientReplicasException, InsufficientAcksException, DatabaseException {
        LoggerUtils.fine(this.logger, this.repImpl, "Adding node: " + node.getNameIdPair());
        this.twoPhaseMemberUpdate(node, true);
        LoggerUtils.info(this.logger, this.repImpl, "Successfully added node:" + node.getNameIdPair() + " HostPort = " + node.getHostName() + ": " + node.getPort() + " [" + node.getType() + "]");
    }

    public void updateMember(RepNodeImpl node, boolean quorumAck) throws DatabaseException {
        if (node.getType().hasTransientId()) {
            throw new IllegalArgumentException("Attempt to call updateMember on a node of type " + node.getType() + ": " + node);
        }
        LoggerUtils.fine(this.logger, this.repImpl, "Updating node: " + node);
        this.twoPhaseMemberUpdate(node, quorumAck);
        this.repImpl.getRepNode().refreshCachedGroup();
        LoggerUtils.info(this.logger, this.repImpl, "Successfully updated node: " + node.getNameIdPair() + " Hostport = " + node.getHostName() + ": " + node.getPort() + " [" + node.getType() + "]");
    }

    private void twoPhaseMemberUpdate(RepNodeImpl node, boolean quorumAck) throws DatabaseException {
        TwoPhaseUpdate twoPhaseUpdate = new TwoPhaseUpdate(node, quorumAck){
            int saveOrigId;
            {
                this.saveOrigId = this.node.getNameIdPair().getId();
            }

            @Override
            void phase1Body() {
                RepGroupImpl repGroup = RepGroupDB.this.fetchGroupObject(this.txn, this.groupDbImpl, LockMode.RMW);
                repGroup = RepGroupDB.fetchGroup(repGroup.getName(), this.groupDbImpl, this.txn);
                int changeVersion = repGroup.incrementChangeVersion();
                if (this.node.getNameIdPair().hasNullId()) {
                    this.node.getNameIdPair().setId(repGroup.getNextNodeId());
                }
                repGroup.checkForConflicts(this.node);
                RepGroupDB.this.saveGroupObject(this.txn, repGroup, this.groupDbImpl);
                this.node.setChangeVersion(changeVersion);
                RepNodeImpl existingNode = repGroup.getNode(this.node.getName());
                if (existingNode != null && this.node.getJEVersion() == null) {
                    this.node.updateJEVersion(existingNode.getJEVersion());
                }
                RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl, repGroup);
            }

            @Override
            void deadlockHandler() {
                this.node.getNameIdPair().setId(this.saveOrigId, false);
            }

            @Override
            void insufficientReplicasHandler() {
                this.node.getNameIdPair().setId(this.saveOrigId, false);
            }
        };
        twoPhaseUpdate.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateLocalCBVLSN(NameIdPair nameIdPair, VLSN newCBVLSN, NodeType nodeType) throws DatabaseException {
        DatabaseImpl groupDbImpl = null;
        try {
            groupDbImpl = this.repImpl.probeGroupDb();
        }
        catch (DatabaseException e) {
            return false;
        }
        if (groupDbImpl == null) {
            return false;
        }
        DatabaseEntry nodeNameKey = new DatabaseEntry();
        StringBinding.stringToEntry(nameIdPair.getName(), nodeNameKey);
        DatabaseEntry value = new DatabaseEntry();
        CleanerBarrierState barrierState = new CleanerBarrierState(newCBVLSN, System.currentTimeMillis());
        Txn txn = null;
        Cursor cursor = null;
        boolean ok = false;
        try {
            if (nodeType.isSecondary() || nodeType.isArbiter() || nodeType.isExternal()) {
                ok = true;
                boolean bl = true;
                return bl;
            }
            TransactionConfig txnConfig = new TransactionConfig();
            txnConfig.setDurability(NO_ACK_NO_SYNC_DURABILITY);
            txnConfig.setNoWait(true);
            txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, this.repImpl.getNameIdPair());
            RepGroupImpl repGroup = this.fetchGroupObject(txn, groupDbImpl, LockMode.DEFAULT);
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.getSearchKey(nodeNameKey, value, LockMode.RMW);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Node ID: " + nameIdPair + " not present in group db");
            }
            NodeBinding nodeBinding = new NodeBinding(repGroup.getFormatVersion());
            RepNodeImpl node = (RepNodeImpl)nodeBinding.entryToObject(value);
            VLSN lastCBVLSN = node.getBarrierState().getLastCBVLSN();
            if (lastCBVLSN.equals(newCBVLSN)) {
                ok = true;
                boolean bl = true;
                return bl;
            }
            node.setBarrierState(barrierState);
            nodeBinding.objectToEntry(node, value);
            status = cursor.putCurrent(value);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Node ID: " + nameIdPair + " stored localCBVLSN could not be updated. Status: " + status);
            }
            LoggerUtils.fine(this.logger, this.repImpl, "Local CBVLSN updated to " + newCBVLSN + " for node " + nameIdPair);
            ok = true;
        }
        finally {
            RepNode repNode;
            if (cursor != null) {
                cursor.close();
            }
            if (txn != null) {
                if (ok) {
                    txn.commit(NO_ACK_NO_SYNC_DURABILITY);
                } else {
                    txn.abort();
                }
                txn = null;
            }
            if (ok && (repNode = this.repImpl.getRepNode()) != null) {
                repNode.updateGroupInfo(nameIdPair, barrierState);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepGroupImpl fetchGroupObject(Txn txn, DatabaseImpl groupDbImpl, LockMode lockMode) throws DatabaseException {
        GroupBinding groupBinding = new GroupBinding();
        DatabaseEntry groupEntry = new DatabaseEntry();
        try (Cursor cursor = null;){
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.getSearchKey(groupKeyEntry, groupEntry, lockMode);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry key: $$GROUP_KEY$$ missing from group database");
            }
        }
        return (RepGroupImpl)groupBinding.entryToObject(groupEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveGroupObject(Txn txn, RepGroupImpl repGroup, DatabaseImpl groupDbImpl) throws DatabaseException {
        GroupBinding groupBinding = new GroupBinding(repGroup.getFormatVersion());
        DatabaseEntry groupEntry = new DatabaseEntry();
        groupBinding.objectToEntry(repGroup, groupEntry);
        try (Cursor cursor = null;){
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.put(groupKeyEntry, groupEntry);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry save failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveNodeObject(Txn txn, RepNodeImpl node, DatabaseImpl groupDbImpl, RepGroupImpl repGroup) throws DatabaseException {
        assert (!node.getType().hasTransientId());
        DatabaseEntry nodeNameKey = new DatabaseEntry();
        StringBinding.stringToEntry(node.getName(), nodeNameKey);
        NodeBinding nodeBinding = new NodeBinding(repGroup.getFormatVersion());
        DatabaseEntry memberInfoEntry = new DatabaseEntry();
        nodeBinding.objectToEntry(node, memberInfoEntry);
        try (Cursor cursor = null;){
            cursor = RepGroupDB.makeCursor(groupDbImpl, txn, CursorConfig.DEFAULT);
            OperationStatus status = cursor.put(nodeNameKey, memberInfoEntry);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState("Group entry save failed");
            }
        }
    }

    static JEVersion parseJEVersion(String versionString) {
        return versionString.isEmpty() ? null : new JEVersion(versionString);
    }

    static String jeVersionString(JEVersion jeVersion) {
        return jeVersion == null ? "" : jeVersion.getNumericVersionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RepGroupImpl getGroup(File envDir) {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(false);
        Environment env = new Environment(envDir, envConfig);
        Transaction txn = null;
        Database db = null;
        try {
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setReadOnly(true);
            dbConfig.setTransactional(true);
            dbConfig.setAllowCreate(false);
            txn = env.beginTransaction(null, null);
            db = env.openDatabase(txn, DbType.REP_GROUP.getInternalName(), dbConfig);
            DatabaseEntry groupEntry = new DatabaseEntry();
            OperationStatus status = db.get(txn, groupKeyEntry, groupEntry, LockMode.READ_COMMITTED);
            if (status != OperationStatus.SUCCESS) {
                throw new IllegalStateException("Group entry not found " + status);
            }
            GroupBinding groupBinding = new GroupBinding();
            RepGroupImpl group = (RepGroupImpl)groupBinding.entryToObject(groupEntry);
            group = RepGroupDB.fetchGroup(group.getName(), DbInternal.getDbImpl(db), DbInternal.getTxn(txn));
            txn.commit();
            txn = null;
            RepGroupImpl repGroupImpl = group;
            return repGroupImpl;
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
            if (db != null) {
                db.close();
            }
            env.close();
        }
    }

    public void reinitFirstNode(VLSN lastOldVLSN) {
        DbConfigManager configManager = this.repImpl.getConfigManager();
        String groupName = configManager.get(RepParams.GROUP_NAME);
        String nodeName = configManager.get(RepParams.NODE_NAME);
        String hostPortPair = configManager.get(RepParams.NODE_HOST_PORT);
        String hostname = HostPortPair.getHostname(hostPortPair);
        int port = HostPortPair.getPort(hostPortPair);
        boolean retainUUID = configManager.getBoolean(RepParams.RESET_REP_GROUP_RETAIN_UUID);
        DatabaseImpl dbImpl = this.repImpl.getGroupDb();
        TransactionConfig txnConfig = new TransactionConfig();
        txnConfig.setDurability(NO_ACK.getDurability());
        txnConfig.setConsistencyPolicy(NoConsistencyRequiredPolicy.NO_CONSISTENCY);
        NameIdPair nameIdPair = this.repImpl.getRepNode().getNameIdPair();
        nameIdPair.revertToNull();
        MasterTxn txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, nameIdPair);
        RepGroupImpl prevRepGroup = this.fetchGroupObject(txn, dbImpl, LockMode.RMW);
        txn.commit();
        int nodeIdSequenceStart = prevRepGroup.getNodeIdSequence();
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry value = new DatabaseEntry();
        int firstNodeId = nodeIdSequenceStart + 1;
        nameIdPair.setId(firstNodeId);
        RepNodeImpl firstNode = new RepNodeImpl(nodeName, hostname, port, this.repImpl.getCurrentJEVersion());
        CleanerBarrierState barrierState = new CleanerBarrierState(lastOldVLSN, System.currentTimeMillis());
        firstNode.setBarrierState(barrierState);
        txn = new MasterTxn((EnvironmentImpl)this.repImpl, txnConfig, nameIdPair);
        CursorConfig cursorConfig = new CursorConfig();
        cursorConfig.setReadCommitted(true);
        Cursor mcursor = RepGroupDB.makeCursor(dbImpl, txn, cursorConfig);
        while (mcursor.getNext(keyEntry, value, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
            String key = StringBinding.entryToString(keyEntry);
            if (GROUP_KEY.equals(key)) {
                RepGroupImpl repGroup;
                if (retainUUID) {
                    repGroup = (RepGroupImpl)new GroupBinding().entryToObject(value);
                    repGroup.incrementChangeVersion();
                } else {
                    repGroup = new RepGroupImpl(groupName, this.repImpl.getCurrentJEVersion());
                }
                GroupBinding groupBinding = new GroupBinding(repGroup.getFormatVersion());
                repGroup.setNodeIdSequence(nodeIdSequenceStart);
                DatabaseEntry groupEntry = new DatabaseEntry();
                groupBinding.objectToEntry(repGroup, groupEntry);
                OperationStatus status = mcursor.putCurrent(groupEntry);
                if (OperationStatus.SUCCESS.equals((Object)status)) continue;
                throw new IllegalStateException("Unexpected state:" + status);
            }
            LoggerUtils.info(this.logger, this.repImpl, "Removing node: " + key);
            mcursor.delete();
        }
        mcursor.close();
        txn.commit();
        this.ensureMember(firstNode);
        if (firstNodeId != firstNode.getNodeId()) {
            throw new IllegalStateException("Expected nodeid:" + firstNodeId + " but found:" + firstNode.getNodeId());
        }
    }

    static {
        StringBinding.stringToEntry(GROUP_KEY, groupKeyEntry);
        lockMap = new HashMap();
        QUORUM_ACK_DURABILITY = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY);
        QUORUM_ACK = new TransactionConfig();
        READ_ONLY = NO_ACK = new TransactionConfig();
        NO_ACK_DURABILITY = new Durability(Durability.SyncPolicy.SYNC, Durability.SyncPolicy.SYNC, Durability.ReplicaAckPolicy.NONE);
        NO_ACK_NO_SYNC_DURABILITY = new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.NONE);
        QUORUM_ACK.setDurability(QUORUM_ACK_DURABILITY);
        NO_ACK.setDurability(NO_ACK_DURABILITY);
    }

    private abstract class TwoPhaseUpdate {
        final RepNodeImpl node;
        final boolean quorumAck;
        final DatabaseImpl groupDbImpl;
        protected Txn txn;
        private DatabaseException phase1Exception = null;

        TwoPhaseUpdate(RepNodeImpl node, boolean quorumAck) {
            this.node = node;
            this.quorumAck = quorumAck;
            try {
                this.groupDbImpl = RepGroupDB.this.repImpl.getGroupDb();
            }
            catch (DatabaseNotFoundException e) {
                throw EnvironmentFailureException.unexpectedException(e);
            }
        }

        void insufficientReplicasHandler() {
        }

        void deadlockHandler() {
        }

        abstract void phase1Body();

        void phase2Body() {
            this.node.setQuorumAck(true);
            RepGroupImpl repGroup = RepGroupDB.this.fetchGroupObject(this.txn, this.groupDbImpl, LockMode.DEFAULT);
            RepGroupDB.this.saveNodeObject(this.txn, this.node, this.groupDbImpl, repGroup);
        }

        private void phase1() throws DatabaseException {
            for (int i = 0; i < 5; ++i) {
                this.txn = null;
                try {
                    this.txn = new MasterTxn((EnvironmentImpl)RepGroupDB.this.repImpl, this.quorumAck ? QUORUM_ACK : NO_ACK, RepGroupDB.this.repImpl.getNameIdPair());
                    this.phase1Body();
                    this.txn.commit(this.quorumAck ? QUORUM_ACK_DURABILITY : NO_ACK_DURABILITY);
                    this.txn = null;
                    return;
                }
                catch (InsufficientReplicasException e) {
                    this.phase1Exception = e;
                    this.insufficientReplicasHandler();
                    LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " insufficient active replicas: " + e.getMessage());
                    continue;
                }
                catch (InsufficientAcksException e) {
                    this.phase1Exception = e;
                    LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " insufficient acks: " + e.getMessage());
                    continue;
                }
                catch (LockConflictException e) {
                    this.phase1Exception = e;
                    this.deadlockHandler();
                    LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 retry; for node: " + this.node.getName() + " deadlock exception: " + e.getMessage());
                    continue;
                }
                catch (DatabaseException e) {
                    LoggerUtils.severe(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 failed unexpectedly: " + e.getMessage());
                    throw e;
                }
                finally {
                    if (this.txn != null) {
                        this.txn.abort();
                    }
                }
            }
            LoggerUtils.warning(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Phase 1 failed: " + this.phase1Exception.getMessage());
            throw this.phase1Exception;
        }

        private void phase2() {
            try {
                this.txn = new MasterTxn((EnvironmentImpl)RepGroupDB.this.repImpl, NO_ACK, RepGroupDB.this.repImpl.getNameIdPair());
                this.phase2Body();
                this.txn.commit();
                this.txn = null;
            }
            catch (DatabaseException e) {
                LoggerUtils.severe(RepGroupDB.this.logger, RepGroupDB.this.repImpl, "Unexpected failure in Phase 2: " + e.getMessage());
                throw e;
            }
            finally {
                if (this.txn != null) {
                    this.txn.abort();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void execute() {
            Object lock;
            Object object = lockMap;
            synchronized (object) {
                lock = lockMap.get(this.node.getName());
                if (lock == null) {
                    lock = new Object();
                    lockMap.put(this.node.getName(), lock);
                }
            }
            object = lock;
            synchronized (object) {
                this.phase1();
                this.phase2();
            }
        }
    }

    public static class NodeBinding
    extends TupleBinding<RepNodeImpl> {
        static final int APPROX_MAX_SIZE = 122;
        private static final int V2_MAX_NODE_TYPE = 1;
        private final int groupFormatVersion;

        public NodeBinding(int groupFormatVersion) {
            this.groupFormatVersion = groupFormatVersion;
        }

        @Override
        public RepNodeImpl entryToObject(TupleInput input) {
            boolean v2;
            NameIdPair nameIdPair = NameIdPair.deserialize(input);
            byte versionOrNodeType = input.readByte();
            boolean bl = v2 = versionOrNodeType <= 1;
            if (!v2 && versionOrNodeType > this.groupFormatVersion) {
                throw new IllegalStateException("Node entry version " + versionOrNodeType + " for node " + nameIdPair.getId() + " is illegal because it is newer than group version " + this.groupFormatVersion);
            }
            byte nodeTypeNum = v2 ? versionOrNodeType : input.readByte();
            return new RepNodeImpl(nameIdPair, NodeType.values()[nodeTypeNum], input.readBoolean(), input.readBoolean(), input.readString(), input.readInt(), new CleanerBarrierState(new VLSN(input.readLong()), input.readLong()), input.readInt(), v2 ? null : RepGroupDB.parseJEVersion(input.readString()));
        }

        public static boolean supportsObjectToEntry(RepNodeImpl node, int groupFormatVersion) {
            return groupFormatVersion > 2 || node.getType().compareTo(NodeType.ELECTABLE) <= 0;
        }

        @Override
        public void objectToEntry(RepNodeImpl mi, TupleOutput output) {
            if (!NodeBinding.supportsObjectToEntry(mi, this.groupFormatVersion)) {
                throw new IllegalArgumentException("Node type " + mi.getType() + " is not supported for group version " + this.groupFormatVersion);
            }
            boolean v2 = this.groupFormatVersion <= 2;
            CleanerBarrierState syncState = mi.getBarrierState();
            mi.getNameIdPair().serialize(output);
            if (!v2) {
                output.writeByte(this.groupFormatVersion);
            }
            output.writeByte(mi.getType().ordinal());
            output.writeBoolean(mi.isQuorumAck());
            output.writeBoolean(mi.isRemoved());
            output.writeString(mi.getHostName());
            output.writeInt(mi.getPort());
            output.writeLong(syncState.getLastCBVLSN().getSequence());
            output.writeLong(syncState.getBarrierTime());
            output.writeInt(mi.getChangeVersion());
            if (!v2) {
                output.writeString(RepGroupDB.jeVersionString(mi.getJEVersion()));
            }
        }
    }

    public static class GroupBinding
    extends TupleBinding<RepGroupImpl> {
        private final int writeFormatVersion;

        public GroupBinding() {
            this.writeFormatVersion = -1;
        }

        GroupBinding(int writeFormatVersion) {
            if (writeFormatVersion < 0) {
                throw new IllegalArgumentException("writeFormatVersion must be non-negative: " + writeFormatVersion);
            }
            this.writeFormatVersion = writeFormatVersion;
        }

        @Override
        public RepGroupImpl entryToObject(TupleInput input) {
            if (this.writeFormatVersion >= 0) {
                throw new IllegalStateException("GroupBinding not created for read");
            }
            String name = input.readString();
            UUID uuid = new UUID(input.readLong(), input.readLong());
            int formatVersion = input.readInt();
            return new RepGroupImpl(name, uuid, formatVersion, input.readInt(), input.readInt(), formatVersion < 3 ? RepGroupImpl.MIN_FORMAT_VERSION_JE_VERSION : RepGroupDB.parseJEVersion(input.readString()));
        }

        @Override
        public void objectToEntry(RepGroupImpl group, TupleOutput output) {
            if (this.writeFormatVersion < 0) {
                throw new IllegalStateException("GroupBinding not created for write");
            }
            output.writeString(group.getName());
            output.writeLong(group.getUUID().getMostSignificantBits());
            output.writeLong(group.getUUID().getLeastSignificantBits());
            output.writeInt(this.writeFormatVersion);
            output.writeInt(group.getChangeVersion());
            output.writeInt(group.getNodeIdSequence());
            if (this.writeFormatVersion >= 3) {
                output.writeString(RepGroupDB.jeVersionString(group.getMinJEVersion()));
            }
        }
    }
}

