/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.DurationConfigParam;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.net.DataChannelFactory;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class TextProtocol {
    private final String name;
    private final String VERSION;
    private final String groupName;
    private Set<Integer> memberIds;
    private final NameIdPair nameIdPair;
    protected final String messageNocheckSuffix;
    private int openTimeoutMs = 10000;
    private int readTimeoutMs = 10000;
    public static final String SEPARATOR = "|";
    public static final String SEPARATOR_REGEXP = "\\|";
    public final MessageOp PROTOCOL_ERROR = new MessageOp("PE", ProtocolError.class);
    public final MessageOp OK_RESP = new MessageOp("OK", OK.class);
    public final MessageOp FAIL_RESP = new MessageOp("FAIL", Fail.class);
    private int nonDefaultMessageCount;
    private final Map<String, MessageOp> ops = new HashMap<String, MessageOp>();
    protected final Logger logger;
    protected final Formatter formatter;
    protected final RepImpl repImpl;
    protected final DataChannelFactory channelFactory;
    private static TestHook<String> serDeHook;

    public TextProtocol(String version, String groupName, NameIdPair nameIdPair, RepImpl repImpl, DataChannelFactory channelFactory) {
        this.VERSION = version;
        this.groupName = groupName;
        this.nameIdPair = nameIdPair;
        this.repImpl = repImpl;
        this.channelFactory = channelFactory;
        this.name = this.getClass().getName();
        this.messageNocheckSuffix = groupName + "|-2147483648";
        this.logger = repImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(nameIdPair);
    }

    public static void setSerDeHook(TestHook<String> serDeHook) {
        TextProtocol.serDeHook = serDeHook;
    }

    protected void setTimeouts(RepImpl repImpl, DurationConfigParam openTimeoutConfig, DurationConfigParam readTimeoutConfig) {
        if (repImpl == null) {
            return;
        }
        DbConfigManager configManager = repImpl.getConfigManager();
        this.openTimeoutMs = configManager.getDuration(openTimeoutConfig);
        this.readTimeoutMs = configManager.getDuration(readTimeoutConfig);
    }

    protected void initializeMessageOps(MessageOp[] protocolOps) {
        for (MessageOp op : protocolOps) {
            this.ops.put(op.opId, op);
        }
        this.nonDefaultMessageCount = protocolOps.length;
        this.ops.put(this.PROTOCOL_ERROR.opId, this.PROTOCOL_ERROR);
        this.ops.put(this.OK_RESP.opId, this.OK_RESP);
        this.ops.put(this.FAIL_RESP.opId, this.FAIL_RESP);
    }

    protected MessageOp replaceOp(String op, MessageOp message) {
        return this.ops.put(op, message);
    }

    public Set<String> getOps(Class<? extends Message> messageType) {
        HashSet<String> reqOps = new HashSet<String>();
        for (Map.Entry<String, MessageOp> e : this.ops.entrySet()) {
            if (!messageType.isAssignableFrom(e.getValue().getMessageClass())) continue;
            reqOps.add(e.getKey());
        }
        return reqOps;
    }

    public int getOpenTimeout() {
        return this.openTimeoutMs;
    }

    public int getReadTimeout() {
        return this.readTimeoutMs;
    }

    public NameIdPair getNameIdPair() {
        return this.nameIdPair;
    }

    public int messageCount() {
        return this.nonDefaultMessageCount;
    }

    public void updateNodeIds(Set<Integer> newMemberIds) {
        this.memberIds = newMemberIds;
    }

    public int getMajorVersionNumber(String version) {
        return Double.valueOf(version).intValue();
    }

    public Message parse(String line) throws InvalidMessageException {
        String[] tokens = line.split(SEPARATOR_REGEXP);
        int index = TOKENS.OP_TOKEN.ordinal();
        if (index >= tokens.length) {
            throw new InvalidMessageException(MessageError.BAD_FORMAT, "Missing message op in message: " + line);
        }
        MessageOp op = this.ops.get(tokens[index]);
        if (op == null) {
            throw new InvalidMessageException(MessageError.BAD_FORMAT, "Text Protocol unknown op:" + tokens[index] + " in message: " + line);
        }
        try {
            Class<? extends Message> c = op.getMessageClass();
            Constructor<? extends Message> cons = c.getConstructor(c.getEnclosingClass(), line.getClass(), tokens.getClass());
            Message message = cons.newInstance(this, line, tokens);
            return message;
        }
        catch (InstantiationException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (IllegalAccessException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (SecurityException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (NoSuchMethodException e) {
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof RuntimeException) {
                String message = "message: " + line + " exception:" + target.getClass().getName() + " exception message:" + target.getMessage();
                throw new InvalidMessageException(MessageError.BAD_FORMAT, message);
            }
            if (target instanceof InvalidMessageException) {
                throw (InvalidMessageException)target;
            }
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    ResponseMessage parseResponse(String responseLine) throws InvalidMessageException {
        return (ResponseMessage)this.parse(responseLine);
    }

    public RequestMessage parseRequest(String requestLine) throws InvalidMessageException {
        return (RequestMessage)this.parse(requestLine);
    }

    public RequestMessage getRequestMessage(DataChannel channel) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(Channels.newInputStream(channel)));
        String requestLine = in.readLine();
        if (requestLine == null) {
            return null;
        }
        try {
            return this.parseRequest(requestLine);
        }
        catch (InvalidMessageException e) {
            this.processIME(channel, e);
            return null;
        }
    }

    public void processIME(DataChannel channel, InvalidMessageException ime) {
        LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.WARNING, this.name + " format error:" + LoggerUtils.exceptionTypeAndMsg(ime));
        PrintWriter out = new PrintWriter(Channels.newOutputStream(channel), true);
        out.println(new ProtocolError(ime).wireFormat());
        out.close();
    }

    public ResponseMessage process(Object requestProcessor, RequestMessage requestMessage) {
        Class<?> cl = requestProcessor.getClass();
        try {
            Method method = cl.getMethod("process", requestMessage.getClass());
            return (ResponseMessage)method.invoke(requestProcessor, requestMessage);
        }
        catch (NoSuchMethodException e) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.SEVERE, this.name + " Method: process(" + requestMessage.getClass().getName() + ") was missing");
            throw EnvironmentFailureException.unexpectedException(e);
        }
        catch (Exception e) {
            LoggerUtils.logMsg(this.logger, (EnvironmentImpl)this.repImpl, this.formatter, Level.SEVERE, this.name + " Unexpected exception: " + LoggerUtils.exceptionTypeAndMsg(e));
            throw EnvironmentFailureException.unexpectedException(e);
        }
    }

    public static class InvalidMessageException
    extends Exception {
        private final MessageError errorType;

        public InvalidMessageException(MessageError errorType, String message) {
            super(message);
            this.errorType = errorType;
        }

        public MessageError getErrorType() {
            return this.errorType;
        }
    }

    public static enum MessageError {
        BAD_FORMAT,
        VERSION_MISMATCH,
        GROUP_MISMATCH,
        NOT_A_MEMBER;

    }

    protected static class StringFormatable
    implements WireFormatable {
        protected String s;

        StringFormatable() {
        }

        protected StringFormatable(String s) {
            this.s = s;
        }

        public void init(String wireFormat) {
            this.s = wireFormat;
        }

        @Override
        public String wireFormat() {
            return this.s;
        }

        public int hashCode() {
            return this.s == null ? 0 : this.s.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof StringFormatable)) {
                return false;
            }
            StringFormatable other = (StringFormatable)obj;
            return !(this.s == null ? other.s != null : !this.s.equals(other.s));
        }
    }

    public class MessageExchange
    implements Runnable {
        public final InetSocketAddress target;
        private final RequestMessage requestMessage;
        private final String serviceName;
        private ResponseMessage responseMessage;
        public Exception exception;

        public MessageExchange(InetSocketAddress target, String serviceName, RequestMessage request) {
            this.target = target;
            this.serviceName = serviceName;
            this.requestMessage = request;
        }

        @Override
        public void run() {
            ProtocolError error;
            this.messageExchange();
            if (this.responseMessage != null && this.responseMessage.getOp() == TextProtocol.this.PROTOCOL_ERROR && (error = (ProtocolError)this.responseMessage).getErrorType() == MessageError.VERSION_MISMATCH) {
                this.requestMessage.setSendVersion(error.getSendVersion());
                this.messageExchange();
                LoggerUtils.logMsg(TextProtocol.this.logger, (EnvironmentImpl)TextProtocol.this.repImpl, TextProtocol.this.formatter, Level.INFO, TextProtocol.this.name + " Resend message: " + this.requestMessage.toString() + " in version: " + this.requestMessage.getSendVersion() + " while protocol version is: " + TextProtocol.this.VERSION + " because of the version mismatch, the returned response message is: " + this.responseMessage);
            }
        }

        /*
         * Exception decompiling
         */
        public void messageExchange() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setResponseMessage(ResponseMessage responseMessage) {
            this.responseMessage = responseMessage;
        }

        public ResponseMessage getResponseMessage() {
            return this.responseMessage;
        }

        public RequestMessage getRequestMessage() {
            return this.requestMessage;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    public abstract class RequestMessage
    extends Message {
        protected RequestMessage() {
        }

        protected RequestMessage(String line, String[] tokens) throws InvalidMessageException {
            super(line, tokens);
        }

        protected String wireFormatPrefix() {
            return this.getMessagePrefix() + TextProtocol.SEPARATOR + this.getOp().opId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof RequestMessage)) {
                return false;
            }
            return this.getOp().equals(((RequestMessage)obj).getOp());
        }

        public int hashCode() {
            return this.getOp().getOpId().hashCode();
        }
    }

    public class Fail
    extends ResponseMessage {
        private final String message;

        public Fail(String message) {
            this.message = this.sanitize(message);
        }

        public Fail(RequestMessage request, String message) {
            super(request);
            this.message = this.sanitize(message);
        }

        public Fail(String line, String[] tokens) throws InvalidMessageException {
            super(line, tokens);
            this.message = this.nextPayloadToken();
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof Fail)) {
                return false;
            }
            Fail other = (Fail)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        @Override
        public MessageOp getOp() {
            return TextProtocol.this.FAIL_RESP;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + TextProtocol.SEPARATOR + this.message;
        }

        private TextProtocol getOuterType() {
            return TextProtocol.this;
        }

        private String sanitize(String msg) {
            return msg.replace("\n", "  ");
        }
    }

    public class OK
    extends ResponseMessage {
        public OK(RequestMessage request) {
            super(request);
        }

        public OK(String line, String[] tokens) throws InvalidMessageException {
            super(line, tokens);
        }

        @Override
        public MessageOp getOp() {
            return TextProtocol.this.OK_RESP;
        }

        @Override
        protected String getMessagePrefix() {
            return this.messagePrefixNocheck;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix();
        }
    }

    public class ProtocolError
    extends ResponseMessage {
        private final String message;
        private final MessageError errorType;

        public ProtocolError(InvalidMessageException messageException) {
            this(messageException.getErrorType(), messageException.getMessage());
        }

        public ProtocolError(MessageError messageError, String message) {
            this.message = message;
            this.errorType = messageError;
        }

        public ProtocolError(String responseLine, String[] tokens) throws InvalidMessageException {
            super(responseLine, tokens);
            this.errorType = MessageError.valueOf(this.nextPayloadToken());
            this.message = this.nextPayloadToken();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof ProtocolError)) {
                return false;
            }
            ProtocolError other = (ProtocolError)obj;
            return !(this.message == null ? other.message != null : !this.message.equals(other.message));
        }

        @Override
        public MessageOp getOp() {
            return TextProtocol.this.PROTOCOL_ERROR;
        }

        @Override
        public String wireFormat() {
            return this.wireFormatPrefix() + TextProtocol.SEPARATOR + this.errorType.toString() + TextProtocol.SEPARATOR + this.message;
        }

        public MessageError getErrorType() {
            return this.errorType;
        }

        public String getMessage() {
            return this.message;
        }
    }

    public abstract class ResponseMessage
    extends Message {
        protected ResponseMessage() {
        }

        protected ResponseMessage(RequestMessage request) {
            this.setSendVersion(request.getSendVersion());
        }

        protected ResponseMessage(String line, String[] tokens) throws InvalidMessageException {
            super(line, tokens);
        }

        protected String wireFormatPrefix() {
            return this.getMessagePrefix() + TextProtocol.SEPARATOR + this.getOp().opId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ResponseMessage)) {
                return false;
            }
            return this.getOp().equals(((ResponseMessage)obj).getOp());
        }

        public int hashCode() {
            return this.getOp().getOpId().hashCode();
        }
    }

    public abstract class Message
    implements WireFormatable {
        private int senderId = 0;
        protected String sendVersion;
        private final String line;
        private final String[] tokens;
        private int currToken = TOKENS.FIRST_PAYLOAD_TOKEN.ordinal();
        protected String messagePrefixNocheck;

        protected Message() {
            this.line = null;
            this.tokens = null;
            this.setSendVersion(TextProtocol.this.VERSION);
        }

        protected Message(String line, String[] tokens) throws InvalidMessageException {
            this.line = line;
            this.tokens = tokens;
            String version = this.getTokenString(TOKENS.VERSION_TOKEN);
            Double d = new Double(TextProtocol.this.VERSION);
            Double d2 = new Double(version);
            if (d < d2) {
                throw new InvalidMessageException(MessageError.VERSION_MISMATCH, "Version argument mismatch. Expected: " + TextProtocol.this.VERSION + ", found: " + version + ", in message: " + line);
            }
            this.setSendVersion(version);
            String messageGroupName = this.getTokenString(TOKENS.NAME_TOKEN);
            if (!TextProtocol.this.groupName.equals(messageGroupName)) {
                throw new InvalidMessageException(MessageError.GROUP_MISMATCH, "Group name mismatch; this group name: " + TextProtocol.this.groupName + ", message group name: " + messageGroupName + ", in message: " + line);
            }
            this.senderId = new Integer(this.getTokenString(TOKENS.ID_TOKEN));
            if (TextProtocol.this.memberIds != null && TextProtocol.this.memberIds.size() > 0 && TextProtocol.this.nameIdPair.getId() != Integer.MIN_VALUE && this.senderId != Integer.MIN_VALUE && this.senderId != TextProtocol.this.nameIdPair.getId() && !TextProtocol.this.memberIds.contains(this.senderId)) {
                throw new InvalidMessageException(MessageError.NOT_A_MEMBER, "Sender's member id: " + this.senderId + ", message op: " + this.getTokenString(TOKENS.OP_TOKEN) + ", was not a member of the group: " + TextProtocol.this.memberIds + ", in message: " + line);
            }
        }

        public int getSenderId() {
            return this.senderId;
        }

        public void setSendVersion(String version) {
            Double d = new Double(TextProtocol.this.VERSION);
            Double d2 = new Double(version);
            if (d < d2) {
                throw new IllegalStateException("Send version: " + version + " shouldn't be larger than the current version: " + TextProtocol.this.VERSION);
            }
            if (!version.equals(this.sendVersion)) {
                this.sendVersion = version;
                this.messagePrefixNocheck = this.sendVersion + TextProtocol.SEPARATOR + TextProtocol.this.messageNocheckSuffix;
            }
        }

        public String getSendVersion() {
            return this.sendVersion;
        }

        protected String getMessagePrefix() {
            return this.sendVersion + TextProtocol.SEPARATOR + TextProtocol.this.groupName + TextProtocol.SEPARATOR + TextProtocol.this.nameIdPair.getId();
        }

        public abstract MessageOp getOp();

        public TextProtocol getProtocol() {
            return TextProtocol.this;
        }

        private String getTokenString(TOKENS tokenType) {
            int index = tokenType.ordinal();
            if (index >= this.tokens.length) {
                throw EnvironmentFailureException.unexpectedState("Bad format; missing token: " + tokenType + "at position: " + index + "in message: " + this.line);
            }
            return this.tokens[index];
        }

        protected String nextPayloadToken() throws InvalidMessageException {
            if (this.currToken >= this.tokens.length) {
                throw new InvalidMessageException(MessageError.BAD_FORMAT, "Bad format; missing token at position: " + this.currToken + ", in message: " + this.line);
            }
            return this.tokens[this.currToken++];
        }

        protected boolean hasMoreTokens() {
            return this.currToken < this.tokens.length;
        }

        protected int getCurrentTokenPosition() {
            return this.currToken;
        }
    }

    protected static interface WireFormatable {
        public String wireFormat();
    }

    public static enum TOKENS {
        VERSION_TOKEN,
        NAME_TOKEN,
        ID_TOKEN,
        OP_TOKEN,
        FIRST_PAYLOAD_TOKEN;

    }

    public static class MessageOp {
        private final String opId;
        private final Class<? extends Message> messageClass;

        public MessageOp(String opId, Class<? extends Message> messageClass) {
            this.opId = opId;
            this.messageClass = messageClass;
        }

        String getOpId() {
            return this.opId;
        }

        Class<? extends Message> getMessageClass() {
            return this.messageClass;
        }

        public String toString() {
            return this.opId;
        }
    }
}

