/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.monitor.GroupChangeEvent;
import com.sleepycat.je.rep.monitor.LeaveGroupEvent;
import com.sleepycat.je.rep.monitor.Protocol;
import com.sleepycat.je.utilint.LoggerUtils;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MonitorEventManager {
    private long joinTime = 0L;
    private final RepNode repNode;

    public MonitorEventManager(RepNode repNode) {
        this.repNode = repNode;
    }

    public long getJoinTime() {
        return this.joinTime;
    }

    public void disableLeaveGroupEvent() {
        this.joinTime = 0L;
    }

    public void notifyGroupChange(String nodeName, GroupChangeEvent.GroupChangeType opType) throws DatabaseException {
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        Objects.requireNonNull(protocol);
        Protocol.GroupChange changeEvent = protocol.new Protocol.GroupChange(repGroup, nodeName, opType);
        this.refreshMonitors(repGroup, changeEvent);
    }

    public void notifyJoinGroup() throws DatabaseException {
        if (this.joinTime > 0L) {
            return;
        }
        this.joinTime = System.currentTimeMillis();
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        Objects.requireNonNull(protocol);
        Protocol.JoinGroup joinEvent = protocol.new Protocol.JoinGroup(this.repNode.getNodeName(), this.repNode.getMasterName(), this.joinTime);
        this.refreshMonitors(repGroup, joinEvent);
    }

    public void notifyLeaveGroup(LeaveGroupEvent.LeaveReason reason) throws DatabaseException, InterruptedException {
        if (this.joinTime == 0L) {
            return;
        }
        RepGroupImpl repGroup = this.repNode.getGroup();
        Protocol protocol = this.getProtocol(repGroup);
        Objects.requireNonNull(protocol);
        Protocol.LeaveGroup leaveEvent = protocol.new Protocol.LeaveGroup(this.repNode.getNodeName(), this.repNode.getMasterName(), reason, this.joinTime, System.currentTimeMillis());
        Utils.FutureTrackingCompService<TextProtocol.MessageExchange> compService = this.refreshMonitors(repGroup, leaveEvent);
        Utils.checkFutures(compService, 10L, TimeUnit.SECONDS, this.repNode.getLogger(), this.repNode.getRepImpl(), null);
    }

    private Protocol getProtocol(RepGroupImpl repGroup) {
        return new Protocol(repGroup.getName(), NameIdPair.NOCHECK, null, this.repNode.getRepImpl().getChannelFactory());
    }

    private Utils.FutureTrackingCompService<TextProtocol.MessageExchange> refreshMonitors(RepGroupImpl repGroup, TextProtocol.RequestMessage requestMessage) {
        Set<InetSocketAddress> monitors = repGroup.getAllMonitorSockets();
        if (monitors.size() > 0) {
            LoggerUtils.info(this.repNode.getLogger(), this.repNode.getRepImpl(), "Refreshed " + monitors.size() + " monitors.");
        }
        return Utils.broadcastMessage(monitors, "Monitor", requestMessage, this.repNode.getElections().getThreadPool());
    }
}

