/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.monitor;

import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.utilint.HostPortPair;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.Set;

public class MonitorConfig
implements Cloneable {
    public static final MonitorConfig DEFAULT = new MonitorConfig();
    private Properties props = new Properties();
    private final boolean validateParams = true;
    private int numRetries = 5;
    private long retryInterval = 1000L;
    private int socketConnectTimeout = 10000;
    private ReplicationNetworkConfig repNetConfig;

    public MonitorConfig() {
        this.repNetConfig = ReplicationNetworkConfig.createDefault();
    }

    MonitorConfig(ReplicationConfig repConfig) {
        this.repNetConfig = repConfig.getRepNetConfig().clone();
        this.setNodeName(repConfig.getNodeName());
        this.setGroupName(repConfig.getGroupName());
        this.setNodeHostPort(repConfig.getNodeHostPort());
        this.setHelperHosts(repConfig.getHelperHosts());
        if (!repConfig.getNodeType().isMonitor()) {
            throw new IllegalArgumentException("The configured node type was: " + repConfig.getNodeType() + " instead of: " + NodeType.MONITOR);
        }
    }

    public MonitorConfig setGroupName(String groupName) throws IllegalArgumentException {
        this.setGroupNameVoid(groupName);
        return this;
    }

    public void setGroupNameVoid(String groupName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.GROUP_NAME, groupName, true);
    }

    public String getGroupName() {
        return DbConfigManager.getVal(this.props, RepParams.GROUP_NAME);
    }

    public MonitorConfig setNodeName(String nodeName) throws IllegalArgumentException {
        this.setNodeNameVoid(nodeName);
        return this;
    }

    public void setNodeNameVoid(String nodeName) throws IllegalArgumentException {
        DbConfigManager.setVal(this.props, RepParams.NODE_NAME, nodeName, true);
    }

    public String getNodeName() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_NAME);
    }

    public MonitorConfig setNodeHostPort(String hostPort) {
        this.setNodeHostPortVoid(hostPort);
        return this;
    }

    public void setNodeHostPortVoid(String hostPort) {
        DbConfigManager.setVal(this.props, RepParams.NODE_HOST_PORT, hostPort, true);
    }

    public String getNodeHostPort() {
        return DbConfigManager.getVal(this.props, RepParams.NODE_HOST_PORT);
    }

    public MonitorConfig setHelperHosts(String helperHosts) {
        this.setHelperHostsVoid(helperHosts);
        return this;
    }

    public void setHelperHostsVoid(String helperHosts) {
        DbConfigManager.setVal(this.props, RepParams.HELPER_HOSTS, helperHosts, true);
    }

    public String getHelperHosts() {
        return DbConfigManager.getVal(this.props, RepParams.HELPER_HOSTS);
    }

    public Set<InetSocketAddress> getHelperSockets() {
        return HostPortPair.getSockets(this.getHelperHosts());
    }

    public String getNodeHostname() {
        String hostAndPort = this.getNodeHostPort();
        int colonToken = hostAndPort.lastIndexOf(":");
        return colonToken >= 0 ? hostAndPort.substring(0, colonToken) : hostAndPort;
    }

    public int getNodePort() {
        String hostAndPort = this.getNodeHostPort();
        int colonToken = hostAndPort.lastIndexOf(":");
        String portString = colonToken >= 0 ? hostAndPort.substring(colonToken + 1) : DbConfigManager.getVal(this.props, RepParams.DEFAULT_PORT);
        return Integer.parseInt(portString);
    }

    public InetSocketAddress getNodeSocketAddress() {
        return new InetSocketAddress(this.getNodeHostname(), this.getNodePort());
    }

    public MonitorConfig setNumRetries(int numRetries) {
        this.setNumRetriesVoid(numRetries);
        return this;
    }

    public void setNumRetriesVoid(int numRetries) {
        this.validate(numRetries, "numRetries");
        this.numRetries = numRetries;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public MonitorConfig setRetryInterval(long retryInterval) {
        this.setRetryIntervalVoid(retryInterval);
        return this;
    }

    public void setRetryIntervalVoid(long retryInterval) {
        this.validate(retryInterval, "retryInterval");
        this.retryInterval = retryInterval;
    }

    public long getRetryInterval() {
        return this.retryInterval;
    }

    public MonitorConfig setSocketConnectTimeout(int socketConnectTimeout) {
        this.setSocketConnectTimeoutVoid(socketConnectTimeout);
        return this;
    }

    public void setSocketConnectTimeoutVoid(int socketConnectTimeout) {
        this.validate(socketConnectTimeout, "socketConnectTimeout");
        this.socketConnectTimeout = socketConnectTimeout;
    }

    public int getSocketConnectTimeout() {
        return this.socketConnectTimeout;
    }

    private void validate(Number number, String param) {
        if (number.longValue() <= 0L) {
            throw new IllegalArgumentException("Parameter: " + param + " should be a positive number.");
        }
    }

    public MonitorConfig clone() {
        try {
            MonitorConfig copy = (MonitorConfig)super.clone();
            copy.props = (Properties)this.props.clone();
            copy.repNetConfig = this.repNetConfig.clone();
            return copy;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public ReplicationNetworkConfig getRepNetConfig() {
        return this.repNetConfig;
    }

    public MonitorConfig setRepNetConfig(ReplicationNetworkConfig netConfig) {
        this.setRepNetConfigVoid(netConfig);
        return this;
    }

    public void setRepNetConfigVoid(ReplicationNetworkConfig netConfig) {
        if (netConfig == null) {
            throw new IllegalArgumentException("netConfig may not be null");
        }
        this.repNetConfig = netConfig;
    }
}

