/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.stream;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.FeederFilter;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.NamedChannel;
import com.sleepycat.je.utilint.InternalException;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;

public class SubscriberFeederSyncup {
    private static final int MIN_VER_PART_GEN_DB = 8;
    private final Logger logger;
    private final RepImpl repImpl;
    private final NamedChannel namedChannel;
    private final Protocol protocol;
    private final FeederFilter filter;
    private final BaseProtocol.EntryRequestType type;
    private final String partGenDBName;
    private DatabaseId partGenDBId;

    public SubscriberFeederSyncup(NamedChannel namedChannel, Protocol protocol, FeederFilter filter, RepImpl repImpl, BaseProtocol.EntryRequestType type, String partGenDBName, Logger logger) {
        this.namedChannel = namedChannel;
        this.protocol = protocol;
        this.filter = filter;
        this.repImpl = repImpl;
        this.type = type;
        this.partGenDBName = partGenDBName;
        this.logger = logger;
        this.partGenDBId = null;
    }

    public VLSN execute(VLSN reqVLSN) throws InternalException {
        VLSN vLSN;
        long startTime = System.currentTimeMillis();
        LoggerUtils.info(this.logger, this.repImpl, "Subscriber-Feeder " + this.namedChannel.getNameIdPair() + " syncup started.");
        try {
            VLSN startVLSN = this.getStartVLSNFromFeeder(reqVLSN);
            if (this.partGenDBName != null && !this.partGenDBName.isEmpty()) {
                this.partGenDBId = this.getPartGenDBIdFromFeeder();
            }
            if (!startVLSN.equals(VLSN.NULL_VLSN)) {
                LoggerUtils.info(this.logger, this.repImpl, "Response from feeder  " + this.namedChannel.getNameIdPair() + ": the start VLSN " + startVLSN + ", the requested VLSN " + reqVLSN + ", send startStream request with filter.");
                Protocol protocol = this.protocol;
                Objects.requireNonNull(protocol);
                this.protocol.write((BinaryProtocol.Message)new BaseProtocol.StartStream(protocol, startVLSN, this.filter), this.namedChannel);
            } else {
                LoggerUtils.info(this.logger, this.repImpl, "Unable to stream from Feeder " + this.namedChannel.getNameIdPair() + " from requested VLSN " + reqVLSN);
            }
            vLSN = startVLSN;
        }
        catch (IOException | IllegalStateException e) {
            try {
                throw new InternalException(e.getMessage());
            }
            catch (Throwable throwable) {
                LoggerUtils.info(this.logger, this.repImpl, String.format("Subscriber to feeder " + this.namedChannel.getNameIdPair() + " sync-up done, elapsed time: %,dms", System.currentTimeMillis() - startTime));
                throw throwable;
            }
        }
        LoggerUtils.info(this.logger, this.repImpl, String.format("Subscriber to feeder " + this.namedChannel.getNameIdPair() + " sync-up done, elapsed time: %,dms", System.currentTimeMillis() - startTime));
        return vLSN;
    }

    public DatabaseId getPartGenDBId() {
        return this.partGenDBId;
    }

    private VLSN getStartVLSNFromFeeder(VLSN requestVLSN) throws IOException, IllegalStateException {
        VLSN vlsn;
        LoggerUtils.fine(this.logger, this.repImpl, "Subscriber send requested VLSN " + requestVLSN + " to feeder " + this.namedChannel.getNameIdPair());
        Protocol protocol = this.protocol;
        Objects.requireNonNull(protocol);
        this.protocol.write((BinaryProtocol.Message)new BaseProtocol.EntryRequest(protocol, requestVLSN, this.type), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (message instanceof BaseProtocol.Entry) {
            vlsn = ((BaseProtocol.Entry)message).getWireRecord().getVLSN();
            if (this.type.equals((Object)BaseProtocol.EntryRequestType.DEFAULT)) assert (vlsn.equals(requestVLSN));
            if (vlsn.equals(requestVLSN)) {
                LoggerUtils.finest(this.logger, this.repImpl, "Subscriber successfully requested VLSN " + requestVLSN + " from feeder " + this.namedChannel.getNameIdPair() + ", request type: " + this.type);
            }
            if (vlsn.compareTo(requestVLSN) < 0) {
                LoggerUtils.finest(this.logger, this.repImpl, "Requested VLSN " + requestVLSN + " is not available from feeder " + this.namedChannel.getNameIdPair() + " instead, start stream from a lowest available VLSN " + vlsn + ", request type: " + this.type);
            }
            if (vlsn.compareTo(requestVLSN) > 0) {
                if (this.type.equals((Object)BaseProtocol.EntryRequestType.NOW)) {
                    LoggerUtils.finest(this.logger, this.repImpl, "Stream from highest available vlsn from feeder " + this.namedChannel.getNameIdPair() + ":" + vlsn + ", request type: " + this.type);
                } else {
                    LoggerUtils.finest(this.logger, this.repImpl, "Requested VLSN " + requestVLSN + " is not available from feeder " + this.namedChannel.getNameIdPair() + " instead, start stream from a highest available VLSN " + vlsn + ", request type: " + this.type);
                }
            }
        } else if (message instanceof BaseProtocol.AlternateMatchpoint) {
            if (this.type.equals((Object)BaseProtocol.EntryRequestType.NOW) || this.type.equals((Object)BaseProtocol.EntryRequestType.AVAILABLE)) {
                String msg = "Receive unexpected response " + message + "from feeder " + this.namedChannel.getNameIdPair() + ", request type: " + this.type;
                LoggerUtils.warning(this.logger, this.repImpl, msg);
                throw new IllegalStateException(msg);
            }
            vlsn = ((BaseProtocol.AlternateMatchpoint)message).getAlternateWireRecord().getVLSN();
            assert (vlsn.compareTo(requestVLSN) < 0);
            LoggerUtils.finest(this.logger, this.repImpl, "Feeder " + this.namedChannel.getNameIdPair() + " returns a valid start VLSN" + vlsn + " but earlier than requested one " + requestVLSN + ", request type: " + this.type);
        } else if (message instanceof BaseProtocol.EntryNotFound) {
            if (this.type.equals((Object)BaseProtocol.EntryRequestType.NOW) || this.type.equals((Object)BaseProtocol.EntryRequestType.AVAILABLE)) {
                String msg = "Receive unexpected response " + message + "from feeder " + this.namedChannel.getNameIdPair() + ", request type: " + this.type;
                LoggerUtils.warning(this.logger, this.repImpl, msg);
                throw new IllegalStateException(msg);
            }
            vlsn = VLSN.NULL_VLSN;
            LoggerUtils.finest(this.logger, this.repImpl, "Feeder " + this.namedChannel.getNameIdPair() + " is unable to service the request vlsn " + requestVLSN + ", request type: " + this.type);
        } else {
            String msg = "Receive unexpected response " + message + "from feeder " + this.namedChannel.getNameIdPair() + ", request type: " + this.type;
            LoggerUtils.warning(this.logger, this.repImpl, msg);
            throw new IllegalStateException(msg);
        }
        return vlsn;
    }

    private DatabaseId getPartGenDBIdFromFeeder() throws IOException, IllegalStateException {
        if (this.protocol.getVersion() < 8) {
            LoggerUtils.info(this.logger, this.repImpl, "Client provides part gen db name while the server protocol (ver " + this.protocol.getVersion() + ") is not upgraded to support it, min ver to support partition generation 8, ignore.");
            return null;
        }
        LoggerUtils.fine(this.logger, this.repImpl, "Subscriber sends request for partition generation db id for " + this.partGenDBName + " to feeder " + this.namedChannel.getNameIdPair());
        Protocol protocol = this.protocol;
        Objects.requireNonNull(protocol);
        this.protocol.write((BinaryProtocol.Message)protocol.new Protocol.DBIdRequest(this.partGenDBName), this.namedChannel);
        BinaryProtocol.Message message = this.protocol.read(this.namedChannel);
        if (!(message instanceof Protocol.DBIdResponse)) {
            String msg = "Receive unexpected response " + message + "from feeder " + this.namedChannel.getNameIdPair() + ", request type: " + this.type;
            LoggerUtils.warning(this.logger, this.repImpl, msg);
            throw new IllegalStateException(msg);
        }
        DatabaseId id = ((Protocol.DBIdResponse)message).getDbId();
        LoggerUtils.fine(this.logger, this.repImpl, "Subscriber successfully requested partition generation db id " + id + " from feeder " + this.namedChannel.getNameIdPair());
        return id;
    }
}

