/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.config.DurationConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.log.entry.NameLNLogEntry;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.ReplicationNetworkConfig;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.FeederFilter;
import com.sleepycat.je.rep.stream.OutputWireRecord;
import com.sleepycat.je.rep.subscription.ClientAuthMethod;
import com.sleepycat.je.rep.subscription.SubscriptionAuthHandler;
import com.sleepycat.je.rep.subscription.SubscriptionCallback;
import com.sleepycat.je.rep.utilint.HostPortPair;
import com.sleepycat.je.rep.utilint.ServiceHandshake;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.utilint.DatabaseUtil;
import com.sleepycat.je.utilint.PropUtil;
import com.sleepycat.je.utilint.VLSN;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class SubscriptionConfig
implements Cloneable {
    public static final long QUEUE_POLL_INTERVAL_MS = 1000L;
    public static final String SERVICE_HANDSHAKE_AUTH_METHOD = "SubscriptionTokenAuth";
    public static final InetSocketAddress ANY_ADDRESS = new InetSocketAddress((InetAddress)null, 0);
    private static final int DEFAULT_MIN_PROTOCOL_VERSION = 6;
    public final boolean TCP_NO_DELAY = true;
    public final boolean BLOCKING_MODE_CHANNEL = true;
    private final boolean validateParams = true;
    private final String subHome;
    private final String subNodeName;
    private final String subHostPortPair;
    private final String feederHostPortPair;
    private final String groupName;
    private final SubscriptionAuthHandler authenticator;
    private BaseProtocol.EntryRequestType streamMode;
    private UUID groupUUID;
    private SubscriptionCallback callBack;
    private FeederFilter feederFilter;
    private Properties props;
    private int inputMessageQueueSize;
    private int outputMessageQueueSize;
    private NodeType nodeType = NodeType.SECONDARY;
    private int minProtocolVersion = 6;
    private final ServiceHandshake.AuthenticationMethod authInfo;
    private String partGenDBName;

    public SubscriptionConfig(String subNodeName, String subHome, String subHostPortPair, String feederHostPortPair, String groupName) throws UnknownHostException {
        this(subNodeName, subHome, subHostPortPair, feederHostPortPair, groupName, null);
    }

    public SubscriptionConfig(String subNodeName, String subHome, String subHostPortPair, String feederHostPortPair, String groupName, UUID groupUUID) throws UnknownHostException {
        this(subNodeName, subHome, subHostPortPair, feederHostPortPair, groupName, groupUUID, NodeType.SECONDARY);
    }

    public SubscriptionConfig(String subNodeName, String subHome, String subHostPortPair, String feederHostPortPair, String groupName, UUID groupUUID, NodeType nodeType) throws UnknownHostException {
        this(subNodeName, subHome, subHostPortPair, feederHostPortPair, groupName, groupUUID, nodeType, null);
    }

    public SubscriptionConfig(String subNodeName, String subHome, String subHostPortPair, String feederHostPortPair, String groupName, UUID groupUUID, NodeType nodeType, SubscriptionAuthHandler authenticator) throws UnknownHostException {
        this(subNodeName, subHome, subHostPortPair, feederHostPortPair, groupName, groupUUID, nodeType, authenticator, new Properties());
    }

    public SubscriptionConfig(String subNodeName, String subHome, String subHostPortPair, String feederHostPortPair, String groupName, UUID groupUUID, NodeType nodeType, SubscriptionAuthHandler authenticator, Properties props) throws UnknownHostException {
        this.subNodeName = subNodeName;
        this.subHome = subHome;
        this.subHostPortPair = subHostPortPair;
        this.feederHostPortPair = feederHostPortPair;
        this.groupName = groupName;
        this.groupUUID = groupUUID;
        this.nodeType = nodeType;
        this.authenticator = authenticator;
        this.props = props;
        this.streamMode = BaseProtocol.EntryRequestType.DEFAULT;
        this.inputMessageQueueSize = this.getDefaultMsgQueueSize();
        this.outputMessageQueueSize = this.getDefaultMsgQueueSize();
        this.callBack = new DefaultCallback();
        this.feederFilter = new DefaultFeederFilter();
        this.authInfo = this.createClientAuthMethod(authenticator);
        this.partGenDBName = null;
        this.verifyParameters();
    }

    public EnvironmentConfig createEnvConfig() {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setReadOnly(true);
        envConfig.setTransactional(true);
        envConfig.setConfigParam(EnvironmentParams.ENV_RECOVERY.getName(), "false");
        envConfig.setConfigParam(EnvironmentParams.ENV_SETUP_LOGGER.getName(), "true");
        return envConfig;
    }

    ReplicationConfig createReplicationConfig() {
        ReplicationConfig repConfig = new ReplicationConfig(this.getGroupName(), this.getSubNodeName(), this.getSubNodeHostPort());
        repConfig.setConfigParam(RepParams.SUBSCRIBER_USE.getName(), "true");
        ReplicationNetworkConfig rwc = this.props == null || this.props.isEmpty() ? ReplicationNetworkConfig.createDefault() : ReplicationNetworkConfig.create(this.props);
        repConfig.setRepNetConfig(rwc);
        repConfig.setConfigParam(RepParams.REPLICA_MESSAGE_QUEUE_SIZE.getName(), Integer.toString(this.getDefaultMsgQueueSize()));
        repConfig.setConfigParam(RepParams.REPLICA_TIMEOUT.getName(), String.valueOf(this.getChannelTimeout(TimeUnit.MILLISECONDS)) + " ms");
        repConfig.setConfigParam(RepParams.PRE_HEARTBEAT_TIMEOUT.getName(), String.valueOf(this.getPreHeartbeatTimeout(TimeUnit.MILLISECONDS)) + " ms");
        repConfig.setConfigParam(RepParams.REPSTREAM_OPEN_TIMEOUT.getName(), String.valueOf(this.getStreamOpenTimeout(TimeUnit.MILLISECONDS)) + " ms");
        repConfig.setConfigParam(RepParams.HEARTBEAT_INTERVAL.getName(), Integer.toString(this.getHeartbeatIntervalMs()));
        repConfig.setConfigParam(RepParams.REPLICA_RECEIVE_BUFFER_SIZE.getName(), Integer.toString(this.getReceiveBufferSize()));
        repConfig.setNodeType(this.nodeType);
        return repConfig;
    }

    public FeederFilter getFeederFilter() {
        return this.feederFilter;
    }

    public SubscriptionAuthHandler getAuthenticator() {
        return this.authenticator;
    }

    public SubscriptionCallback getCallBack() {
        return this.callBack;
    }

    public String getSubscriberHome() {
        return this.subHome;
    }

    public String getFeederHost() {
        return HostPortPair.getHostname(this.feederHostPortPair);
    }

    public int getFeederPort() {
        return HostPortPair.getPort(this.feederHostPortPair);
    }

    public InetAddress getFeederHostAddr() throws UnknownHostException {
        return InetAddress.getByName(HostPortPair.getHostname(this.feederHostPortPair));
    }

    public String getSubNodeName() {
        return this.subNodeName;
    }

    public String getSubNodeHostPort() {
        return this.subHostPortPair;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public UUID getGroupUUID() {
        return this.groupUUID;
    }

    public int getMaxConnectRetries() {
        return DbConfigManager.getIntVal(this.props, RepParams.SUBSCRIPTION_MAX_CONNECT_RETRIES);
    }

    public long getSleepBeforeRetryMs() {
        return DbConfigManager.getDurationVal(this.props, RepParams.SUBSCRIPTION_SLEEP_BEFORE_RETRY, TimeUnit.MILLISECONDS);
    }

    public long getChannelTimeout(TimeUnit unit) {
        DurationConfigParam param = RepParams.REPLICA_TIMEOUT;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getDurationVal(this.props, RepParams.REPLICA_TIMEOUT, unit);
        }
        long ms = PropUtil.parseDuration(param.getDefault());
        return unit.convert(ms, TimeUnit.MILLISECONDS);
    }

    public long getPollIntervalMs() {
        return DbConfigManager.getDurationVal(this.props, RepParams.SUBSCRIPTION_POLL_INTERVAL, TimeUnit.MILLISECONDS);
    }

    public long getPollTimeoutMs() {
        return DbConfigManager.getDurationVal(this.props, RepParams.SUBSCRIPTION_POLL_TIMEOUT, TimeUnit.MILLISECONDS);
    }

    public long getPreHeartbeatTimeout(TimeUnit unit) {
        DurationConfigParam param = RepParams.PRE_HEARTBEAT_TIMEOUT;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getDurationVal(this.props, param, unit);
        }
        long ms = PropUtil.parseDuration(param.getDefault());
        return unit.convert(ms, TimeUnit.MILLISECONDS);
    }

    public long getStreamOpenTimeout(TimeUnit unit) {
        DurationConfigParam param = RepParams.REPSTREAM_OPEN_TIMEOUT;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getDurationVal(this.props, param, unit);
        }
        long ms = PropUtil.parseDuration(param.getDefault());
        return unit.convert(ms, TimeUnit.MILLISECONDS);
    }

    public int getHeartbeatIntervalMs() {
        IntConfigParam param = RepParams.HEARTBEAT_INTERVAL;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getIntVal(this.props, param);
        }
        return Integer.parseInt(param.getDefault());
    }

    public int getReceiveBufferSize() {
        IntConfigParam param = RepParams.REPLICA_RECEIVE_BUFFER_SIZE;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getIntVal(this.props, param);
        }
        return Integer.parseInt(param.getDefault());
    }

    public int getInputMessageQueueSize() {
        return this.inputMessageQueueSize;
    }

    public int getOutputMessageQueueSize() {
        return this.outputMessageQueueSize;
    }

    public InetSocketAddress getInetSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(this.getFeederHostAddr(), this.getFeederPort());
    }

    public BaseProtocol.EntryRequestType getStreamMode() {
        return this.streamMode;
    }

    public String getPartGenDBName() {
        return this.partGenDBName;
    }

    public void setPartGenDBName(String dbName) {
        this.partGenDBName = dbName;
    }

    public void setMinProtocolVersion(int ver) {
        if (ver < 6) {
            throw new IllegalArgumentException("Minimal HA protocol version cannot be lower than 6");
        }
        this.minProtocolVersion = ver;
    }

    public void setGroupUUID(UUID gID) {
        this.groupUUID = gID;
    }

    public void setCallback(SubscriptionCallback cbk) {
        if (cbk == null) {
            throw new IllegalArgumentException("Subscription callback cannot be null.");
        }
        this.callBack = cbk;
    }

    public void setChannelTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.REPLICA_TIMEOUT, timeout, unit, true);
    }

    public void setPreHeartbeatTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.PRE_HEARTBEAT_TIMEOUT, timeout, unit, true);
    }

    public void setHeartbeatInterval(int ms) throws IllegalArgumentException {
        DbConfigManager.setIntVal(this.props, RepParams.HEARTBEAT_INTERVAL, ms, true);
    }

    public void setStreamOpenTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, RepParams.REPSTREAM_OPEN_TIMEOUT, timeout, unit, true);
    }

    public void setReceiveBufferSize(int val) {
        DbConfigManager.setIntVal(this.props, RepParams.REPLICA_RECEIVE_BUFFER_SIZE, val, true);
    }

    public void setInputMessageQueueSize(int size) {
        this.inputMessageQueueSize = size;
    }

    public void setOutputMessageQueueSize(int size) {
        this.outputMessageQueueSize = size;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public int getMinProtocolVersion() {
        return this.minProtocolVersion;
    }

    public SubscriptionConfig clone() {
        try {
            SubscriptionConfig ret = (SubscriptionConfig)super.clone();
            ret.setProps(this.props);
            return ret;
        }
        catch (CloneNotSupportedException willNeverOccur) {
            return null;
        }
    }

    public void setFeederFilter(FeederFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Feeder filter cannot be null.");
        }
        this.feederFilter = filter;
    }

    public void setStreamMode(BaseProtocol.EntryRequestType type) {
        this.streamMode = type;
    }

    private void setProps(Properties p) {
        this.props = p;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("subscription configuration: ").append("\n");
        sb.append("subscription name: ").append(this.subNodeName).append("\n");
        sb.append("home directory: ").append(this.subHome).append("\n");
        sb.append("home host and port: ").append(this.subHostPortPair).append("\n");
        sb.append("feeder host and port: ").append(this.feederHostPortPair).append("\n");
        try {
            sb.append("feeder address: ").append(this.getFeederHostAddr()).append("\n");
        }
        catch (UnknownHostException e) {
            sb.append("feeder address: unknown host ").append(this.feederHostPortPair).append("\n");
        }
        sb.append("feeder filter: ").append(this.feederFilter).append("\n");
        sb.append("rep group: ").append(this.groupName).append("\n");
        sb.append("rep group id: ").append(this.groupUUID).append("\n");
        sb.append("stream mode: ").append((Object)this.streamMode);
        return sb.toString();
    }

    private ClientAuthMethod createClientAuthMethod(SubscriptionAuthHandler authHandler) {
        if (authHandler == null) {
            return null;
        }
        return new ClientAuthMethod(authHandler);
    }

    ServiceHandshake.AuthenticationMethod[] getAuthInfo() {
        if (this.authInfo == null) {
            return null;
        }
        return new ServiceHandshake.AuthenticationMethod[]{this.authInfo};
    }

    private void verifyParameters() throws IllegalArgumentException {
        DatabaseUtil.checkForNullParam(this.getSubscriberHome(), "subscription home directory");
        DatabaseUtil.checkForNullParam(this.feederHostPortPair, "feeder host port pair");
        DatabaseUtil.checkForNullParam(this.getFeederHost(), "feeder host name");
        DatabaseUtil.checkForNullParam(this.getFeederPort(), "feeder host port");
        DatabaseUtil.checkForNullParam(this.subHostPortPair, "subscriber host port pair");
        DatabaseUtil.checkForNullParam(this.getSubNodeName(), "subscriber node name");
        DatabaseUtil.checkForNullParam(this.getSubNodeHostPort(), "subscriber node host port");
        DatabaseUtil.checkForNullParam(this.getGroupName(), "replication group");
        if (!this.nodeType.isExternal() && !this.nodeType.isSecondary()) {
            throw new IllegalArgumentException("'node type' param must be either SECONDARY or EXTERNAL, found node type: " + this.nodeType);
        }
    }

    private int getDefaultMsgQueueSize() {
        IntConfigParam param = RepParams.REPLICA_MESSAGE_QUEUE_SIZE;
        if (this.props.containsKey(param.getName())) {
            return DbConfigManager.getIntVal(this.props, param);
        }
        return Integer.parseInt(param.getDefault());
    }

    private static class DefaultFeederFilter
    implements FeederFilter,
    Serializable {
        private static final long serialVersionUID = 1L;
        final Set<DatabaseId> cachedIntDupDBId = new HashSet<DatabaseId>();

        DefaultFeederFilter() {
        }

        @Override
        public String[] getTableIds() {
            return null;
        }

        @Override
        public void setLogger(Logger logger) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputWireRecord execute(OutputWireRecord record, RepImpl repImpl) {
            DatabaseId dbId = record.getReplicableDBId();
            if (dbId == null) {
                return record;
            }
            if (this.cachedIntDupDBId.contains(dbId)) {
                NameLNLogEntry entry;
                byte type = record.getEntryType();
                if ((LogEntryType.LOG_NAMELN.equalsType(type) || LogEntryType.LOG_NAMELN_TRANSACTIONAL.equalsType(type)) && (entry = (NameLNLogEntry)record.instantiateEntry()).getOperationType() == DbOperationType.REMOVE) {
                    NameLN nameLn = (NameLN)entry.getMainItem();
                    this.cachedIntDupDBId.remove(nameLn.getId());
                }
                return null;
            }
            DbTree dbTree = repImpl.getDbTree();
            DatabaseImpl impl = dbTree.getDb(dbId);
            try {
                if (impl == null) {
                    OutputWireRecord outputWireRecord = record;
                    return outputWireRecord;
                }
                if (impl.getSortedDuplicates()) {
                    this.cachedIntDupDBId.add(dbId);
                    OutputWireRecord outputWireRecord = null;
                    return outputWireRecord;
                }
                if (impl.isInternalDb()) {
                    this.cachedIntDupDBId.add(dbId);
                    OutputWireRecord outputWireRecord = null;
                    return outputWireRecord;
                }
                OutputWireRecord outputWireRecord = record;
                return outputWireRecord;
            }
            finally {
                if (impl != null) {
                    dbTree.releaseDb(impl);
                }
            }
        }
    }

    private class DefaultCallback
    implements SubscriptionCallback {
        DefaultCallback() {
        }

        @Override
        public void processPut(VLSN vlsn, byte[] key, byte[] value, long txnId, DatabaseId dbId) {
        }

        @Override
        public void processDel(VLSN vlsn, byte[] key, long txnId, DatabaseId dbId) {
        }

        @Override
        public void processCommit(VLSN vlsn, long txnid) {
        }

        @Override
        public void processAbort(VLSN vlsn, long txnid) {
        }

        @Override
        public void processException(Exception exception) {
        }
    }
}

