/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.subscription;

import com.sleepycat.je.rep.ReplicationSecurityException;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.node.ReplicaOutputThreadBase;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.rep.stream.Protocol;
import com.sleepycat.je.rep.subscription.SubscriptionAuthHandler;
import com.sleepycat.je.rep.subscription.SubscriptionStat;
import com.sleepycat.je.rep.subscription.SubscriptionThread;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.utilint.VLSN;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;

class SubscriptionOutputThread
extends ReplicaOutputThreadBase {
    private final SubscriptionStat stats;
    private final SubscriptionAuthHandler authenticator;
    private final SubscriptionThread parentThread;

    SubscriptionOutputThread(SubscriptionThread parentThread, RepImpl repImpl, BlockingQueue<Long> outputQueue, Protocol protocol, DataChannel replicaFeederChannel, SubscriptionAuthHandler authenticator, SubscriptionStat stats) {
        super(repImpl, outputQueue, protocol, replicaFeederChannel);
        this.parentThread = parentThread;
        this.authenticator = authenticator;
        this.stats = stats;
    }

    @Override
    public void writeReauthentication() throws ReplicationSecurityException, IOException {
        if (this.authenticator != null && this.authenticator.hasNewToken()) {
            Protocol protocol = this.protocol;
            Objects.requireNonNull(protocol);
            Protocol.ReAuthenticate response = protocol.new Protocol.ReAuthenticate(this.authenticator.getToken());
            this.protocol.write((BinaryProtocol.Message)response, this.replicaFeederChannel);
        }
    }

    @Override
    public void writeHeartbeat(Long txnId) throws IOException {
        Protocol protocol = this.protocol;
        Objects.requireNonNull(protocol);
        BaseProtocol.HeartbeatResponse response = protocol.new BaseProtocol.HeartbeatResponse(VLSN.NULL_VLSN, this.stats.getHighVLSN());
        this.protocol.write((BinaryProtocol.Message)response, this.replicaFeederChannel);
        this.stats.getNumMsgResponded().increment();
    }
}

