/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.je.CacheMode;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentNotFoundException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestore;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.RepInternal;
import com.sleepycat.je.rep.ReplicatedEnvironment;
import com.sleepycat.je.rep.ReplicationConfig;
import com.sleepycat.je.rep.impl.RepGroupDB;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepNodeImpl;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.File;
import java.util.Date;

public class DbNullNode {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbNullNode.class) + "\n       -h <env home dir>\n       -nodeName <nodeName>\n       [-groupName <groupName>]\n       [-hostPort <hostPort>]\n       [-createEnv]\n       [-createNode]\n       [-helpers <hostPort>,<hostPort> ...]\n       [-designatedPrimary] \n       [-electableGroupSize] <groupSize>\n       [-updates <updates>\n       [-nodeType ELECTABLE|SECONDARY]\n       [-cacheMode ENUM_NAME]\n";
    private File envHome;
    private String nodeName;
    private String hostPort;
    private String groupName;
    public String helpers;
    private boolean createNode = false;
    private boolean createEnv = false;
    private final int pollIntervalMs = 60000;
    private boolean designatedPrimary = false;
    private int electableGroupSize = 0;
    private int updates = 0;
    private NodeType nodeType = NodeType.ELECTABLE;
    private CacheMode cacheMode = CacheMode.DEFAULT;
    private static final DatabaseConfig dbConfig = new DatabaseConfig();
    private static final TransactionConfig txnConfig = TransactionConfig.DEFAULT;

    public static void main(String[] argv) {
        DbNullNode runAction = new DbNullNode();
        runAction.parseArgs(argv);
        try {
            runAction.run();
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        if (nArgs < 4) {
            this.printUsage(null);
            System.exit(0);
        }
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-h")) {
                if (argc < nArgs) {
                    this.envHome = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-h requires an argument");
                continue;
            }
            if (thisArg.equals("-nodeName")) {
                if (argc < nArgs) {
                    this.nodeName = argv[argc++];
                    continue;
                }
                this.printUsage("-nodeName requires an argument");
                continue;
            }
            if (thisArg.equals("-hostPort")) {
                if (argc < nArgs) {
                    this.hostPort = argv[argc++];
                    continue;
                }
                this.printUsage("-hostPort requires an argument");
                continue;
            }
            if (thisArg.equals("-groupName")) {
                if (argc < nArgs) {
                    this.groupName = argv[argc++];
                    continue;
                }
                this.printUsage("-groupName requires an argument");
                continue;
            }
            if (thisArg.equals("-createNode")) {
                this.createNode = true;
                continue;
            }
            if (thisArg.equals("-createEnv")) {
                this.createEnv = true;
                continue;
            }
            if (thisArg.equals("-helpers")) {
                if (argc < nArgs) {
                    this.helpers = argv[argc++];
                    continue;
                }
                this.printUsage("-helpers requires an argument");
                continue;
            }
            if ("-designatedPrimary".equals(thisArg)) {
                this.designatedPrimary = true;
                continue;
            }
            if ("-electableGroupSize".equals(thisArg)) {
                if (argc < nArgs) {
                    this.electableGroupSize = Integer.parseInt(argv[argc++]);
                    continue;
                }
                this.printUsage("-electableGroupSize requires a group size argument");
                continue;
            }
            if ("-updates".equals(thisArg)) {
                if (argc < nArgs) {
                    this.updates = Integer.parseInt(argv[argc++]);
                    continue;
                }
                this.printUsage("-updates requires number of updates/periodargument");
                continue;
            }
            if ("-nodeType".equals(thisArg)) {
                if (argc < nArgs) {
                    this.nodeType = NodeType.valueOf(argv[argc++]);
                    continue;
                }
                this.printUsage("-nodeType requires a type argument");
                continue;
            }
            if ("-cacheMode".equals(thisArg)) {
                if (argc < nArgs) {
                    this.cacheMode = CacheMode.valueOf(argv[argc++]);
                    continue;
                }
                this.printUsage("-cacheMode requires a type argument");
                continue;
            }
            this.printUsage(thisArg + " is not a valid argument");
        }
        if (this.createNode && (this.nodeName == null || this.hostPort == null || this.groupName == null || this.helpers == null)) {
            this.printUsage("groupName, nodeName, nodeHost and helpers must all be specified when using -createNode");
        }
        if (this.createEnv && (this.groupName == null || this.helpers == null)) {
            this.printUsage("groupName and helpers must all be specified when using -createEnv");
        }
    }

    private void run() {
        while (true) {
            try {
                this.checkParameters();
                this.openAndIdle();
            }
            catch (InsufficientLogException ile) {
                System.err.println("Restoring environment:" + this.envHome);
                NetworkRestore networkRestore = new NetworkRestore();
                NetworkRestoreConfig config = new NetworkRestoreConfig();
                networkRestore.execute(ile, config);
                System.err.println("Restored environment:" + this.envHome);
                this.createEnv = false;
                continue;
            }
            break;
        }
    }

    private void checkParameters() {
        block13: {
            try {
                RepNodeImpl node;
                if (!this.envHome.exists()) {
                    this.printUsage("Directory:" + this.envHome + " does not exist.");
                }
                RepGroupImpl group = RepGroupDB.getGroup(this.envHome);
                if (this.createEnv) {
                    this.printUsage("Environment exists:" + this.envHome + "but -createEnv was specified.");
                }
                if ((node = group.getNode(this.nodeName)) == null) {
                    if (!this.createNode) {
                        this.printUsage("The node:" + this.nodeName + " is not a member of the group:" + group + ". Use -createNode to create a new one.");
                    }
                } else {
                    if (this.groupName == null) {
                        this.groupName = group.getName();
                    } else if (!this.groupName.equals(group.getName())) {
                        this.printUsage("-groupname:" + this.groupName + ", does not match the name:" + group.getName() + " in the environment.");
                    }
                    if (this.hostPort == null) {
                        this.hostPort = node.getHostPortPair();
                    } else if (!this.hostPort.equals(node.getHostPortPair())) {
                        System.err.println("-hostPort:" + this.hostPort + ", does not match the hostPort:" + node.getHostPortPair() + " in the environment. Continuing ...");
                    }
                }
            }
            catch (EnvironmentNotFoundException enf) {
                if (this.createEnv) break block13;
                this.printUsage("No existing environment:" + this.envHome + ". Use -createEnv to create one");
            }
        }
    }

    private void openAndIdle() throws InsufficientLogException {
        ReplicationConfig repConfig = new ReplicationConfig();
        repConfig.setNodeName(this.nodeName);
        repConfig.setGroupName(this.groupName);
        repConfig.setNodeHostPort(this.hostPort);
        repConfig.setDesignatedPrimary(this.designatedPrimary);
        repConfig.setElectableGroupSizeOverride(this.electableGroupSize);
        repConfig.setNodeType(this.nodeType);
        if (this.helpers != null) {
            repConfig.setHelperHosts(this.helpers);
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(this.createEnv);
        envConfig.setCacheMode(this.cacheMode);
        ReplicatedEnvironment repEnv = new ReplicatedEnvironment(this.envHome, repConfig, envConfig);
        RepNode repNode = RepInternal.getNonNullRepImpl(repEnv).getRepNode();
        System.err.println("Handle created:" + repEnv + "  Node idling indefinitely...");
        try {
            while (true) {
                System.out.println(new Date() + " State:" + repEnv.getState() + "  VLSN range:" + repNode.getVLSNIndex().getRange() + " DTVLSN:" + repNode.getDTVLSN() + repNode.dumpState());
                this.writeUpdates(repEnv);
                Thread.sleep(60000L);
            }
        }
        catch (InterruptedException e) {
            System.err.println("Exiting");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeUpdates(ReplicatedEnvironment repEnv) {
        if (this.updates == 0 || !repEnv.getState().isMaster()) {
            return;
        }
        Database db = null;
        Transaction txn = null;
        try {
            txn = repEnv.beginTransaction(null, TransactionConfig.DEFAULT);
            db = repEnv.openDatabase(txn, "DbNullDb", dbConfig);
            txn.commit();
            txn = null;
            DatabaseEntry key = new DatabaseEntry(new byte[]{1});
            IntegerBinding.intToEntry(0, key);
            txn = repEnv.beginTransaction(null, txnConfig);
            for (int i = 0; i < this.updates; ++i) {
                db.put(txn, key, key);
            }
            txn.commit();
            System.err.println(new Date() + " Wrote " + this.updates + " updates");
            txn = null;
        }
        catch (Exception e) {
            System.err.println("Update failed:" + e.getMessage());
        }
        finally {
            if (txn != null) {
                txn.abort();
            }
            if (db != null) {
                db.close();
            }
        }
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println(USAGE);
        System.exit(-1);
    }

    static {
        dbConfig.setAllowCreate(true);
        dbConfig.setTransactional(true);
        dbConfig.setSortedDuplicates(false);
    }
}

