/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.vlsn;

import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.bind.tuple.TupleInput;
import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.VLSN;

public class VLSNRange {
    private static final int VERSION = 1;
    public static final long RANGE_KEY = -1L;
    static final VLSNRange EMPTY = new VLSNRange(VLSN.NULL_VLSN, VLSN.NULL_VLSN, VLSN.NULL_VLSN, VLSN.NULL_VLSN);
    private final VLSN first;
    private final VLSN last;
    private final byte commitType = LogEntryType.LOG_TXN_COMMIT.getTypeNum();
    private final byte abortType = LogEntryType.LOG_TXN_ABORT.getTypeNum();
    private final VLSN lastSync;
    private final VLSN lastTxnEnd;

    private VLSNRange(VLSN first, VLSN last, VLSN lastSync, VLSN lastTxnEnd) {
        this.first = first;
        this.last = last;
        this.lastSync = lastSync;
        this.lastTxnEnd = lastTxnEnd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VLSN writeToDatabase(EnvironmentImpl envImpl, DatabaseImpl dbImpl, Txn txn) {
        VLSNRangeBinding binding = new VLSNRangeBinding();
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        LongBinding.longToEntry(-1L, key);
        binding.objectToEntry(this, data);
        try (Cursor c = null;){
            c = DbInternal.makeCursor(dbImpl, (Locker)txn, CursorConfig.DEFAULT);
            DbInternal.getCursorImpl(c).setAllowEviction(false);
            OperationStatus status = c.put(key, data);
            if (status != OperationStatus.SUCCESS) {
                throw EnvironmentFailureException.unexpectedState(envImpl, "Unable to write VLSNRange, status = " + status);
            }
        }
        return this.last;
    }

    public static VLSNRange readFromDatabase(DatabaseEntry data) {
        VLSNRangeBinding binding = new VLSNRangeBinding();
        VLSNRange range = (VLSNRange)binding.entryToObject(data);
        return range;
    }

    public VLSN getFirst() {
        return this.first;
    }

    public VLSN getLast() {
        return this.last;
    }

    public VLSN getLastSync() {
        return this.lastSync;
    }

    public VLSN getLastTxnEnd() {
        return this.lastTxnEnd;
    }

    VLSN getUpcomingVLSN() {
        return this.last.getNext();
    }

    public boolean contains(VLSN vlsn) {
        if (this.first.equals(VLSN.NULL_VLSN)) {
            return false;
        }
        return this.first.compareTo(vlsn) <= 0 && this.last.compareTo(vlsn) >= 0;
    }

    VLSNRange getUpdateForNewMapping(VLSN newValue, byte entryTypeNum) {
        VLSN newFirst = this.first;
        VLSN newLast = this.last;
        VLSN newLastSync = this.lastSync;
        VLSN newLastTxnEnd = this.lastTxnEnd;
        if (this.first.equals(VLSN.NULL_VLSN) || this.first.compareTo(newValue) > 0) {
            newFirst = newValue;
        }
        if (this.last.compareTo(newValue) < 0) {
            newLast = newValue;
        }
        if (LogEntryType.isSyncPoint(entryTypeNum) && this.lastSync.compareTo(newValue) < 0) {
            newLastSync = newValue;
        }
        if ((entryTypeNum == this.commitType || entryTypeNum == this.abortType) && this.lastTxnEnd.compareTo(newValue) < 0) {
            newLastTxnEnd = newValue;
        }
        return new VLSNRange(newFirst, newLast, newLastSync, newLastTxnEnd);
    }

    VLSNRange getUpdate(VLSNRange other) {
        VLSN newFirst = this.getComparison(this.first, other.first, other.first.compareTo(this.first) < 0);
        VLSN newLast = this.getComparison(this.last, other.last, other.last.compareTo(this.last) > 0);
        VLSN newLastSync = this.getComparison(this.lastSync, other.lastSync, other.lastSync.compareTo(this.lastSync) > 0);
        VLSN newLastTxnEnd = this.getComparison(this.lastTxnEnd, other.lastTxnEnd, other.lastTxnEnd.compareTo(this.lastTxnEnd) > 0);
        return new VLSNRange(newFirst, newLast, newLastSync, newLastTxnEnd);
    }

    VLSNRange merge(VLSNRange other) {
        VLSN newLast = this.getComparison(this.last, other.last, true);
        VLSN newLastSync = this.getComparison(this.lastSync, other.lastSync, true);
        VLSN newLastTxnEnd = this.getComparison(this.lastTxnEnd, other.lastTxnEnd, true);
        return new VLSNRange(this.first, newLast, newLastSync, newLastTxnEnd);
    }

    VLSNRange shortenFromEnd(VLSN deleteStart) {
        VLSN newLast = deleteStart.getPrev();
        assert (newLast.compareTo(this.lastTxnEnd) >= 0) : "Can't truncate at " + newLast + " because it overwrites a commit at " + this.lastTxnEnd;
        if (newLast.equals(VLSN.NULL_VLSN)) {
            return new VLSNRange(VLSN.NULL_VLSN, VLSN.NULL_VLSN, VLSN.NULL_VLSN, VLSN.NULL_VLSN);
        }
        return new VLSNRange(this.first, newLast, newLast, this.lastTxnEnd);
    }

    VLSNRange shortenFromHead(VLSN deleteEnd) {
        VLSN newFirst = null;
        VLSN newLast = this.last;
        if (deleteEnd.compareTo(this.last) == 0) {
            newFirst = VLSN.NULL_VLSN;
            newLast = VLSN.NULL_VLSN;
        } else {
            newFirst = deleteEnd.getNext();
        }
        assert (this.lastSync.equals(VLSN.NULL_VLSN) || this.lastSync.compareTo(newFirst) >= 0) : "Can't truncate lastSync= " + this.lastSync + " deleteEnd=" + deleteEnd;
        VLSN newTxnEnd = this.lastTxnEnd.compareTo(newFirst) > 0 ? this.lastTxnEnd : VLSN.NULL_VLSN;
        return new VLSNRange(newFirst, newLast, this.lastSync, newTxnEnd);
    }

    private VLSN getComparison(VLSN thisVLSN, VLSN otherVLSN, boolean better) {
        if (thisVLSN.equals(VLSN.NULL_VLSN)) {
            return otherVLSN;
        }
        if (otherVLSN.equals(VLSN.NULL_VLSN)) {
            return thisVLSN;
        }
        if (better) {
            return otherVLSN;
        }
        return thisVLSN;
    }

    boolean isEmpty() {
        return this.first.equals(VLSN.NULL_VLSN);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("first=").append(this.first);
        sb.append(" last=").append(this.last);
        sb.append(" sync=").append(this.lastSync);
        sb.append(" txnEnd=").append(this.lastTxnEnd);
        return sb.toString();
    }

    boolean verify(boolean verbose) {
        if (this.first.equals(VLSN.NULL_VLSN)) {
            if (!(this.last.equals(VLSN.NULL_VLSN) && this.lastSync.equals(VLSN.NULL_VLSN) && this.lastTxnEnd.equals(VLSN.NULL_VLSN))) {
                if (verbose) {
                    System.out.println("Range: All need to be NULL_VLSN " + this);
                }
                return false;
            }
        } else {
            if (this.first.compareTo(this.last) > 0) {
                if (verbose) {
                    System.out.println("Range: first > last " + this);
                }
                return false;
            }
            if (!this.lastSync.equals(VLSN.NULL_VLSN) && this.lastSync.compareTo(this.last) > 0) {
                if (verbose) {
                    System.out.println("Range: lastSync > last " + this);
                }
                return false;
            }
            if (!this.lastTxnEnd.equals(VLSN.NULL_VLSN) && this.lastTxnEnd.compareTo(this.last) > 0) {
                if (verbose) {
                    System.out.println("Range: lastTxnEnd > last " + this);
                }
                return false;
            }
        }
        return true;
    }

    boolean verifySubset(boolean verbose, VLSNRange subsetRange) {
        if (subsetRange == null) {
            return true;
        }
        if (subsetRange.getFirst().equals(VLSN.NULL_VLSN) && subsetRange.getLast().equals(VLSN.NULL_VLSN) && subsetRange.getLastSync().equals(VLSN.NULL_VLSN) && subsetRange.getLastTxnEnd().equals(VLSN.NULL_VLSN)) {
            return true;
        }
        if (this.first.compareTo(subsetRange.getFirst()) > 0) {
            if (verbose) {
                System.out.println("Range: subset must be LTE: this=" + this + " subset=" + subsetRange);
            }
            return false;
        }
        if (this.first.equals(VLSN.NULL_VLSN)) {
            return true;
        }
        if (this.last.compareTo(subsetRange.getLast()) < 0) {
            if (verbose) {
                System.out.println("Range: last must be GTE: this=" + this + " subsetRange=" + subsetRange);
            }
            return false;
        }
        return true;
    }

    static class VLSNRangeBinding
    extends TupleBinding<VLSNRange> {
        VLSNRangeBinding() {
        }

        @Override
        public VLSNRange entryToObject(TupleInput ti) {
            int onDiskVersion = ti.readPackedInt();
            if (onDiskVersion != 1) {
                throw EnvironmentFailureException.unexpectedState("Don't expect version diff on_disk=" + onDiskVersion + " source=1");
            }
            VLSNRange range = new VLSNRange(new VLSN(ti.readPackedLong()), new VLSN(ti.readPackedLong()), new VLSN(ti.readPackedLong()), new VLSN(ti.readPackedLong()));
            return range;
        }

        @Override
        public void objectToEntry(VLSNRange range, TupleOutput to) {
            to.writePackedInt(1);
            to.writePackedLong(range.getFirst().getSequence());
            to.writePackedLong(range.getLast().getSequence());
            to.writePackedLong(range.getLastSync().getSequence());
            to.writePackedLong(range.getLastTxnEnd().getSequence());
        }
    }
}

