/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.utilint.LatencyPercentile;
import com.sleepycat.je.utilint.Stat;
import com.sleepycat.je.utilint.StatDefinition;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StatWithValueType;

public class LatencyPercentileStat
extends StatWithValueType<Long> {
    public static final int DEFAULT_MAX_TRACKED_LATENCY_MILLIS = 1000;
    private static final long serialVersionUID = 1L;
    private final LatencyPercentile latency;

    public LatencyPercentileStat(StatGroup group, StatDefinition definition, float percentile) {
        this(group, definition, percentile, 1000);
    }

    public LatencyPercentileStat(StatGroup group, StatDefinition definition, float percentile, int maxTrackedLatencyMillis) {
        super(group, definition);
        if (definition.getType() != StatDefinition.StatType.INCREMENTAL) {
            throw new IllegalArgumentException("The stat type must be INCREMENTAL, found: " + definition.getType());
        }
        this.latency = new LatencyPercentile(definition.getName(), percentile, maxTrackedLatencyMillis);
    }

    private LatencyPercentileStat(StatDefinition definition, LatencyPercentile latency) {
        super(definition);
        this.latency = latency.copy();
    }

    public void add(long latencyMillis) {
        this.latency.add(latencyMillis);
    }

    @Override
    public Class<Long> getValueType() {
        return Long.class;
    }

    @Override
    public void set(Long newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(Stat<Long> other) {
        if (!(other instanceof LatencyPercentileStat)) {
            throw new IllegalArgumentException("Other stat must be a LatencyPercentileStat, found: " + other);
        }
        LatencyPercentileStat otherPercentile = (LatencyPercentileStat)other;
        this.latency.add(otherPercentile.latency);
    }

    public LatencyPercentileStat computeInterval(Stat<Long> base) {
        if (!(base instanceof LatencyPercentileStat)) {
            throw new IllegalArgumentException("Base stat must be a LatencyPercentileStat, found: " + base);
        }
        LatencyPercentileStat baseStat = (LatencyPercentileStat)base;
        LatencyPercentileStat result = this.copy();
        result.latency.updateInterval(baseStat.latency);
        return result;
    }

    @Override
    public void negate() {
        this.latency.negate();
    }

    @Override
    public Long get() {
        return this.latency.get();
    }

    @Override
    public void clear() {
        this.latency.clear();
    }

    @Override
    public LatencyPercentileStat copy() {
        return new LatencyPercentileStat(this.definition, this.latency);
    }

    @Override
    public String getFormattedValue() {
        return this.latency.getFormattedValue();
    }

    @Override
    public boolean isNotSet() {
        return this.latency.isNotSet();
    }
}

