/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.EnvironmentWedgedException;
import com.sleepycat.je.ExceptionListener;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.utilint.LoggerUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class StoppableThread
extends Thread {
    protected final EnvironmentImpl envImpl;
    private final AtomicBoolean shutdown = new AtomicBoolean(false);
    private Exception savedShutdownException = null;
    private long totalCpuTime = -1L;
    private long totalUserTime = -1L;
    private static final int DEFAULT_INTERRUPT_WAIT_MS = 10000;
    private static final int WAIT_FOR_SHUTDOWN_MS = 30000;

    protected StoppableThread(String threadName) {
        this(null, null, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, String threadName) {
        this(envImpl, null, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, Thread.UncaughtExceptionHandler handler, String threadName) {
        this(envImpl, handler, null, threadName);
    }

    protected StoppableThread(EnvironmentImpl envImpl, Thread.UncaughtExceptionHandler handler, Runnable runnable, String threadName) {
        super(null, runnable, threadName);
        this.envImpl = envImpl;
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(handler == null ? new UncaughtHandler() : handler);
    }

    protected abstract Logger getLogger();

    public Exception getSavedShutdownException() {
        return this.savedShutdownException;
    }

    public void saveShutdownException(Exception shutdownException) {
        this.savedShutdownException = shutdownException;
    }

    public boolean isShutdown() {
        return this.shutdown.get();
    }

    protected boolean shutdownDone(Logger logger) {
        if (this.shutdown.compareAndSet(false, true)) {
            return false;
        }
        this.waitForExit(logger);
        return true;
    }

    protected void cleanup() {
    }

    public static void handleUncaughtException(Logger useLogger, EnvironmentImpl envImpl, Thread t, Throwable e) {
        ExceptionListener exceptionListener;
        Object envName;
        if (useLogger != null) {
            envName = envImpl == null ? "" : envImpl.getName();
            String message = (String)envName + ":" + t.getName() + " exited unexpectedly with exception " + e;
            if (e != null) {
                message = message + LoggerUtils.getStackTrace(e);
            }
            if (envImpl != null) {
                LoggerUtils.severe(useLogger, envImpl, message);
            } else {
                useLogger.log(Level.SEVERE, message);
            }
        }
        if (envImpl == null) {
            return;
        }
        if (envImpl.isValid()) {
            envName = new EnvironmentFailureException(envImpl, EnvironmentFailureReason.UNCAUGHT_EXCEPTION, e);
        }
        if ((exceptionListener = envImpl.getExceptionListener()) != null) {
            exceptionListener.exceptionThrown(DbInternal.makeExceptionEvent(envImpl.getInvalidatingException(), t.getName()));
        }
    }

    public void shutdownThread(Logger logger) {
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (threadBean.isThreadCpuTimeSupported()) {
            this.totalCpuTime = threadBean.getThreadCpuTime(this.getId());
            this.totalUserTime = threadBean.getThreadUserTime(this.getId());
        } else if (threadBean.isCurrentThreadCpuTimeSupported() && Thread.currentThread() == this) {
            this.totalCpuTime = threadBean.getCurrentThreadCpuTime();
            this.totalUserTime = threadBean.getCurrentThreadUserTime();
        }
        if (Thread.currentThread() == this) {
            return;
        }
        try {
            LoggerUtils.info(logger, this.envImpl, this.getName() + " soft shutdown initiated.");
            int waitMs = this.initiateSoftShutdown();
            if (waitMs >= 0) {
                this.join(waitMs);
            }
            if (!this.isAlive()) {
                LoggerUtils.fine(logger, this.envImpl, this + " has exited.");
                return;
            }
            LoggerUtils.warning(logger, this.envImpl, "Soft shutdown failed for thread:" + this + " after waiting for " + waitMs + "ms resorting to interrupt.");
            this.interrupt();
            long joinWaitTime = waitMs > 0 ? (long)(2 * waitMs) : 10000L;
            this.join(joinWaitTime);
            if (!this.isAlive()) {
                LoggerUtils.warning(logger, this.envImpl, this + " shutdown via interrupt.");
                return;
            }
            String msg = this + " shutdown via interrupt FAILED. Thread still alive despite waiting for " + joinWaitTime + "ms.";
            LoggerUtils.severe(logger, this.envImpl, msg);
            LoggerUtils.fullThreadDump(logger, this.envImpl, Level.SEVERE);
            if (this.envImpl != null) {
                EnvironmentWedgedException environmentWedgedException = new EnvironmentWedgedException(this.envImpl, msg);
            }
        }
        catch (InterruptedException e1) {
            LoggerUtils.warning(logger, this.envImpl, "Interrupted while shutting down thread:" + this);
        }
    }

    private void waitForExit(Logger logger) {
        assert (this.shutdown.get());
        if (Thread.currentThread() == this) {
            return;
        }
        try {
            this.join(30000L);
            if (!this.isAlive()) {
                return;
            }
            LoggerUtils.warning(logger, this.envImpl, "Soft shutdown failed for thread:" + this + " after waiting for 30000ms, resorting to interrupt in wait-for-shutdown.");
            this.interrupt();
            this.join(30000L);
            if (!this.isAlive()) {
                return;
            }
            String msg = this + " shutdown via interrupt FAILED during wait-for-shutdown. Thread still alive despite waiting for 30000ms.";
            LoggerUtils.severe(logger, this.envImpl, msg);
            LoggerUtils.fullThreadDump(logger, this.envImpl, Level.SEVERE);
            if (this.envImpl != null) {
                EnvironmentWedgedException environmentWedgedException = new EnvironmentWedgedException(this.envImpl, msg);
            }
        }
        catch (InterruptedException e1) {
            LoggerUtils.warning(logger, this.envImpl, "Interrupted during wait-for-shutdown:" + this);
        }
    }

    protected int initiateSoftShutdown() {
        return -1;
    }

    public long getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public long getTotalUserTime() {
        return this.totalUserTime;
    }

    private class UncaughtHandler
    implements Thread.UncaughtExceptionHandler {
        private UncaughtHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            Logger useLogger = StoppableThread.this.getLogger();
            StoppableThread.handleUncaughtException(useLogger, StoppableThread.this.envImpl, t, e);
        }
    }
}

