/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.util.Date;

public class Timestamp
extends Date {
    static final long serialVersionUID = 2745179027874758501L;
    private int nanos;

    public Timestamp(long time) {
        super(time / 1000L * 1000L);
        this.nanos = (int)(time % 1000L * 1000000L);
        if (this.nanos < 0) {
            this.nanos = 1000000000 + this.nanos;
            super.setTime((time / 1000L - 1L) * 1000L);
        }
    }

    @Override
    public long getTime() {
        long time = super.getTime();
        return time + (long)(this.nanos / 1000000);
    }

    @Override
    public String toString() {
        Object nanosString;
        String yearString;
        int year = super.getYear() + 1900;
        int month = super.getMonth() + 1;
        int day = super.getDate();
        int hour = super.getHours();
        int minute = super.getMinutes();
        int second = super.getSeconds();
        String zeros = "000000000";
        String yearZeros = "0000";
        if (year < 1000) {
            yearString = "" + year;
            yearString = yearZeros.substring(0, 4 - yearString.length()) + yearString;
        } else {
            yearString = "" + year;
        }
        Object monthString = month < 10 ? "0" + month : Integer.toString(month);
        Object dayString = day < 10 ? "0" + day : Integer.toString(day);
        Object hourString = hour < 10 ? "0" + hour : Integer.toString(hour);
        Object minuteString = minute < 10 ? "0" + minute : Integer.toString(minute);
        Object secondString = second < 10 ? "0" + second : Integer.toString(second);
        if (this.nanos == 0) {
            nanosString = "0";
        } else {
            nanosString = Integer.toString(this.nanos);
            nanosString = zeros.substring(0, 9 - ((String)nanosString).length()) + (String)nanosString;
            char[] nanosChar = new char[((String)nanosString).length()];
            ((String)nanosString).getChars(0, ((String)nanosString).length(), nanosChar, 0);
            int truncIndex = 8;
            while (nanosChar[truncIndex] == '0') {
                --truncIndex;
            }
            nanosString = new String(nanosChar, 0, truncIndex + 1);
        }
        StringBuffer timestampBuf = new StringBuffer(20 + ((String)nanosString).length());
        timestampBuf.append(yearString);
        timestampBuf.append("-");
        timestampBuf.append((String)monthString);
        timestampBuf.append("-");
        timestampBuf.append((String)dayString);
        timestampBuf.append(" ");
        timestampBuf.append((String)hourString);
        timestampBuf.append(":");
        timestampBuf.append((String)minuteString);
        timestampBuf.append(":");
        timestampBuf.append((String)secondString);
        timestampBuf.append(".");
        timestampBuf.append((String)nanosString);
        return timestampBuf.toString();
    }

    public boolean equals(Timestamp ts) {
        if (super.equals(ts)) {
            return this.nanos == ts.nanos;
        }
        return false;
    }

    @Override
    public boolean equals(Object ts) {
        if (ts instanceof Timestamp) {
            return this.equals((Timestamp)ts);
        }
        return false;
    }
}

