/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.Get;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Put;
import com.sleepycat.je.ReadOptions;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.WriteOptions;
import com.sleepycat.persist.BasicIndex;
import com.sleepycat.persist.EntityResult;
import com.sleepycat.persist.EntityValueAdapter;
import com.sleepycat.persist.impl.PersistEntityBinding;
import com.sleepycat.persist.impl.PersistKeyAssigner;
import java.util.Map;
import java.util.SortedMap;

public class PrimaryIndex<PK, E>
extends BasicIndex<PK, E> {
    private Class<E> entityClass;
    private EntityBinding<E> entityBinding;
    private SortedMap<PK, E> map;
    private PersistKeyAssigner keyAssigner;

    public PrimaryIndex(Database database, Class<PK> keyClass, EntryBinding<PK> keyBinding, Class<E> entityClass, EntityBinding<E> entityBinding) throws DatabaseException {
        super(database, keyClass, keyBinding, new EntityValueAdapter<E>(entityClass, entityBinding, false));
        this.entityClass = entityClass;
        this.entityBinding = entityBinding;
        if (entityBinding instanceof PersistEntityBinding) {
            this.keyAssigner = ((PersistEntityBinding)entityBinding).getKeyAssigner();
        }
    }

    public Class<PK> getKeyClass() {
        return this.keyClass;
    }

    public EntryBinding<PK> getKeyBinding() {
        return this.keyBinding;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public EntityBinding<E> getEntityBinding() {
        return this.entityBinding;
    }

    public E put(E entity) throws DatabaseException {
        return this.put(null, entity);
    }

    public E put(Transaction txn, E entity) throws DatabaseException {
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.assignKey(entity, keyEntry);
        boolean autoCommit = false;
        Environment env = this.db.getEnvironment();
        if (this.transactional && txn == null && DbCompat.getThreadTransaction(env) == null) {
            txn = env.beginTransaction(null, this.getAutoCommitTransactionConfig());
            autoCommit = true;
        }
        CursorConfig cursorConfig = null;
        if (this.concurrentDB) {
            cursorConfig = new CursorConfig();
            DbCompat.setWriteCursor(cursorConfig, true);
        }
        boolean failed = true;
        Cursor cursor = this.db.openCursor(txn, cursorConfig);
        LockMode lockMode = this.locking ? LockMode.RMW : null;
        try {
            while (true) {
                OperationStatus status;
                if ((status = cursor.getSearchKey(keyEntry, dataEntry, lockMode)) == OperationStatus.SUCCESS) {
                    E existing = this.entityBinding.entryToObject(keyEntry, dataEntry);
                    this.entityBinding.objectToData(entity, dataEntry);
                    cursor.put(keyEntry, dataEntry);
                    failed = false;
                    E e = existing;
                    return e;
                }
                this.entityBinding.objectToData(entity, dataEntry);
                status = cursor.putNoOverwrite(keyEntry, dataEntry);
                if (status == OperationStatus.KEYEXIST) continue;
                failed = false;
                E e = null;
                return e;
            }
        }
        finally {
            cursor.close();
            if (autoCommit) {
                if (failed) {
                    txn.abort();
                } else {
                    txn.commit();
                }
            }
        }
    }

    public void putNoReturn(E entity) throws DatabaseException {
        this.putNoReturn(null, entity);
    }

    public void putNoReturn(Transaction txn, E entity) throws DatabaseException {
        this.put(txn, entity, Put.OVERWRITE, null);
    }

    public boolean putNoOverwrite(E entity) throws DatabaseException {
        return this.putNoOverwrite(null, entity);
    }

    public boolean putNoOverwrite(Transaction txn, E entity) throws DatabaseException {
        return this.put(txn, entity, Put.NO_OVERWRITE, null) != null;
    }

    public OperationResult put(Transaction txn, E entity, Put putType, WriteOptions options) {
        if (putType != Put.OVERWRITE && putType != Put.NO_OVERWRITE) {
            throw new IllegalArgumentException("putType not allowed: " + putType);
        }
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.assignKey(entity, keyEntry);
        this.entityBinding.objectToData(entity, dataEntry);
        return this.db.put(txn, keyEntry, dataEntry, putType, options);
    }

    private void assignKey(E entity, DatabaseEntry keyEntry) throws DatabaseException {
        if (this.keyAssigner != null) {
            if (!this.keyAssigner.assignPrimaryKey(entity, keyEntry)) {
                this.entityBinding.objectToKey(entity, keyEntry);
            }
        } else {
            this.entityBinding.objectToKey(entity, keyEntry);
        }
    }

    @Override
    public E get(PK key) throws DatabaseException {
        return this.get((Transaction)null, key, (LockMode)null);
    }

    @Override
    public E get(Transaction txn, PK key, LockMode lockMode) throws DatabaseException {
        EntityResult<E> result = this.get(txn, key, Get.SEARCH, DbInternal.getReadOptions(lockMode));
        return result != null ? (E)result.value() : null;
    }

    @Override
    public EntityResult<E> get(Transaction txn, PK key, Get getType, ReadOptions options) throws DatabaseException {
        PrimaryIndex.checkGetType(getType);
        DatabaseEntry keyEntry = new DatabaseEntry();
        DatabaseEntry dataEntry = new DatabaseEntry();
        this.keyBinding.objectToEntry(key, keyEntry);
        OperationResult result = this.db.get(txn, keyEntry, dataEntry, getType, options);
        if (result != null) {
            return new EntityResult<E>(this.makeEntity(key, keyEntry, dataEntry), result);
        }
        return null;
    }

    private E makeEntity(PK key, DatabaseEntry keyEntry, DatabaseEntry dataEntry) {
        return (E)(this.entityBinding instanceof PersistEntityBinding ? ((PersistEntityBinding)this.entityBinding).entryToObjectWithPriKey(key, dataEntry) : this.entityBinding.entryToObject(keyEntry, dataEntry));
    }

    @Override
    public Map<PK, E> map() {
        return this.sortedMap();
    }

    @Override
    public synchronized SortedMap<PK, E> sortedMap() {
        if (this.map == null) {
            this.map = new StoredSortedMap<PK, E>(this.db, this.keyBinding, this.entityBinding, true);
        }
        return this.map;
    }

    protected TransactionConfig getAutoCommitTransactionConfig() {
        return null;
    }

    @Override
    boolean isUpdateAllowed() {
        return true;
    }
}

