/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.cfg;

import com.google.common.collect.Maps;
import com.starrocks.connector.spark.exception.IllegalArgumentException;
import com.starrocks.connector.spark.util.IOUtils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Settings
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(Settings.class);

    public abstract String getProperty(String var1);

    public abstract void setProperty(String var1, String var2);

    public abstract Properties asProperties();

    public abstract Settings copy();

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return value;
    }

    public int getIntegerProperty(String name, int defaultValue) {
        try {
            if (this.getProperty(name) != null) {
                return Integer.parseInt(this.getProperty(name));
            }
        }
        catch (NumberFormatException e) {
            logger.warn("Parse '{}' to number failed. Original string is '{}'.", (Object)name, (Object)this.getProperty(name));
        }
        return defaultValue;
    }

    public Settings merge(Properties properties) {
        if (properties == null || properties.isEmpty()) {
            return this;
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            Object prop = propertyNames.nextElement();
            if (!(prop instanceof String)) continue;
            Object value = properties.get(prop);
            this.setProperty((String)prop, value.toString());
        }
        return this;
    }

    public Settings merge(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return this;
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.setProperty(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public Settings load(String source) throws IllegalArgumentException {
        Properties copy = IOUtils.propsFromString(source);
        this.merge(copy);
        return this;
    }

    public String save() throws IllegalArgumentException {
        Properties copy = this.asProperties();
        return IOUtils.propsToString(copy);
    }

    public Map<String, String> getPropertyMap() {
        return Maps.fromProperties((Properties)this.asProperties());
    }
}

