/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.cfg;

import com.google.common.base.Preconditions;
import com.starrocks.connector.spark.cfg.Settings;
import java.util.Properties;
import org.apache.spark.SparkConf;
import scala.Option;
import scala.Tuple2;

public class SparkSettings
extends Settings {
    private final SparkConf cfg;

    public SparkSettings(SparkConf cfg) {
        Preconditions.checkArgument((cfg != null ? 1 : 0) != 0, (Object)"non-null spark configuration expected.");
        this.cfg = cfg;
    }

    @Override
    public SparkSettings copy() {
        return new SparkSettings(this.cfg.clone());
    }

    @Override
    public String getProperty(String name) {
        Option op = this.cfg.getOption(name);
        if (!op.isDefined()) {
            op = this.cfg.getOption("spark." + name);
        }
        return op.isDefined() ? (String)op.get() : null;
    }

    @Override
    public void setProperty(String name, String value) {
        this.cfg.set(name, value);
    }

    @Override
    public Properties asProperties() {
        Properties props = new Properties();
        if (this.cfg != null) {
            String sparkPrefix = "spark.";
            for (Tuple2 tuple : this.cfg.getAll()) {
                String simpleKey;
                String key = (String)tuple._1;
                props.setProperty(key, (String)tuple._2);
                if (!key.startsWith(sparkPrefix) || props.containsKey(simpleKey = key.substring(sparkPrefix.length()))) continue;
                props.setProperty(simpleKey, (String)tuple._2);
            }
        }
        return props;
    }
}

