/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.serialization;

import com.starrocks.connector.spark.exception.IllegalArgumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Routing {
    private static Logger logger = LoggerFactory.getLogger(Routing.class);
    private String host;
    private int port;

    public Routing(String routing) throws IllegalArgumentException {
        this.parseRouting(routing);
    }

    private void parseRouting(String routing) throws IllegalArgumentException {
        logger.debug("Parse StarRocks BE address: '{}'.", (Object)routing);
        String[] hostPort = routing.split(":");
        if (hostPort.length != 2) {
            logger.error("Format of StarRocks BE address '{}' is illegal.", (Object)routing);
            throw new IllegalArgumentException("StarRocks BE", routing);
        }
        this.host = hostPort[0];
        try {
            this.port = Integer.parseInt(hostPort[1]);
        }
        catch (NumberFormatException e) {
            logger.error("Parse '{}' to number failed. Original string is '{}'.", (Object)"StarRocks BE's port", (Object)hostPort[1]);
            throw new IllegalArgumentException("StarRocks BE", routing);
        }
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return "StarRocks BE{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

