/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql;

import com.starrocks.connector.spark.exception.StarrocksException;
import com.starrocks.connector.spark.sql.conf.StarRocksConfig;
import com.starrocks.connector.spark.sql.conf.WriteStarRocksConfig;
import com.starrocks.connector.spark.sql.schema.StarRocksSchema;
import com.starrocks.connector.spark.sql.write.StarRocksWriteBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;

public class StarRocksTable
implements Table,
SupportsWrite {
    private static final Set<TableCapability> TABLE_CAPABILITY_SET = Collections.unmodifiableSet(new HashSet<TableCapability>(Arrays.asList(TableCapability.BATCH_WRITE, TableCapability.STREAMING_WRITE)));
    private final StructType schema;
    private final StarRocksSchema starRocksSchema;
    private final StarRocksConfig config;

    public StarRocksTable(StructType schema, StarRocksSchema starRocksSchema, StarRocksConfig config) {
        this.schema = schema;
        this.starRocksSchema = starRocksSchema;
        this.config = config;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        WriteStarRocksConfig writeConfig = new WriteStarRocksConfig(this.config.getOriginOptions(), this.schema, this.starRocksSchema);
        this.checkWriteParameter(writeConfig);
        return new StarRocksWriteBuilder(info, writeConfig);
    }

    public String name() {
        return String.format("StarRocksTable[%s.%s]", this.config.getDatabase(), this.config.getTable());
    }

    public StructType schema() {
        return this.schema;
    }

    public Set<TableCapability> capabilities() {
        return TABLE_CAPABILITY_SET;
    }

    private void checkWriteParameter(WriteStarRocksConfig config) {
        if (!this.starRocksSchema.isPrimaryKey() && config.isPartialUpdate()) {
            String errMsg = String.format("Table %s.%s is not a primary key table, and not supports partial update. You could create a primary key table, or remove the option 'starrocks.write.properties.partial_update'.", config.getDatabase(), config.getTable());
            throw new StarrocksException(errMsg);
        }
    }
}

