/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql;

import com.starrocks.connector.spark.exception.StarrocksException;
import com.starrocks.connector.spark.sql.conf.StarRocksConfigBase;
import com.starrocks.connector.spark.sql.conf.WriteStarRocksConfig;
import java.io.Serializable;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Or;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;

public final class Utils$ {
    public static Utils$ MODULE$;

    static {
        new Utils$();
    }

    public String quote(String colName) {
        return new StringBuilder(2).append("`").append(colName).append("`").toString();
    }

    public Option<String> compileFilter(Filter filter, JdbcDialect dialect, int inValueLengthLimit) {
        String string;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attribute = equalTo.attribute();
            Object value = equalTo.value();
            string = new StringBuilder(3).append(this.quote(attribute)).append(" = ").append(dialect.compileValue(value)).toString();
        } else if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            string = new StringBuilder(3).append(this.quote(attribute)).append(" > ").append(dialect.compileValue(value)).toString();
        } else if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            string = new StringBuilder(4).append(this.quote(attribute)).append(" >= ").append(dialect.compileValue(value)).toString();
        } else if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            string = new StringBuilder(3).append(this.quote(attribute)).append(" < ").append(dialect.compileValue(value)).toString();
        } else if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            string = new StringBuilder(4).append(this.quote(attribute)).append(" <= ").append(dialect.compileValue(value)).toString();
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values = in.values();
            string = Predef$.MODULE$.genericArrayOps((Object)values).isEmpty() || values.length >= inValueLengthLimit ? null : new StringBuilder(6).append(this.quote(attribute)).append(" in (").append(dialect.compileValue((Object)values)).append(")").toString();
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            string = new StringBuilder(8).append(this.quote(attribute)).append(" is null").toString();
        } else if (filter2 instanceof IsNotNull) {
            IsNotNull isNotNull = (IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            string = new StringBuilder(12).append(this.quote(attribute)).append(" is not null").toString();
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            Seq and2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{left, right}))).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Option$.MODULE$.option2Iterable(MODULE$.compileFilter((Filter)x$1, dialect, inValueLengthLimit)), Seq$.MODULE$.canBuildFrom());
            string = and2.size() == 2 ? ((TraversableOnce)and2.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" and ") : null;
        } else if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            Seq or2 = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{left, right}))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(MODULE$.compileFilter((Filter)x$2, dialect, inValueLengthLimit)), Seq$.MODULE$.canBuildFrom());
            string = or2.size() == 2 ? ((TraversableOnce)or2.map((Function1 & Serializable & scala.Serializable)p -> new StringBuilder(2).append("(").append((String)p).append(")").toString(), Seq$.MODULE$.canBuildFrom())).mkString(" or ") : null;
        } else {
            string = null;
        }
        return Option$.MODULE$.apply((Object)string);
    }

    public Map<String, String> params(Map<String, String> parameters, Logger logger) {
        Map map;
        Option option;
        Map dottedParams = (Map)parameters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = k.startsWith(WriteStarRocksConfig.WRITE_PREFIX) ? new Tuple2((Object)k, (Object)v) : new Tuple2((Object)k.replace('_', '.'), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Option preferredTableIdentifier = dottedParams.get((Object)"starrocks.table.identifier").orElse((Function0 & Serializable & scala.Serializable)() -> dottedParams.get((Object)"table.identifier"));
        logger.debug(new StringBuilder(33).append("preferred Table Identifier is '").append(preferredTableIdentifier).append("'.").toString());
        Map prefixParams = (Map)dottedParams.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            Tuple2 tuple22 = k.startsWith("starrocks.") ? new Tuple2((Object)k, (Object)v) : new Tuple2((Object)new StringBuilder(10).append("starrocks.").append(k).toString(), (Object)v);
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        Map replaceParams = (Map)prefixParams.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            String string;
            String string2;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null && "starrocks.request.auth.password".equals(string2 = (String)tuple2._1())) {
                logger.error(new StringBuilder(67).append("starrocks.request.auth.password").append(" cannot use in StarRocks Datasource.").toString());
                throw new StarrocksException(new StringBuilder(106).append("starrocks.request.auth.password").append(" cannot use in").append(" StarRocks Datasource, use 'password' option to set password.").toString());
            }
            if (tuple2 != null && "starrocks.request.auth.user".equals(string = (String)tuple2._1())) {
                logger.error(new StringBuilder(63).append("starrocks.request.auth.user").append(" cannot use in StarRocks Datasource.").toString());
                throw new StarrocksException(new StringBuilder(94).append("starrocks.request.auth.user").append(" cannot use in").append(" StarRocks Datasource, use 'user' option to set user.").toString());
            }
            if (tuple2 != null) {
                String string3 = (String)tuple2._1();
                String v = (String)tuple2._2();
                if ("starrocks.password".equals(string3)) {
                    return new Tuple2((Object)"starrocks.request.auth.password", (Object)v);
                }
            }
            if (tuple2 != null) {
                String string4 = (String)tuple2._1();
                String v = (String)tuple2._2();
                if ("starrocks.user".equals(string4)) {
                    return new Tuple2((Object)"starrocks.request.auth.user", (Object)v);
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            return new Tuple2((Object)k, (Object)v);
        }, Map$.MODULE$.canBuildFrom());
        Map processedParams = replaceParams.$plus$plus((GenTraversableOnce)prefixParams);
        if (!dottedParams.contains((Object)"starrocks.fenodes") && dottedParams.contains((Object)StarRocksConfigBase.KEY_FE_HTTP)) {
            processedParams = processedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"starrocks.fenodes"), dottedParams.apply((Object)StarRocksConfigBase.KEY_FE_HTTP)));
        }
        if (dottedParams.contains((Object)"starrocks.fenodes") && !dottedParams.contains((Object)StarRocksConfigBase.KEY_FE_HTTP)) {
            processedParams = processedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)StarRocksConfigBase.KEY_FE_HTTP), dottedParams.apply((Object)"starrocks.fenodes")));
        }
        if ((option = preferredTableIdentifier) instanceof Some) {
            Some some = (Some)option;
            String tableIdentifier = (String)some.value();
            map = processedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"starrocks.table.identifier"), (Object)tableIdentifier));
        } else if (None$.MODULE$.equals(option)) {
            map = processedParams;
        } else {
            throw new MatchError((Object)option);
        }
        Map finalParams = map;
        finalParams.getOrElse((Object)"starrocks.table.identifier", (Function0 & Serializable & scala.Serializable)() -> {
            throw new StarrocksException("table identifier must be specified for StarRocks table identifier.");
        });
        return finalParams;
    }

    private Utils$() {
        MODULE$ = this;
    }
}

