/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.conf;

import com.starrocks.connector.spark.rest.RestService;
import com.starrocks.connector.spark.sql.conf.StarRocksConfig;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StarRocksConfigBase
implements StarRocksConfig {
    private static final Logger LOG = LoggerFactory.getLogger(StarRocksConfigBase.class);
    public static final String KEY_FE_HTTP = "starrocks.fe.http.url";
    static final String KEY_FE_JDBC = "starrocks.fe.jdbc.url";
    static final String KEY_TABLE_IDENTIFIER = "starrocks.table.identifier";
    static final String KEY_USERNAME = "starrocks.user";
    static final String KEY_PASSWORD = "starrocks.password";
    static final String KEY_REQUEST_RETRIES = "starrocks.request.retries";
    static final String KEY_REQUEST_CONNECT_TIMEOUT = "starrocks.request.connect.timeout.ms";
    static final String KEY_REQUEST_SOCKET_TIMEOUT = "starrocks.request.read.timeout.ms";
    public static final String KEY_COLUMNS = "starrocks.columns";
    public static final String KEY_COLUMN_TYPES = "starrocks.column.types";
    protected final Map<String, String> originOptions;
    private String[] feHttpUrls;
    private String feJdbcUrl;
    private String username;
    private String password;
    private String database;
    private String table;
    @Nullable
    private String[] columns;
    @Nullable
    private String columnTypes;
    private int httpRequestRetries;
    private int httpRequestConnectTimeoutMs;
    private int httpRequestSocketTimeoutMs;
    private ZoneId timeZone;

    public StarRocksConfigBase(Map<String, String> options) {
        this.originOptions = new HashMap<String, String>(options);
        this.load();
    }

    private void load() {
        this.feHttpUrls = this.getArray(KEY_FE_HTTP, new String[0]);
        this.feJdbcUrl = this.get(KEY_FE_JDBC);
        this.username = this.get(KEY_USERNAME);
        this.password = this.get(KEY_PASSWORD);
        String identifier = this.get(KEY_TABLE_IDENTIFIER);
        try {
            String[] parsedResult = RestService.parseIdentifier(identifier, LOG);
            this.database = parsedResult[0];
            this.table = parsedResult[1];
        }
        catch (Exception e) {
            LOG.error("Failed to parse table identifier: {}", (Object)identifier, (Object)e);
            throw new RuntimeException(e);
        }
        this.columns = this.getArray(KEY_COLUMNS, null);
        this.columnTypes = this.get(KEY_COLUMN_TYPES);
        this.httpRequestRetries = this.getInt(KEY_REQUEST_RETRIES, 3);
        this.httpRequestConnectTimeoutMs = this.getInt(KEY_REQUEST_CONNECT_TIMEOUT, 30000);
        this.httpRequestSocketTimeoutMs = this.getInt(KEY_REQUEST_SOCKET_TIMEOUT, 30000);
        String tz = this.get("starrocks.timezone");
        this.timeZone = tz == null ? ZoneId.systemDefault() : ZoneId.of(this.get("starrocks.timezone"));
    }

    @Override
    public Map<String, String> getOriginOptions() {
        return this.originOptions;
    }

    @Override
    public String[] getFeHttpUrls() {
        return this.feHttpUrls;
    }

    @Override
    public String getFeJdbcUrl() {
        return this.feJdbcUrl;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public int getHttpRequestRetries() {
        return this.httpRequestRetries;
    }

    @Override
    public int getHttpRequestConnectTimeoutMs() {
        return this.httpRequestConnectTimeoutMs;
    }

    @Override
    public int getHttpRequestSocketTimeoutMs() {
        return this.httpRequestSocketTimeoutMs;
    }

    @Override
    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    @Nullable
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    @Nullable
    public String getColumnTypes() {
        return this.columnTypes;
    }

    protected String get(String key) {
        return this.get(key, null);
    }

    protected String get(String key, String defaultValue) {
        String value = this.getOriginOptions().get(key);
        return value != null ? value : defaultValue;
    }

    protected boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RuntimeException(value + " is not a boolean string");
    }

    protected int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Integer.parseInt(this.get(key));
    }

    protected Integer getInt(String key) {
        String value = this.get(key);
        return value == null ? null : Integer.valueOf(Integer.parseInt(value));
    }

    protected long getLong(String key, long defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Long.parseLong(value);
    }

    protected Long getLong(String key) {
        String value = this.get(key);
        return value == null ? null : Long.valueOf(Long.parseLong(value));
    }

    protected String[] getArray(String key, String[] defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : (String[])Arrays.stream(value.split(",")).map(String::trim).toArray(String[]::new);
    }
}

