/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.starrocks.connector.spark.sql.schema.InternalRowToRowFunction;
import com.starrocks.connector.spark.sql.schema.RowStringConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.StructType;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public abstract class AbstractRowStringConverter
implements RowStringConverter,
Serializable {
    private final Function<InternalRow, Row> internalRowConverter;
    private final DateTimeFormatter instantFormatter;
    protected final Function<Object, Object>[] valueConverters;

    public AbstractRowStringConverter(StructType schema, ZoneId timeZone) {
        this.internalRowConverter = new InternalRowToRowFunction(schema);
        this.instantFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss[.SSSSSS]").withZone(timeZone);
        this.valueConverters = new Function[schema.length()];
        for (int i = 0; i < schema.size(); ++i) {
            this.valueConverters[i] = this.convert(schema.fields()[i].dataType());
        }
    }

    @Override
    public String fromRow(InternalRow row) {
        return this.fromRow(this.internalRowConverter.apply(row));
    }

    protected Function<Object, Object> convert(DataType dataType) {
        try {
            if (DataTypes.StringType.acceptsType(dataType) || DataTypes.BooleanType.acceptsType(dataType) || DataTypes.DoubleType.acceptsType(dataType) || DataTypes.FloatType.acceptsType(dataType) || DataTypes.ByteType.acceptsType(dataType) || DataTypes.IntegerType.acceptsType(dataType) || DataTypes.LongType.acceptsType(dataType) || DataTypes.ShortType.acceptsType(dataType)) {
                return arg -> arg;
            }
            if (DataTypes.DateType.acceptsType(dataType)) {
                return new NullableWrapper(Object::toString);
            }
            if (DataTypes.TimestampType.acceptsType(dataType)) {
                return new NullableWrapper(arg -> {
                    if (arg instanceof Timestamp) {
                        return this.instantFormatter.format(((Timestamp)arg).toInstant());
                    }
                    return this.instantFormatter.format((Instant)arg);
                });
            }
            if (dataType instanceof DecimalType) {
                return new NullableWrapper(arg -> arg instanceof BigDecimal ? arg : ((Decimal)arg).toBigDecimal().bigDecimal());
            }
            if (dataType instanceof ArrayType) {
                DataType elementType = ((ArrayType)dataType).elementType();
                return new NullableWrapper(new ListDataConverter(this.convert(elementType)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(String.format("Invalid type %s", dataType));
    }

    private static class ListDataConverter
    implements Function<Object, Object> {
        private final Function<Object, Object> elementConverter;

        public ListDataConverter(Function<Object, Object> elementConverter) {
            this.elementConverter = elementConverter;
        }

        @Override
        public Object apply(Object data) {
            List input = data instanceof List ? (List)data : JavaConverters.seqAsJavaList((Seq)((Seq)data));
            ArrayList result = new ArrayList(input.size());
            input.forEach(element -> result.add(this.elementConverter.apply(element)));
            return result;
        }
    }

    private static class NullableWrapper
    implements Function<Object, Object> {
        private final Function<Object, Object> function;

        public NullableWrapper(Function<Object, Object> function) {
            this.function = function;
        }

        @Override
        public Object apply(Object data) {
            return data == null ? null : this.function.apply(data);
        }
    }
}

