/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.starrocks.connector.spark.sql.schema.AbstractRowStringConverter;
import java.time.ZoneId;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class CsvRowStringConverter
extends AbstractRowStringConverter {
    private final String separator;

    public CsvRowStringConverter(StructType schema, String separator, ZoneId timeZone) {
        super(schema, timeZone);
        this.separator = separator;
    }

    @Override
    public String fromRow(Row row) {
        if (row.schema() == null) {
            throw new RuntimeException("Can't convert Row without schema");
        }
        String[] data = new String[row.length()];
        for (int i = 0; i < row.length(); ++i) {
            if (row.isNullAt(i)) continue;
            data[i] = this.valueConverters[i].apply(row.get(i)).toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < data.length; ++idx) {
            String val = data[idx];
            sb.append((Object)(null == val ? "\\N" : val));
            if (idx >= data.length - 1) continue;
            sb.append(this.separator);
        }
        return sb.toString();
    }
}

