/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.starrocks.connector.spark.exception.StarrocksException;
import com.starrocks.connector.spark.sql.conf.SimpleStarRocksConfig;
import com.starrocks.connector.spark.sql.conf.StarRocksConfig;
import com.starrocks.connector.spark.sql.connect.StarRocksConnector;
import com.starrocks.connector.spark.sql.schema.StarRocksField;
import com.starrocks.connector.spark.sql.schema.StarRocksSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public final class InferSchema {
    public static StructType inferSchema(Map<String, String> options) {
        SimpleStarRocksConfig config = new SimpleStarRocksConfig(options);
        StarRocksSchema starocksSchema = StarRocksConnector.getSchema(config);
        return InferSchema.inferSchema(starocksSchema, config);
    }

    public static StructType inferSchema(StarRocksSchema starRocksSchema, StarRocksConfig config) {
        List<StarRocksField> starRocksFields;
        String[] inputColumns = config.getColumns();
        if (inputColumns == null || inputColumns.length == 0) {
            starRocksFields = starRocksSchema.getColumns();
        } else {
            starRocksFields = new ArrayList<StarRocksField>();
            ArrayList<String> nonExistedColumns = new ArrayList<String>();
            for (String column : inputColumns) {
                StarRocksField field = starRocksSchema.getField(column);
                if (field == null) {
                    nonExistedColumns.add(column);
                }
                starRocksFields.add(field);
            }
            if (!nonExistedColumns.isEmpty()) {
                throw new StarrocksException(String.format("Can't find those columns %s in StarRocks table `%s`.`%s`. Please check your configuration 'starrocks.columns' to make sure all columns exist in the table", nonExistedColumns, config.getDatabase(), config.getTable()));
            }
        }
        Map<String, StructField> customTypes = InferSchema.parseCustomTypes(config.getColumnTypes());
        ArrayList<StructField> fields = new ArrayList<StructField>();
        for (StarRocksField field : starRocksFields) {
            if (customTypes.containsKey(field.getName())) {
                fields.add(customTypes.get(field.getName()));
                continue;
            }
            fields.add(InferSchema.inferStructField(field));
        }
        return DataTypes.createStructType(fields);
    }

    static Map<String, StructField> parseCustomTypes(String columnTypes) {
        if (columnTypes == null) {
            return new HashMap<String, StructField>();
        }
        HashMap<String, StructField> customTypes = new HashMap<String, StructField>();
        StructType customSchema = StructType.fromDDL((String)columnTypes);
        for (StructField field : customSchema.fields()) {
            customTypes.put(field.name(), field);
        }
        return customTypes;
    }

    static StructField inferStructField(StarRocksField field) {
        DataType dataType = InferSchema.inferDataType(field);
        return new StructField(field.getName(), dataType, true, Metadata.empty());
    }

    static DataType inferDataType(StarRocksField field) {
        String type;
        switch (type = field.getType().toLowerCase(Locale.ROOT)) {
            case "tinyint": {
                return field.getSize() == null ? DataTypes.BooleanType : DataTypes.ByteType;
            }
            case "smallint": {
                return DataTypes.ShortType;
            }
            case "int": {
                return DataTypes.IntegerType;
            }
            case "bigint": {
                return DataTypes.LongType;
            }
            case "bigint unsigned": {
                return DataTypes.StringType;
            }
            case "float": {
                return DataTypes.FloatType;
            }
            case "double": {
                return DataTypes.DoubleType;
            }
            case "decimal": {
                return DataTypes.createDecimalType((int)Integer.parseInt(field.getSize()), (int)Integer.parseInt(field.getScale()));
            }
            case "char": 
            case "varchar": 
            case "json": {
                return DataTypes.StringType;
            }
            case "date": {
                return DataTypes.DateType;
            }
            case "datetime": {
                return DataTypes.TimestampType;
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported starrocks type, column name: %s, data type: %s", field.getName(), field.getType()));
    }
}

