/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.SimpleAnalyzer$;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder$;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.types.StructType;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.Seq$;

public class InternalRowToRowFunction
implements Function<InternalRow, Row>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final ExpressionEncoder.Deserializer<Row> deserializer;

    public InternalRowToRowFunction(StructType schema) {
        ExpressionEncoder rowExpressionEncoder;
        RowEncoder$ instance;
        Method applyMethod;
        try {
            applyMethod = RowEncoder$.MODULE$.getClass().getMethod("apply", StructType.class);
            instance = RowEncoder$.MODULE$;
        }
        catch (NoSuchMethodException e1) {
            try {
                applyMethod = ExpressionEncoder$.MODULE$.getClass().getMethod("apply", StructType.class);
                instance = ExpressionEncoder$.MODULE$;
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException("No method to create InternalRowToRowFunction");
            }
        }
        try {
            rowExpressionEncoder = (ExpressionEncoder)applyMethod.invoke((Object)instance, schema);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Fail to call `apply` method to create InternalRowToRowFunction");
        }
        List attributeList = Arrays.stream(rowExpressionEncoder.schema().fields()).map(x -> new AttributeReference(x.name(), x.dataType(), x.nullable(), x.metadata(), NamedExpression.newExprId(), (Seq)Seq$.MODULE$.empty())).collect(Collectors.toList());
        Seq attributeSeq = JavaConverters.collectionAsScalaIterable(attributeList).toSeq();
        this.deserializer = rowExpressionEncoder.resolveAndBind(attributeSeq, (Analyzer)SimpleAnalyzer$.MODULE$).createDeserializer();
    }

    @Override
    public Row apply(InternalRow internalRow) {
        return (Row)this.deserializer.apply(internalRow);
    }
}

