/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.schema;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.starrocks.connector.spark.sql.schema.AbstractRowStringConverter;
import com.starrocks.connector.spark.util.JsonUtils;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONRowStringConverter
extends AbstractRowStringConverter {
    private static final Logger LOG = LoggerFactory.getLogger(JSONRowStringConverter.class);
    private final String[] streamLoadColumnNames;
    private final boolean[] isStarRocksJsonType;
    private final ObjectMapper mapper;

    public JSONRowStringConverter(StructType schema, String[] streamLoadColumnNames, Set<String> jsonColumnNames, ZoneId timeZone) {
        super(schema, timeZone);
        this.streamLoadColumnNames = streamLoadColumnNames;
        this.mapper = JsonUtils.createObjectMapper();
        this.isStarRocksJsonType = new boolean[streamLoadColumnNames.length];
        for (int i = 0; i < streamLoadColumnNames.length; ++i) {
            this.isStarRocksJsonType[i] = jsonColumnNames.contains(streamLoadColumnNames[i]);
        }
    }

    @Override
    public String fromRow(Row row) {
        if (row.schema() == null) {
            throw new RuntimeException("Can't convert Row without schema");
        }
        HashMap nonJsonColumnData = new HashMap();
        HashMap jsonColumnData = new HashMap();
        for (int i = 0; i < row.length(); ++i) {
            StructField field = row.schema().apply(i);
            if (field.nullable() && row.isNullAt(i)) continue;
            if (!this.isStarRocksJsonType[i]) {
                nonJsonColumnData.put(this.streamLoadColumnNames[i], this.valueConverters[i].apply(row.get(i)));
                continue;
            }
            jsonColumnData.put(this.streamLoadColumnNames[i], this.valueConverters[i].apply(row.get(i)));
        }
        try {
            String result = this.mapper.writeValueAsString(nonJsonColumnData);
            if (!jsonColumnData.isEmpty()) {
                StringBuilder builder = new StringBuilder();
                builder.append(result, 0, result.length() - 1);
                for (Map.Entry entry : jsonColumnData.entrySet()) {
                    builder.append(",\"");
                    builder.append((String)entry.getKey());
                    builder.append("\":");
                    builder.append(entry.getValue());
                }
                builder.append("}");
                result = builder.toString();
            }
            return result;
        }
        catch (Exception e) {
            LOG.error("Failed to serialize row to json, data: {}", nonJsonColumnData, (Object)e);
            throw new RuntimeException(e);
        }
    }
}

