/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.sql.write;

import com.starrocks.connector.spark.sql.conf.WriteStarRocksConfig;
import com.starrocks.connector.spark.sql.write.StarRocksWrite;
import org.apache.spark.sql.connector.distributions.Distribution;
import org.apache.spark.sql.connector.distributions.Distributions;
import org.apache.spark.sql.connector.expressions.Expression;
import org.apache.spark.sql.connector.expressions.Expressions;
import org.apache.spark.sql.connector.expressions.SortOrder;
import org.apache.spark.sql.connector.write.BatchWrite;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.RequiresDistributionAndOrdering;
import org.apache.spark.sql.connector.write.Write;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;

public class StarRocksWriteBuilder
implements WriteBuilder {
    private final LogicalWriteInfo info;
    private final WriteStarRocksConfig config;

    public StarRocksWriteBuilder(LogicalWriteInfo info, WriteStarRocksConfig config) {
        this.info = info;
        this.config = config;
    }

    public Write build() {
        return new StarRocksWriteImpl(this.info, this.config);
    }

    private static class StarRocksWriteImpl
    implements Write,
    RequiresDistributionAndOrdering {
        private final LogicalWriteInfo info;
        private final WriteStarRocksConfig config;

        public StarRocksWriteImpl(LogicalWriteInfo info, WriteStarRocksConfig config) {
            this.info = info;
            this.config = config;
        }

        public String description() {
            return String.format("StarRocksWriteImpl[%s.%s]", this.config.getDatabase(), this.config.getTable());
        }

        public BatchWrite toBatch() {
            return new StarRocksWrite(this.info, this.config);
        }

        public StreamingWrite toStreaming() {
            return new StarRocksWrite(this.info, this.config);
        }

        public int requiredNumPartitions() {
            return this.config.getNumPartitions();
        }

        public Distribution requiredDistribution() {
            if (this.config.getNumPartitions() <= 0) {
                return Distributions.unspecified();
            }
            String[] partitionColumns = this.config.getPartitionColumns();
            if (partitionColumns == null) {
                partitionColumns = this.info.schema().names();
            }
            Expression[] expressions = new Expression[partitionColumns.length];
            for (int i = 0; i < partitionColumns.length; ++i) {
                expressions[i] = Expressions.column((String)partitionColumns[i]);
            }
            return Distributions.clustered((Expression[])expressions);
        }

        public SortOrder[] requiredOrdering() {
            return new SortOrder[0];
        }
    }
}

