/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.util;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvUtils {
    public static GitInformation getGitInformation() {
        return GitInformation.INSTANCE;
    }

    private static final class GitInformation {
        private static final Logger LOG = LoggerFactory.getLogger(GitInformation.class);
        private static final String PROP_FILE = "starrocks-spark-connector-git.properties";
        private static final String UNKNOWN = "unknown";
        private static final GitInformation INSTANCE = new GitInformation();
        private String gitBuildTime = "unknown";
        private String gitCommitId = "unknown";
        private String gitCommitIdAbbrev = "unknown";
        private String gitCommitTime = "unknown";

        private String getProperty(Properties properties, String key, String defaultValue) {
            String value = properties.getProperty(key);
            if (value == null || value.charAt(0) == '$') {
                return defaultValue;
            }
            return value;
        }

        public GitInformation() {
            ClassLoader classLoader = EnvUtils.class.getClassLoader();
            try (InputStream propFile = classLoader.getResourceAsStream(PROP_FILE);){
                if (propFile != null) {
                    Properties properties = new Properties();
                    properties.load(propFile);
                    this.gitBuildTime = this.getProperty(properties, "git.build.time", UNKNOWN);
                    this.gitCommitId = this.getProperty(properties, "git.commit.id", UNKNOWN);
                    this.gitCommitIdAbbrev = this.getProperty(properties, "git.commit.id.abbrev", UNKNOWN);
                    this.gitCommitTime = this.getProperty(properties, "git.commit.time", UNKNOWN);
                }
            }
            catch (Exception e) {
                LOG.warn("Can't load git information, exception message: {}", (Object)e.getMessage());
            }
        }

        public String getGitBuildTime() {
            return this.gitBuildTime;
        }

        public String getGitCommitId() {
            return this.gitCommitId;
        }

        public String getGitCommitIdAbbrev() {
            return this.gitCommitIdAbbrev;
        }

        public String getGitCommitTime() {
            return this.gitCommitTime;
        }

        public String toString() {
            return "GitInformation{gitBuildTime='" + this.gitBuildTime + '\'' + ", gitCommitId='" + this.gitCommitId + '\'' + ", gitCommitIdAbbrev='" + this.gitCommitIdAbbrev + '\'' + ", gitCommitTime='" + this.gitCommitTime + '\'' + '}';
        }
    }
}

