/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.connector.spark.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);
    private static final boolean SUPPORT_MAX_STRING_LENGTH = JsonUtils.checkSupportMaxStringLength();

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        JsonUtils.setMaxStringLength(mapper.getFactory(), 0x40000000);
        return mapper;
    }

    private static boolean checkSupportMaxStringLength() {
        try {
            Class.forName("com.fasterxml.jackson.core.StreamReadConstraints");
            LOG.info("jackson-core supports to set max string length");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.info("jackson-core does not support to set max string length");
            return false;
        }
    }

    private static void setMaxStringLength(JsonFactory jsonFactory, int maxStringLen) {
        if (!SUPPORT_MAX_STRING_LENGTH) {
            return;
        }
        try {
            Field constraintsField = JsonFactory.class.getDeclaredField("_streamReadConstraints");
            constraintsField.setAccessible(true);
            Object constraints = constraintsField.get(jsonFactory);
            Field maxStringLenField = constraints.getClass().getDeclaredField("_maxStringLen");
            maxStringLenField.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(maxStringLenField, maxStringLenField.getModifiers() & 0xFFFFFFEF);
            maxStringLenField.setInt(constraints, maxStringLen);
        }
        catch (Exception e) {
            LOG.warn("Failed to set max string length {}", (Object)maxStringLen, (Object)e);
        }
    }
}

