/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.starrocks.data.load.stream.StreamLoadManager;
import com.starrocks.data.load.stream.StreamLoadResponse;
import com.starrocks.data.load.stream.StreamLoadSnapshot;
import com.starrocks.data.load.stream.StreamLoadUtils;
import com.starrocks.data.load.stream.StreamLoader;
import com.starrocks.data.load.stream.TableRegion;
import com.starrocks.data.load.stream.TransactionStatus;
import com.starrocks.data.load.stream.exception.StreamLoadFailException;
import com.starrocks.data.load.stream.properties.StreamLoadProperties;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultStreamLoader
implements StreamLoader,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(DefaultStreamLoader.class);
    private static final int ERROR_LOG_MAX_LENGTH = 3000;
    protected StreamLoadProperties properties;
    private StreamLoadManager manager;
    private HttpClientBuilder clientBuilder;
    private Header[] defaultHeaders;
    private ScheduledExecutorService executorService;
    private boolean enableTransaction = false;
    private volatile long availableHostPos;
    private final AtomicBoolean start = new AtomicBoolean(false);
    protected volatile ObjectMapper objectMapper;

    protected void enableTransaction() {
        this.enableTransaction = true;
    }

    @Override
    public void start(StreamLoadProperties properties, StreamLoadManager manager) {
        if (this.start.compareAndSet(false, true)) {
            this.objectMapper = new ObjectMapper();
            this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.objectMapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
            this.properties = properties;
            this.manager = manager;
            this.initDefaultHeaders(properties);
            this.clientBuilder = HttpClients.custom().setRequestExecutor(new HttpRequestExecutor(properties.getWaitForContinueTimeoutMs())).setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

                protected boolean isRedirectable(String method) {
                    return true;
                }
            });
            this.executorService = new ScheduledThreadPoolExecutor(properties.getIoThreadCount(), r -> {
                Thread thread = new Thread(null, r, "I/O client dispatch - " + UUID.randomUUID());
                thread.setDaemon(true);
                thread.setUncaughtExceptionHandler((t, e) -> {
                    log.error("Stream loader " + Thread.currentThread().getName() + " error", e);
                    manager.callback(e);
                });
                return thread;
            });
            String propertiesStr = "";
            String headerStr = "";
            try {
                propertiesStr = this.objectMapper.writeValueAsString((Object)properties);
                headerStr = this.objectMapper.writeValueAsString((Object)this.defaultHeaders);
            }
            catch (Exception e) {
                log.warn("Failed to convert properties and headers to json", (Throwable)e);
            }
            log.info("Default Stream Loader start, properties : {}, defaultHeaders : {}", (Object)propertiesStr, (Object)headerStr);
        }
    }

    @Override
    public void close() {
        if (this.start.compareAndSet(true, false)) {
            this.executorService.shutdownNow();
            log.info("Default Stream loader closed");
        }
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean begin(TableRegion region) {
        region.setLabel(region.getLabelGenerator().next());
        return true;
    }

    @Override
    public Future<StreamLoadResponse> send(TableRegion region) {
        if (!this.start.get()) {
            log.warn("Stream load not start");
        }
        if (this.begin(region)) {
            return this.executorService.submit(() -> this.sendToSR(region));
        }
        region.fail(new StreamLoadFailException("Transaction start failed, db : " + region.getDatabase()));
        return null;
    }

    @Override
    public Future<StreamLoadResponse> send(TableRegion region, int delayMs) {
        if (!this.start.get()) {
            log.warn("Stream load not start");
        }
        if (this.begin(region)) {
            return this.executorService.schedule(() -> this.sendToSR(region), (long)delayMs, TimeUnit.MILLISECONDS);
        }
        region.fail(new StreamLoadFailException("Transaction start failed, db : " + region.getDatabase()));
        return null;
    }

    @Override
    public boolean prepare(StreamLoadSnapshot.Transaction transaction) {
        return true;
    }

    @Override
    public boolean commit(StreamLoadSnapshot.Transaction transaction) {
        return true;
    }

    @Override
    public boolean rollback(StreamLoadSnapshot.Transaction transaction) {
        return true;
    }

    @Override
    public boolean prepare(StreamLoadSnapshot snapshot) {
        boolean succeed = true;
        for (StreamLoadSnapshot.Transaction transaction : snapshot.getTransactions()) {
            boolean prepared = false;
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException e) {
                    log.warn("prepare interrupted");
                    return false;
                }
                if (!this.prepare(transaction)) continue;
                prepared = true;
                break;
            }
            if (prepared) continue;
            succeed = false;
            break;
        }
        return succeed;
    }

    @Override
    public boolean commit(StreamLoadSnapshot snapshot) {
        boolean committed = true;
        for (StreamLoadSnapshot.Transaction transaction : snapshot.getTransactions()) {
            if (transaction.isFinish()) continue;
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(i * 1000);
                }
                catch (InterruptedException e) {
                    log.warn("commit interrupted");
                    return false;
                }
                if (!this.commit(transaction)) continue;
                transaction.setFinish(true);
                break;
            }
            if (transaction.isFinish()) continue;
            committed = false;
        }
        return committed;
    }

    @Override
    public boolean rollback(StreamLoadSnapshot snapshot) {
        boolean rollback = true;
        block0: for (StreamLoadSnapshot.Transaction transaction : snapshot.getTransactions()) {
            if (transaction.isFinish()) continue;
            for (int i = 0; i < 3; ++i) {
                if (this.rollback(transaction)) {
                    transaction.setFinish(true);
                    continue block0;
                }
                if (transaction.isFinish()) continue;
                rollback = false;
            }
        }
        return rollback;
    }

    protected void initDefaultHeaders(StreamLoadProperties properties) {
        HashMap<String, String> headers = new HashMap<String, String>(properties.getHeaders());
        if (!headers.containsKey("timeout")) {
            headers.put("timeout", "600");
        }
        headers.put("Authorization", StreamLoadUtils.getBasicAuthHeader(properties.getUsername(), properties.getPassword()));
        headers.put("Expect", "100-continue");
        this.defaultHeaders = (Header[])headers.entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), (String)entry.getValue())).toArray(Header[]::new);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StreamLoadResponse sendToSR(TableRegion region) {
        try {
            String host = this.getAvailableHost();
            String sendUrl = this.getSendUrl(host, region.getDatabase(), region.getTable());
            String label = region.getLabel();
            HttpPut httpPut = new HttpPut(sendUrl);
            httpPut.setConfig(RequestConfig.custom().setSocketTimeout(this.properties.getSocketTimeout()).setExpectContinueEnabled(true).setRedirectsEnabled(true).build());
            httpPut.setEntity(region.getHttpEntity());
            httpPut.setHeaders(this.defaultHeaders);
            for (Map.Entry<String, String> entry : region.getHeaders().entrySet()) {
                httpPut.removeHeaders(entry.getKey());
                httpPut.addHeader(entry.getKey(), entry.getValue());
            }
            httpPut.addHeader("label", label);
            log.info("Stream loading, label : {}, region : {}, request : {}", new Object[]{label, region.getUniqueKey(), httpPut});
            try {
                Throwable throwable = null;
                try (CloseableHttpClient client = this.clientBuilder.build();){
                    String responseBody;
                    long startNanoTime = System.nanoTime();
                    try (CloseableHttpResponse response = client.execute((HttpUriRequest)httpPut);){
                        responseBody = this.parseHttpResponse("load", region.getDatabase(), region.getTable(), label, response);
                    }
                    log.info("Stream load completed, label : {}, database : {}, table : {}, body : {}", new Object[]{label, region.getDatabase(), region.getTable(), responseBody});
                    StreamLoadResponse streamLoadResponse = new StreamLoadResponse();
                    StreamLoadResponse.StreamLoadResponseBody streamLoadBody = (StreamLoadResponse.StreamLoadResponseBody)this.objectMapper.readValue(responseBody, StreamLoadResponse.StreamLoadResponseBody.class);
                    streamLoadResponse.setBody(streamLoadBody);
                    String status = streamLoadBody.getStatus();
                    if (status == null) {
                        throw new StreamLoadFailException(String.format("Stream load status is null. db: %s, table: %s, label: %s, response body: %s", region.getDatabase(), region.getTable(), label, responseBody));
                    }
                    if ("Success".equals(status) || "OK".equals(status) || "Publish Timeout".equals(status)) {
                        streamLoadResponse.setCostNanoTime(System.nanoTime() - startNanoTime);
                        region.complete(streamLoadResponse);
                    } else {
                        if (!"Label Already Exists".equals(status)) {
                            String errorLog = this.getErrorLog(streamLoadBody.getErrorURL());
                            String errorMsg = String.format("Stream load failed because of error, db: %s, table: %s, label: %s, \nresponseBody: %s\nerrorLog: %s", region.getDatabase(), region.getTable(), label, responseBody, errorLog);
                            throw new StreamLoadFailException(errorMsg, streamLoadBody);
                        }
                        String existingJobStatus = streamLoadBody.getExistingJobStatus();
                        if (!"FINISHED".equals(existingJobStatus)) {
                            String errorMsage = String.format("Stream load failed because label existed, db: %s, table: %s, label: %s, existingJobStatus: %s", region.getDatabase(), region.getTable(), label, existingJobStatus);
                            throw new StreamLoadFailException(errorMsage);
                        }
                        streamLoadResponse.setCostNanoTime(System.nanoTime() - startNanoTime);
                        region.complete(streamLoadResponse);
                    }
                    StreamLoadResponse streamLoadResponse2 = streamLoadResponse;
                    return streamLoadResponse2;
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
            }
            catch (StreamLoadFailException e) {
                throw e;
            }
            catch (Exception e) {
                String string = String.format("Stream load failed because of unknown exception, db: %s, table: %s, label: %s", region.getDatabase(), region.getTable(), label);
                throw new StreamLoadFailException(string, e);
            }
        }
        catch (Exception e) {
            log.error("Exception happens when sending data, thread: {}", (Object)Thread.currentThread().getName(), (Object)e);
            region.fail(e);
            return null;
        }
    }

    protected String getAvailableHost() {
        long pos;
        String[] hosts = this.properties.getLoadUrls();
        int size = hosts.length;
        long tmp = pos + (long)size;
        for (pos = this.availableHostPos; pos < tmp; ++pos) {
            String host = hosts[(int)(pos % (long)size)];
            if (!this.testHttpConnection(host)) continue;
            this.availableHostPos = pos;
            return host;
        }
        return null;
    }

    private boolean testHttpConnection(String host) {
        try {
            URL url = new URL(host);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(this.properties.getConnectTimeout());
            connection.connect();
            connection.disconnect();
            return true;
        }
        catch (Exception e) {
            log.warn("Failed to connect to address:{}", (Object)host, (Object)e);
            return false;
        }
    }

    protected String parseHttpResponse(String requestType, String db, String table, String label, CloseableHttpResponse response) throws StreamLoadFailException {
        int code = response.getStatusLine().getStatusCode();
        if (307 == code) {
            String errorMsg = String.format("Request %s failed because http response code is 307 which means 'Temporary Redirect'. This can happen when FE responds the request slowly , you should find the reason first. The reason may be StarRocks FE/Flink/Spark GC, network delay, or others. db: %s, table: %s, label: %s, response status line: %s", requestType, db, table, label, response.getStatusLine());
            log.error("{}", (Object)errorMsg);
            throw new StreamLoadFailException(errorMsg);
        }
        if (401 == code) {
            String errorMsg = String.format("Request %s failed because of access denied. You need to grant at least SELECT and INSERT privilege on %s.%s. label: %s, response status line: %s", requestType, db, table, label, response.getStatusLine());
            log.error("{}", (Object)errorMsg);
            StreamLoadResponse.StreamLoadResponseBody responseBody = new StreamLoadResponse.StreamLoadResponseBody();
            responseBody.setStatus("Fail");
            responseBody.setMessage("Access denied; you need (at least one of) the INSERT privilege(s) for this operation");
            throw new StreamLoadFailException(errorMsg, responseBody);
        }
        if (200 != code) {
            String errorMsg = String.format("Request %s failed because http response code is not 200. db: %s, table: %s,label: %s, response status line: %s", requestType, db, table, label, response.getStatusLine());
            log.error("{}", (Object)errorMsg);
            throw new StreamLoadFailException(errorMsg);
        }
        HttpEntity respEntity = response.getEntity();
        if (respEntity == null) {
            String errorMsg = String.format("Request %s failed because response entity is null. db: %s, table: %s,label: %s, response status line: %s", requestType, db, table, label, response.getStatusLine());
            log.error("{}", (Object)errorMsg);
            throw new StreamLoadFailException(errorMsg);
        }
        try {
            return EntityUtils.toString((HttpEntity)respEntity);
        }
        catch (Exception e) {
            String errorMsg = String.format("Request %s failed because fail to convert response entity to string. db: %s, table: %s, label: %s, response status line: %s, response entity: %s", requestType, db, table, label, response.getStatusLine(), response.getEntity());
            log.error("{}", (Object)errorMsg, (Object)e);
            throw new StreamLoadFailException(errorMsg, e);
        }
    }

    @Override
    public TransactionStatus getLoadStatus(String db, String table, String label) throws Exception {
        String host = this.getAvailableHost();
        String state = this.getLabelState(host, db, table, label, Collections.emptySet());
        return TransactionStatus.valueOf(state.toUpperCase());
    }

    /*
     * Exception decompiling
     */
    protected String getLabelState(String host, String database, String table, String label, Set<String> retryStates) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected String getErrorLog(String errorUrl) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getSendUrl(String host, String database, String table) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + "/api/" + database + "/" + table + "/_stream_load";
    }
}

