/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;

public interface StreamLoadDataFormat {
    public static final StreamLoadDataFormat JSON = new JSONFormat();
    public static final StreamLoadDataFormat CSV = new CSVFormat();

    default public String name() {
        return "";
    }

    public byte[] first();

    public byte[] delimiter();

    public byte[] end();

    public static class JSONFormat
    implements StreamLoadDataFormat,
    Serializable {
        private static final byte[] first = "[".getBytes(StandardCharsets.UTF_8);
        private static final byte[] delimiter = ",".getBytes(StandardCharsets.UTF_8);
        private static final byte[] end = "]".getBytes(StandardCharsets.UTF_8);

        @Override
        public String name() {
            return "json";
        }

        @Override
        public byte[] first() {
            return first;
        }

        @Override
        public byte[] delimiter() {
            return delimiter;
        }

        @Override
        public byte[] end() {
            return end;
        }

        @JsonValue
        public String toString() {
            return "JsonFormat{first=" + new String(first) + ", delimiter=" + new String(delimiter) + ", end=" + new String(end) + '}';
        }
    }

    public static class CSVFormat
    implements StreamLoadDataFormat,
    Serializable {
        private static final byte[] EMPTY_DELIMITER = new byte[0];
        private static final String DEFAULT_LINE_DELIMITER = "\n";
        private final byte[] delimiter;

        public CSVFormat() {
            this(DEFAULT_LINE_DELIMITER);
        }

        public CSVFormat(String rowDelimiter) {
            if (rowDelimiter == null) {
                throw new IllegalArgumentException("row delimiter can not be null");
            }
            this.delimiter = rowDelimiter.getBytes(StandardCharsets.UTF_8);
        }

        @Override
        public String name() {
            return "csv";
        }

        @Override
        public byte[] first() {
            return EMPTY_DELIMITER;
        }

        @Override
        public byte[] delimiter() {
            return this.delimiter;
        }

        @Override
        public byte[] end() {
            return this.delimiter;
        }

        @JsonValue
        public String toString() {
            return "CsvFormat{first=" + new String(EMPTY_DELIMITER) + ", delimiter=" + new String(this.delimiter) + ", end=" + new String(this.delimiter) + '}';
        }
    }
}

