/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.starrocks.data.load.stream.StreamLoadConstants;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamLoadUtils {
    private static final Logger LOG = LoggerFactory.getLogger(StreamLoadUtils.class);

    public static String getTableUniqueKey(String database, String table) {
        return database + "-" + table;
    }

    public static String getStreamLoadUrl(String host, String database, String table) {
        if (host == null) {
            throw new IllegalArgumentException("None of the hosts in `load_url` could be connected.");
        }
        return host + "/api/" + database + "/" + table + "/_stream_load";
    }

    public static String getBasicAuthHeader(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes(StandardCharsets.UTF_8));
        return "Basic " + new String(encodedAuth);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isStarRocksSupportTransactionLoad(List<String> httpUrls, int connectTimeout, String userName, String password) {
        String host = StreamLoadUtils.selectAvailableHttpHost(httpUrls, connectTimeout);
        if (host == null) {
            throw new RuntimeException("Can't find an available host in " + httpUrls);
        }
        String beginUrlStr = StreamLoadConstants.getBeginUrl(host);
        HttpPost httpPost = new HttpPost(beginUrlStr);
        httpPost.addHeader("Authorization", StreamLoadUtils.getBasicAuthHeader(userName, password));
        httpPost.setConfig(RequestConfig.custom().setExpectContinueEnabled(true).setRedirectsEnabled(true).build());
        LOG.debug("Transaction load probe post {}", (Object)httpPost);
        HttpClientBuilder clientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy(){

            protected boolean isRedirectable(String method) {
                return true;
            }
        });
        try (CloseableHttpClient client = clientBuilder.build();){
            String msg;
            CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            LOG.debug("Transaction load probe response {}", (Object)responseBody);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode node = mapper.readTree(responseBody);
            JsonNode statusNode = node.get("status");
            String status = statusNode == null ? null : statusNode.asText();
            JsonNode msgNode = node.get("msg");
            String string = msg = msgNode == null ? null : msgNode.asText();
            if ("FAILED".equals(status) && "Not implemented".equals(msg)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            String errMsg = "Failed to probe transaction load for " + host;
            LOG.warn("{}", (Object)errMsg, (Object)e);
            throw new RuntimeException(errMsg, e);
        }
    }

    public static String selectAvailableHttpHost(List<String> hostList, int connectionTimeout) {
        for (String host : hostList) {
            if (host == null) continue;
            if (!host.startsWith("http")) {
                host = "http://" + host;
            }
            if (!StreamLoadUtils.testHttpConnection(host, connectionTimeout)) continue;
            return host;
        }
        return null;
    }

    public static boolean testHttpConnection(String urlStr, int connectionTimeout) {
        try {
            URL url = new URL(urlStr);
            HttpURLConnection co = (HttpURLConnection)url.openConnection();
            co.setConnectTimeout(connectionTimeout);
            co.connect();
            co.disconnect();
            return true;
        }
        catch (Exception e) {
            LOG.warn("Failed to connect to {}", (Object)urlStr, (Object)e);
            return false;
        }
    }
}

