/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.compress;

import com.starrocks.data.load.stream.StreamLoadDataFormat;
import com.starrocks.data.load.stream.compress.LZ4FrameCompressionCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Optional;

public interface CompressionCodec {
    public OutputStream createCompressionStream(OutputStream var1, long var2) throws IOException;

    public static Optional<CompressionCodec> createCompressionCodec(StreamLoadDataFormat dataFormat, Optional<String> compressionType, Map<String, Object> properties) {
        if (!compressionType.isPresent()) {
            return Optional.empty();
        }
        if ("LZ4_FRAME".equalsIgnoreCase(compressionType.get())) {
            return Optional.of(LZ4FrameCompressionCodec.create(properties));
        }
        throw new UnsupportedOperationException(String.format("Not support to compress format %s with compression type %s", dataFormat.name(), compressionType.get()));
    }
}

