/*
 * Decompiled with CFR 0.152.
 */
package com.starrocks.data.load.stream.compress;

import com.starrocks.data.load.stream.compress.CompressionCodec;
import com.starrocks.data.load.stream.compress.CountingOutputStream;
import com.starrocks.data.load.stream.v2.ChunkHttpEntity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.HttpEntityWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressionHttpEntity
extends HttpEntityWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(CompressionHttpEntity.class);
    private final CompressionCodec compressionCodec;

    public CompressionHttpEntity(ChunkHttpEntity entity, CompressionCodec compressionCodec) {
        super((HttpEntity)entity);
        this.compressionCodec = compressionCodec;
        entity.setLogAfterWrite(false);
    }

    public long getContentLength() {
        return -1L;
    }

    public boolean isChunked() {
        return true;
    }

    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeTo(OutputStream outStream) throws IOException {
        long startTime = System.nanoTime();
        ChunkHttpEntity entity = (ChunkHttpEntity)this.wrappedEntity;
        CountingOutputStream countingOutputStream = new CountingOutputStream(outStream);
        OutputStream compressOutputStream = this.compressionCodec.createCompressionStream(countingOutputStream, entity.getContentLength());
        entity.writeTo(compressOutputStream);
        compressOutputStream.close();
        long rawSize = entity.getContentLength();
        long compressSize = countingOutputStream.getCount();
        float compressRatio = compressSize == 0L ? 1.0f : (float)rawSize / (float)compressSize;
        LOG.info("Write entity for table {}, raw/compressed size:{}/{}, compress ratio:{}, time:{}us", new Object[]{entity.getTableUniqueKey(), rawSize, compressSize, Float.valueOf(compressRatio), (System.nanoTime() - startTime) / 1000L});
    }

    public boolean isStreaming() {
        return false;
    }
}

